/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;

public class TransformContext {
    private final TransformAdapter adapter;
    private final Transform transform;
    private final Violation violation;
    private final Location location;
    private Map<String, Object> attributes;
    private Object applyData;

    public TransformContext(TransformAdapter adapter, Transform transform, Violation violation, Location location) {
        if (location == null) {
            throw new NullArgumentException("null location");
        }
        this.adapter = adapter;
        this.transform = transform;
        this.violation = violation;
        this.location = location;
    }

    public TransformAdapter getAdapter() {
        return this.adapter;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Violation getViolation() {
        return this.violation;
    }

    public Location getLocation() {
        return this.location;
    }

    public ModelAdapter getModel() {
        return this.getLocation().getModel();
    }

    public ModelAdapter getModelAdapter() {
        return this.getLocation().getModel();
    }

    public Node getNode() {
        return this.getLocation().getModel().getNode();
    }

    public Project getProject() {
        return this.getLocation().getProject();
    }

    public Workspace getWorkspace() {
        return this.getLocation().getWorkspace();
    }

    public Context getIdeContext() {
        return new Context(null, this.getWorkspace(), this.getProject(), this.getNode());
    }

    public Rule getRule() {
        return this.violation.getRule();
    }

    public String getVariation() {
        return this.violation.getVariation();
    }

    public Object getParameter(String name) {
        char c;
        int nameLength = name.length();
        if (nameLength == 1 && Character.isDigit(c = name.charAt(0))) {
            int index = c - 48;
            if (index >= this.getParameterCount()) {
                return null;
            }
            return this.getParameterValue(index);
        }
        Object parameter = this.getParameterValue(name);
        if (parameter != null) {
            return parameter;
        }
        StringBuffer methodName = new StringBuffer(3 + nameLength);
        methodName.append("get");
        if (nameLength <= 1) {
            methodName.append(name.charAt(0));
        } else {
            methodName.append(Character.toUpperCase(name.charAt(0)));
            methodName.append(name.substring(1, nameLength));
        }
        try {
            Method method = this.transform.getClass().getMethod(methodName.toString(), null);
            return method.invoke((Object)this.transform, null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Location getFocusLocation() {
        return this.violation.getFocusLocation();
    }

    public int getParameterCount() {
        return this.violation.getParameterCount();
    }

    public String getParameterName(int index) {
        return this.violation.getParameterName(index);
    }

    public Object getParameterValue(int index) {
        return this.violation.getParameterValue(index);
    }

    public Object getParameterValue(String name) {
        int i = this.getParameterCount();
        while (i-- > 0) {
            if (!name.equals(this.getParameterName(i))) continue;
            return this.getParameterValue(i);
        }
        return null;
    }

    public int getTransformCount() {
        return this.violation.getTransformCount();
    }

    public Transform getTransform(int index) {
        return this.violation.getTransform(index);
    }

    public Transform getDefaultTransform() {
        return this.violation.getDefaultTransform();
    }

    public int getSerialNumber() {
        return this.violation.getSerialNumber();
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Object getPredecessorApplyData() {
        return this.applyData;
    }

    public void setSelection(Object construct, int margin, int endMargin) {
        this.setSelection(this.getModel(), construct, margin, endMargin);
    }

    public void setSelection(ModelAdapter model, Object construct, int margin, int endMargin) {
        this.adapter.setSelection(model, construct, margin, endMargin);
    }

    public void addHighlight(Object construct) {
        this.adapter.addHighlight(this.location.getModel(), construct);
    }

    public void addRemovedHighlight(Object construct) {
        this.adapter.addRemovedHighlight(this.location.getModel(), construct);
    }

    public void invokeLater(Command command) {
        this.adapter.invokeLater(command);
    }

    protected void setPredecessorApplyData(Object applyData) {
        this.applyData = applyData;
    }

    public String toString() {
        return this.transform + " at " + this.location;
    }

    public void setSelection(Object construct, boolean before, boolean after) {
        this.setSelection(this.getModelAdapter(), construct, before, after);
    }

    public void setSelection(ModelAdapter model, Object construct, boolean before, boolean after) {
        int selectionMargin;
        int selectionEndMargin;
        if (model == null) {
            throw new IllegalArgumentException("model null");
        }
        if (construct == null) {
            throw new IllegalArgumentException("construct null");
        }
        if (before == after) {
            selectionEndMargin = 0;
            selectionMargin = 0;
        } else {
            selectionMargin = before ? 0 : Integer.MAX_VALUE;
            selectionEndMargin = after ? 0 : Integer.MAX_VALUE;
        }
        this.setSelection(model, construct, selectionMargin, selectionEndMargin);
    }
}

