/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;

public class CompositeTransform
extends Transform {
    private List<Transform> components = new ArrayList<Transform>();

    public CompositeTransform() {
        super((TransformAdapter)null);
    }

    public void addComponent(Transform component) {
        this.components.add(component);
    }

    @Override
    protected void copyInternalState(ExtensionBean bean, Map<String, ExtensionBean> context) throws InvocationTargetException {
        super.copyInternalState(bean, context);
        CompositeTransform transform = (CompositeTransform)bean;
        transform.components = new ArrayList<Transform>(this.components.size());
        for (Transform component : this.components) {
            transform.components.add((Transform)component.createCopy(null));
        }
    }

    public Collection<Transform> getComponents() {
        return this.components;
    }

    @Override
    public TransformContext[] createContexts(Violation violation) {
        ArrayList<TransformContext[]> list = new ArrayList<TransformContext[]>(this.components.size());
        int length = 0;
        for (Transform transform : this.components) {
            TransformContext[] contexts = transform.createContexts(violation);
            list.add(contexts);
            length += contexts.length;
        }
        int count = 0;
        TransformContext[] array = new TransformContext[length];
        for (TransformContext[] contexts : list) {
            int n = count;
            count = contexts.length;
            System.arraycopy(contexts, 0, array, n, count);
        }
        return array;
    }
}

