/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.ModelDefinition;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;

public abstract class ModelType {
    public ModelDefinition getDefinition() {
        return AuditHook.getAuditHook().getModel(this.getClass().getName());
    }

    public abstract Collection<Class<? extends Element>> getRootElementTypes();

    public Collection<Class<? extends Element>> getContainedElementTypes() {
        return null;
    }

    public boolean isAuditable(Element element, ContentDirectory directory, Project project, Workspace workspace) {
        return directory != null && project != null && workspace != null;
    }

    public abstract ModelAdapter createModelAdapter(ModelFactory var1, Element var2, URL var3, ContainerModelAdapter var4, ContainerModelAdapter var5, ContainerModelAdapter var6);

    public ModelAdapter createModelAdapter(ModelAdapter model, Collection<Location> fragments) {
        throw new UnsupportedOperationException();
    }

    public abstract Collection<Class<?>> getPresentationTypes();

    public Collection<Class<?>> getDefaultPresentationTypes() {
        return this.getPresentationTypes();
    }

    public abstract String label(Class var1);

    public abstract String summary(Class var1);

    public abstract Icon icon(Class var1);

    public boolean isElementType(Element element) {
        return this.isRootElementType(element) || this.isContainedElementType(element);
    }

    public boolean isRootElementType(Element element) {
        Collection<Class<? extends Element>> types = this.getRootElementTypes();
        if (types != null) {
            for (Class<? extends Element> type : types) {
                if (!type.isInstance(element)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContainedElementType(Element element) {
        Collection<Class<? extends Element>> types = this.getContainedElementTypes();
        if (types != null) {
            for (Class<? extends Element> type : types) {
                if (!type.isInstance(element)) continue;
                return true;
            }
        }
        return false;
    }
}

