/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import oracle.ide.file.ContentSetScope;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileChangeListener;
import oracle.ide.file.FileChanges;
import oracle.ide.file.FileScope;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.FileDependency;

public class DependencyFileChangeListener
implements FileChangeListener {
    private static final Map<Workspace, Map<Project, DependencyFileChangeListener>> listeners = new HashMap<Workspace, Map<Project, DependencyFileChangeListener>>();
    private Project project;
    private Workspace workspace;
    private Collection<Project> dependencies;
    private final MultiMap<URL, Dependency> fileDependencies = new MultiMap();
    private final MultiMap<String, Dependency> nameDependencies = new MultiMap();
    private static final Log LOG = new Log("dependency");

    public static void addDependency(Dependency dependency, URL file, Project project, Workspace workspace) {
        DependencyFileChangeListener listener = DependencyFileChangeListener.getOrCreateListener(project, workspace);
        if (listener != null) {
            listener.bind(dependency, file);
        }
    }

    public static void addDependency(Dependency dependency, String name, Project project, Workspace workspace) {
        DependencyFileChangeListener listener = DependencyFileChangeListener.getOrCreateListener(project, workspace);
        if (listener != null) {
            listener.bind(dependency, name);
        }
    }

    public static void addDependency(Dependency dependency, Collection<String> names, Project project, Workspace workspace) {
        DependencyFileChangeListener listener = DependencyFileChangeListener.getOrCreateListener(project, workspace);
        if (listener != null) {
            listener.bind(dependency, names);
        }
    }

    public static void removeDependency(Dependency dependency, URL file, Project project, Workspace workspace) {
        boolean listenerRemoved;
        DependencyFileChangeListener listener = DependencyFileChangeListener.getListener(project, workspace);
        if (listener != null && (listenerRemoved = listener.unbind(dependency, file))) {
            DependencyFileChangeListener.removeListener(project, workspace);
        }
    }

    public static void removeDependency(Dependency dependency, String name, Project project, Workspace workspace) {
        boolean listenerRemoved;
        DependencyFileChangeListener listener = DependencyFileChangeListener.getListener(project, workspace);
        if (listener != null && (listenerRemoved = listener.unbind(dependency, name))) {
            DependencyFileChangeListener.removeListener(project, workspace);
        }
    }

    public static void removeDependency(Dependency dependency, Collection<String> names, Project project, Workspace workspace) {
        boolean listenerRemoved;
        DependencyFileChangeListener listener = DependencyFileChangeListener.getListener(project, workspace);
        if (listener != null && (listenerRemoved = listener.unbind(dependency, names))) {
            DependencyFileChangeListener.removeListener(project, workspace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DependencyFileChangeListener getOrCreateListener(Project project, Workspace workspace) {
        if (project == null) {
            return null;
        }
        Map<Workspace, Map<Project, DependencyFileChangeListener>> map = listeners;
        synchronized (map) {
            DependencyFileChangeListener listener;
            Map<Project, DependencyFileChangeListener> projects = listeners.get(workspace);
            if (projects == null) {
                projects = new HashMap<Project, DependencyFileChangeListener>();
                listeners.put(workspace, projects);
            }
            if ((listener = projects.get(project)) == null) {
                listener = new DependencyFileChangeListener(project, workspace);
                projects.put(project, listener);
            }
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DependencyFileChangeListener getListener(Project project, Workspace workspace) {
        if (project == null) {
            return null;
        }
        Map<Workspace, Map<Project, DependencyFileChangeListener>> map = listeners;
        synchronized (map) {
            Map<Project, DependencyFileChangeListener> projects = listeners.get(workspace);
            if (projects == null) {
                return null;
            }
            return projects.get(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeListener(Project project, Workspace workspace) {
        Map<Workspace, Map<Project, DependencyFileChangeListener>> map = listeners;
        synchronized (map) {
            Map<Project, DependencyFileChangeListener> projects = listeners.get(workspace);
            projects.remove(project);
            if (projects.isEmpty()) {
                listeners.remove(workspace);
            }
        }
    }

    public DependencyFileChangeListener(Project project, Workspace workspace) {
        this.project = project;
        this.workspace = workspace;
        LOG.trace("created {0}", (Object)this);
    }

    private synchronized void bind(Dependency dependency, URL file) {
        LOG.trace("adding {0} to {1}", (Object)dependency, (Object)this);
        this.addListener();
        this.fileDependencies.add((Object)file, (Object)dependency);
    }

    private synchronized void bind(Dependency dependency, String name) {
        LOG.trace("adding {0} to {1}", (Object)dependency, (Object)this);
        this.addListener();
        this.nameDependencies.add((Object)name, (Object)dependency);
    }

    private synchronized void bind(Dependency dependency, Collection<String> names) {
        LOG.trace("adding {0} to {1}", (Object)dependency, (Object)this);
        this.addListener();
        for (String name : names) {
            this.nameDependencies.add((Object)name, (Object)dependency);
        }
    }

    private synchronized boolean unbind(Dependency dependency, URL file) {
        LOG.trace("removing {0} from {1}", (Object)dependency, (Object)this);
        this.fileDependencies.removeValue((Object)file, (Object)dependency);
        return this.removeListener();
    }

    private synchronized boolean unbind(Dependency dependency, String name) {
        LOG.trace("removing {0} from {1}", (Object)dependency, (Object)this);
        this.nameDependencies.removeValue((Object)name, (Object)dependency);
        return this.removeListener();
    }

    private synchronized boolean unbind(Dependency dependency, Collection<String> names) {
        LOG.trace("removing {0} from {1}", (Object)dependency, (Object)this);
        for (String name : names) {
            this.nameDependencies.removeValue((Object)name, (Object)dependency);
        }
        return this.removeListener();
    }

    private boolean addListener() {
        if (this.fileDependencies.isEmpty() && this.nameDependencies.isEmpty()) {
            LOG.trace("******** adding file change listener {0}", (Object)this);
            ContentSetScope.getInstance((Workspace)this.workspace, (Project)this.project).addFileChangeListener((FileChangeListener)this);
            this.dependencies = this.getDependencies();
            for (Project dependency : this.dependencies) {
                ContentSetScope.getInstance((Workspace)this.workspace, (Project)dependency).addFileChangeListener((FileChangeListener)this);
            }
            return true;
        }
        return false;
    }

    private Collection<Project> getDependencies() {
        LinkedHashSet<Project> dependencies = new LinkedHashSet<Project>();
        dependencies.add(this.project);
        ArrayList<Project> pending = new ArrayList<Project>();
        pending.add(this.project);
        while (!pending.isEmpty()) {
            Project project = (Project)pending.remove(0);
            Iterator i = DependencyConfiguration.getInstance((Project)project).getDependencies();
            while (i.hasNext()) {
                Dependable dependable = (Dependable)i.next();
                Element dependency = dependable.getSource();
                if (!(dependency instanceof Project) || !dependencies.add((Project)dependency)) continue;
                pending.add((Project)dependency);
            }
        }
        dependencies.remove(this.project);
        return dependencies;
    }

    private boolean removeListener() {
        if (this.fileDependencies.isEmpty() && this.nameDependencies.isEmpty()) {
            LOG.trace("******** removing file change listener {0}", (Object)this);
            ContentSetScope.getInstance((Workspace)this.workspace, (Project)this.project).removeFileChangeListener((FileChangeListener)this);
            for (Project dependency : this.dependencies) {
                ContentSetScope.getInstance((Workspace)this.workspace, (Project)dependency).removeFileChangeListener((FileChangeListener)this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filesChanged(FileScope scope, FileChanges changes) {
        if (changes.size() == 1 && ((FileChange)changes.iterator().next()).getChangeType() == FileChange.Type.BUFFER_MODIFIED) {
            return;
        }
        LOG.trace("files {0} changed in {1}", (Object)changes, (Object)this);
        ArrayList<Dependency> addOrRemoveDependencies = new ArrayList<Dependency>();
        ArrayList<Dependency> modifiedDependencies = new ArrayList<Dependency>();
        Iterator iterator = this;
        synchronized (iterator) {
            block7: for (FileChange change : changes) {
                switch (change.getChangeType()) {
                    case BUFFER_MODIFIED: {
                        continue block7;
                    }
                    case MODIFIED: {
                        this.collectDependencies(change.getURL(), modifiedDependencies);
                        continue block7;
                    }
                }
                this.collectDependencies(change.getURL(), addOrRemoveDependencies);
            }
        }
        for (Dependency dependency : addOrRemoveDependencies) {
            dependency.fireDependencyChanged(true);
        }
        for (Dependency dependency : modifiedDependencies) {
            if (dependency instanceof FileDependency && !((FileDependency)dependency).isModifySensitive()) continue;
            dependency.fireDependencyChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filesChanged(Collection<URL> files, Project project, Workspace workspace) {
        DependencyFileChangeListener listener = DependencyFileChangeListener.getListener(project, workspace);
        if (listener == null) {
            return;
        }
        LOG.trace("files {0} changed in {1}", files, (Object)listener);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        DependencyFileChangeListener dependencyFileChangeListener = listener;
        synchronized (dependencyFileChangeListener) {
            for (URL file : files) {
                listener.collectDependencies(file, dependencies);
            }
        }
        for (Dependency dependency : dependencies) {
            dependency.fireDependencyChanged(false);
        }
    }

    private void collectDependencies(URL file, List<Dependency> dependencies) {
        Collection nameDependencies;
        Collection fileDependencies = this.fileDependencies.get((Object)file);
        if (fileDependencies != null) {
            dependencies.addAll(fileDependencies);
        }
        if ((nameDependencies = this.nameDependencies.get((Object)URLFileSystem.getName((URL)file))) != null) {
            dependencies.addAll(nameDependencies);
        }
    }

    public String toString() {
        return "DependencyFileChangeListener[" + this.project.getShortLabel() + ", " + this.fileDependencies + " " + this.nameDependencies + "]";
    }
}

