/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.CategoryDefinition;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.extension.HasCategory;
import oracle.jdeveloper.audit.extension.HasTransformBindings;
import oracle.jdeveloper.audit.extension.ParameterDefinition;
import oracle.jdeveloper.audit.extension.TransformBinding;
import oracle.jdeveloper.audit.extension.Value;

public class RuleDefinition
extends BeanDefinition
implements HasCategory,
HasTransformBindings {
    public static final String MESSAGE_KEY = "message";
    public static final String HTML_MESSAGE_KEY = "html-message";
    private CategoryDefinition category;
    private boolean mandatoryError;
    private Collection<ParameterDefinition> parameters;
    private Collection<String> variations;
    private Collection<TransformBinding> transformBindings;
    private Collection<String> suppressionIds;

    public RuleDefinition(String id, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
        this.category = category;
    }

    @Override
    public void setCategory(CategoryDefinition category) {
        this.category = category;
    }

    @Override
    public CategoryDefinition getCategory() {
        return this.category;
    }

    @Override
    public boolean hasEnabledProperty() {
        return true;
    }

    public Severity getSeverity() {
        if (this.mandatoryError) {
            return Severity.ERROR;
        }
        Value value = this.getValue("severity");
        if (value == null) {
            return Severity.ADVISORY;
        }
        Severity severity = Severity.valueOf(value.getText());
        if (severity == null) {
            severity = Severity.ADVISORY;
        }
        return severity;
    }

    public boolean isAssist() {
        return this.getSeverity() == Severity.ASSIST;
    }

    public void setSeverity(Severity severity) {
        Value value = this.getValue("severity");
        if (value != null) {
            value.setText(severity.toString());
        } else {
            ArraySortedSet values = this.getValues();
            if (values == null) {
                values = new ArraySortedSet();
                this.setValues((Collection<Value>)values);
            }
            values.add(new Value("severity", severity.toString(), new DefinitionContext(this.getExtensionId(), this)));
        }
    }

    public Collection<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    public Collection<String> getVariations() {
        return this.variations;
    }

    public void setVariations(Collection<String> variations) {
        this.variations = variations;
    }

    @Override
    public Collection<TransformBinding> getTransformBindings() {
        if (this.transformBindings != null) {
            return this.transformBindings;
        }
        return Collections.emptyList();
    }

    @Override
    public void addTransformBinding(TransformBinding binding) {
        if (this.transformBindings == null) {
            this.transformBindings = new ArrayList<TransformBinding>();
        }
        this.transformBindings.add(binding);
    }

    public boolean isMandatoryError() {
        return this.mandatoryError;
    }

    public void setMandatoryError(boolean mandatoryError) {
        if (this.mandatoryError && !mandatoryError) {
            throw new IllegalStateException("mandatoryError cannot be cleared once set");
        }
        this.mandatoryError = mandatoryError;
    }

    public Collection<String> getSuppressionIds() {
        return this.suppressionIds;
    }

    public void setSuppressionIds(Collection<String> suppressionIds) {
        this.suppressionIds = suppressionIds;
    }

    public String message(String variation) {
        String string = this.string(this.variationKey(MESSAGE_KEY, variation));
        if (string == null) {
            string = this.string(MESSAGE_KEY);
        }
        return string;
    }

    public String htmlMessage(String variation) {
        String message = this.string(this.variationKey(HTML_MESSAGE_KEY, variation));
        if (message == null) {
            message = this.string(this.variationKey(MESSAGE_KEY, variation));
        }
        if (message == null) {
            message = this.string(HTML_MESSAGE_KEY);
        }
        if (message == null) {
            message = this.string(MESSAGE_KEY);
        }
        if (message == null) {
            this.missingString(MESSAGE_KEY);
        }
        return message;
    }

    public String[] messages() {
        ArrayList<String> list = new ArrayList<String>();
        String message = this.string(MESSAGE_KEY);
        if (message != null) {
            list.add(message);
        }
        for (String variation : this.variations) {
            message = this.string(this.variationKey(MESSAGE_KEY, variation));
            if (message == null) continue;
            list.add(message);
        }
        message = this.string(HTML_MESSAGE_KEY);
        if (message != null) {
            list.add(message);
        }
        for (String variation : this.variations) {
            message = this.string(this.variationKey(HTML_MESSAGE_KEY, variation));
            if (message == null) continue;
            list.add(message);
        }
        if (list.isEmpty()) {
            this.missingString(MESSAGE_KEY);
        }
        return list.toArray(new String[list.size()]);
    }

    private String variationKey(String key, String variation) {
        return variation != null ? variation + "." + key : key;
    }
}

