/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.ExtensionRegistry;

public class ExtensionBundle_ja {
    private ClassLoader classLoader;
    private String bundleName;
    private String extensionId;
    private ResourceBundle bundle;

    public ExtensionBundle_ja(ClassLoader classLoader, String bundleName, String extensionId) {
        this.classLoader = classLoader;
        this.bundleName = bundleName;
        this.extensionId = extensionId;
    }

    public ExtensionBundle_ja(ResourceBundle bundle, String extensionId) {
        this.bundle = bundle;
        this.extensionId = extensionId;
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle(this.bundleName, Locale.getDefault(), this.classLoader);
            }
            catch (MissingResourceException e) {
                Logger logger = ExtensionRegistry.getExtensionRegistry().getLogger();
                logger.log(Level.SEVERE, "Bundle {0} from extension {1} not found", new Object[]{this.bundleName, this.extensionId});
                this.bundle = new NullResourceBundle();
            }
        }
        return this.bundle;
    }

    public String toString() {
        return "ExtensionBundle {" + this.bundleName + ", extension " + this.extensionId + (this.bundle != null ? ", loaded}" : "}");
    }

    private static class NullResourceBundle
    extends ResourceBundle
    implements Enumeration<String> {
        private NullResourceBundle() {
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return this;
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            throw new NoSuchElementException();
        }
    }
}

