/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.ide.extension.ElementVisitor;
import oracle.ide.net.FileLocator;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.extension.Definition;
import oracle.jdeveloper.audit.extension.DefinitionContext;

public class ExtensionBundle
extends Definition {
    private ClassLoader loader;
    private String bundleName;
    private boolean log;
    private boolean legacy;
    private ResourceBundle bundle;
    private MissingResourceException error;
    private String diagnostic;
    private static ResourceBundle NULL_BUNDLE = new NullResourceBundle();

    public ExtensionBundle(DefinitionContext context, ClassLoader loader, String bundleName, ResourceBundle bundle) {
        super(context);
        if (loader == null) {
            throw new NullArgumentException("loader null");
        }
        if (bundleName == null) {
            throw new NullArgumentException("bundleName null");
        }
        if (bundle == null) {
            throw new NullArgumentException("bundle null");
        }
        this.loader = loader;
        this.bundleName = bundleName;
        this.bundle = bundle;
        this.log = true;
        this.legacy = false;
    }

    public ExtensionBundle(DefinitionContext context, ClassLoader loader, String bundleName, boolean log) {
        super(context);
        if (loader == null) {
            throw new NullArgumentException("loader null");
        }
        if (bundleName == null) {
            throw new NullArgumentException("bundleName null");
        }
        this.loader = loader;
        this.bundleName = bundleName;
        this.bundle = null;
        this.log = log;
        this.legacy = false;
    }

    public ExtensionBundle(DefinitionContext context) {
        super(context);
        this.loader = null;
        this.bundleName = null;
        this.bundle = NULL_BUNDLE;
        this.log = true;
        this.legacy = true;
    }

    public ExtensionBundle(DefinitionContext context, boolean log) {
        super(context);
        this.loader = null;
        this.bundleName = null;
        this.bundle = NULL_BUNDLE;
        this.log = log;
        this.legacy = false;
    }

    public boolean isKeyed() {
        return this.bundleName != null && !this.legacy;
    }

    public boolean isLog() {
        return this.log;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            try {
                this.bundle = ElementVisitor.getResourceBundleProvider().getResourceBundle(this.bundleName, Locale.getDefault(), this.loader);
            }
            catch (MissingResourceException e) {
                this.error = e;
                this.bundle = NULL_BUNDLE;
                this.log(Level.SEVERE, e, "Bundle {0} not found: {1}", this.bundleName, e);
            }
        }
        return this.bundle;
    }

    public String getString(String key) {
        return this.bundleName != null ? this.getBundle().getString(key) : key;
    }

    public String getDiagnostic() {
        if (this.bundle == null) {
            return "\"" + this.bundleName + "\" (not loaded)";
        }
        if (this.diagnostic != null) {
            return this.diagnostic;
        }
        if (this.bundle == NULL_BUNDLE) {
            this.diagnostic = this.error != null ? "\"" + this.bundleName + "\" (" + this.error.toString() + ")" : "null bundle";
        } else {
            String baseName = "/" + this.bundleName.replace('.', '/');
            URL url = this.loader.getResource(baseName + ".class");
            if (url == null) {
                url = this.loader.getResource(baseName + ".properties");
            }
            if (url != null) {
                try {
                    url = FileLocator.resolve((URL)url);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (url != null && "jar".equals(url.getProtocol())) {
                    url = URLFileSystem.getParent((URL)url);
                }
                this.diagnostic = "\"" + this.bundleName + "\" (path " + URLFileSystem.getPlatformPathName((URL)url) + ")";
            } else {
                this.diagnostic = "\"" + this.bundleName + "\" (path unknown)";
            }
        }
        return this.diagnostic;
    }

    @Override
    public String toString() {
        return "ExtensionBundle " + this.getDiagnostic() + (this.isKeyed() ? ", keyed" : ", unkeyed") + (this.isLog() ? ", logged" : ", unlogged") + (this.isLegacy() ? ", legacy" : "");
    }

    private static class NullResourceBundle
    extends ResourceBundle
    implements Enumeration<String> {
        private NullResourceBundle() {
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return this;
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            throw new NoSuchElementException();
        }
    }
}

