/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import oracle.jdeveloper.audit.extension.Definition;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.TypeDefinition;
import oracle.jdeveloper.audit.service.Converter;

public class ConverterDefinition
extends Definition {
    private TypeDefinition<Object> valueType;
    private TypeDefinition<Converter> converterType;

    public ConverterDefinition(DefinitionContext context) {
        super(context);
    }

    public void setValueType(TypeDefinition<Object> valueType) {
        this.valueType = valueType;
    }

    public void setConverterType(TypeDefinition<Converter> converterType) {
        this.converterType = converterType;
    }

    public Class<?> getValueType() {
        if (!this.isExtensionLoaded()) {
            throw new IllegalStateException("not loaded: " + this);
        }
        return this.valueType.getType(this.isExtensionLoaded());
    }

    public Class<?> getPrimitiveValueType() {
        Class<?> type = this.getValueType();
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        return null;
    }

    public Class<? extends Converter> getConverterType() {
        if (!this.isExtensionLoaded()) {
            throw new IllegalStateException("not loaded: " + this);
        }
        return this.converterType.getType();
    }

    public Converter getConverter() {
        if (!this.isExtensionLoaded()) {
            throw new IllegalStateException("not loaded: " + this);
        }
        return this.converterType.getInstance();
    }
}

