/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import oracle.ide.Context;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceChangeEvent;
import oracle.ide.model.WorkspaceChangeListener;
import oracle.javatools.data.StructureChangeEvent;
import oracle.jdevimpl.library.LibraryContainerEventSource;
import oracle.jdevimpl.library.WorkspaceLibraryContainer;

public final class WorkspaceLibraryEventSource
extends LibraryContainerEventSource {
    private static int counter;
    private static final WorkspaceChangeListener definitionListener;
    private static final WorkspaceChangeListener referenceListener;
    private final Workspace workspace;

    public static synchronized LibraryContainerEventSource getInstance(Workspace workspace) {
        return WorkspaceLibraryEventSource.getInstance(workspace, true);
    }

    public static synchronized LibraryContainerEventSource getInstance(Workspace workspace, boolean create) {
        WorkspaceLibraryContainer container = WorkspaceLibraryContainer.getInstance(workspace);
        LibraryContainerEventSource instance = WorkspaceLibraryEventSource.getCachedInstance(container);
        if (create && instance == null) {
            instance = new WorkspaceLibraryEventSource(container);
            WorkspaceLibraryEventSource.putCachedInstance(container, instance);
        }
        return instance;
    }

    private WorkspaceLibraryEventSource(WorkspaceLibraryContainer container) {
        super(container);
        this.workspace = container.getWorkspace();
    }

    @Override
    public void attach() {
        super.attach();
        WorkspaceLibraryEventSource.attachWorkspaceListener();
    }

    @Override
    public void detach() {
        WorkspaceLibraryEventSource.detachWorkspaceListener();
        super.detach();
    }

    @Override
    public Context getContext() {
        Context context = Context.newIdeContext();
        context.setWorkspace(this.workspace);
        return context;
    }

    private static synchronized void attachWorkspaceListener() {
        if (counter++ == 0) {
            Workspace.addWorkspaceChangeListener((String)"oracle.jdeveloper.model.ApplicationLibraries/libraryReferences", (WorkspaceChangeListener)referenceListener);
            Workspace.addWorkspaceChangeListener((String)"oracle.jdeveloper.model.ApplicationLibraries/internalDefinitions", (WorkspaceChangeListener)definitionListener);
        }
    }

    private static synchronized void detachWorkspaceListener() {
        if (--counter == 0) {
            Workspace.removeWorkspaceChangeListener((String)"oracle.jdeveloper.model.ApplicationLibraries/libraryReferences", (WorkspaceChangeListener)referenceListener);
            Workspace.removeWorkspaceChangeListener((String)"oracle.jdeveloper.model.ApplicationLibraries/internalDefinitions", (WorkspaceChangeListener)definitionListener);
        }
    }

    static {
        definitionListener = new WorkspaceListenerAdapter(new LibraryContainerEventSource.DefinitionListener());
        referenceListener = new WorkspaceListenerAdapter(new LibraryContainerEventSource.ReferenceListener());
    }

    private static class WorkspaceListenerAdapter
    implements WorkspaceChangeListener {
        private final LibraryContainerEventSource.LibraryContainerListener adapted;

        WorkspaceListenerAdapter(LibraryContainerEventSource.LibraryContainerListener adapted) {
            this.adapted = adapted;
        }

        public void workspacePropertiesChanged(WorkspaceChangeEvent event) {
            LibraryContainerEventSource source;
            Workspace workspace;
            if (event.hasNonPlaceholderChange() && (workspace = event.getWorkspace()) != null && (source = WorkspaceLibraryEventSource.getInstance(workspace, false)) != null) {
                this.adapted.containerPropertiesChanged(source, (StructureChangeEvent)event);
            }
        }
    }
}

