/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.ide.Addin;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.library.LibraryExtensionLoader;

public final class IdeLibraryAddin
implements Addin {
    public void initialize() {
        LibraryExtensionLoader.initialize();
        String args = System.getProperty("oracle.ide.args");
        if (args != null && args.indexOf("-dumpclasspathsonprojectopen") >= 0) {
            Project.addProjectChangeListener((String)"", (ProjectChangeListener)new ProjectChangeListener(){
                private Set<String> previousProjects = new HashSet<String>();

                public void projectOpened(Project project) {
                    String name = project.getLongLabel();
                    if (!this.previousProjects.contains(name)) {
                        this.previousProjects.add(name);
                        this.dumpProjectPaths(project);
                    }
                }

                private void dumpProjectPaths(Project project) {
                    StringBuilder buf = new StringBuilder();
                    HashSet<URL> processedJars = new HashSet<URL>();
                    System.out.println();
                    System.out.println("************* Class Paths for Project " + project.getShortLabel());
                    System.out.println();
                    URLPath classPath = PathsConfiguration.getInstance(project).getClassPath();
                    this.dumpProjectPath(classPath, buf, processedJars, "************* Class Path Entries:");
                    System.out.println();
                    System.out.println("************* End Class Path Entries");
                    System.out.println();
                    classPath = PathsConfiguration.getInstance(project).getRunClassPath();
                    this.dumpProjectPath(classPath, buf, processedJars, "************* Run Class Path Entries:");
                    System.out.println();
                    System.out.println("************* End Run Class Path Entries");
                    System.out.println();
                    System.out.println("************* End Class Paths for Project " + project.getShortLabel());
                    System.out.println();
                }

                private void dumpProjectPath(URLPath paths, StringBuilder buf, Set<URL> processedJars, String title) {
                    URL[] entries = paths.getEntries();
                    processedJars.clear();
                    System.out.println(title);
                    System.out.println();
                    for (URL entry : entries) {
                        System.out.println(entry.getPath());
                        buf.setLength(0);
                        this.expandToIncludeManifestClassPathImpl(entry, processedJars, buf);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void expandToIncludeManifestClassPathImpl(URL curEntry, Set<URL> processedJars, StringBuilder indent) {
                    if ("".equals(JarUtil.getJarEntry((URL)curEntry)) && !processedJars.contains(curEntry)) {
                        processedJars.add(curEntry);
                        int len = indent.length();
                        try {
                            String manifestClassPath = JarUtil.getClassPath((URL)curEntry);
                            if (manifestClassPath != null) {
                                indent.append("  ");
                                URL jarFileURL = JarUtil.getJarFileURL((URL)curEntry);
                                URL dirURL = URLFileSystem.getParent((URL)jarFileURL);
                                StringTokenizer st = new StringTokenizer(manifestClassPath);
                                boolean printHeader = true;
                                while (st.hasMoreTokens()) {
                                    URL manifestCpItemURL;
                                    String manifestCpItem = st.nextToken();
                                    boolean isJar = false;
                                    URL newJarFileURL = null;
                                    if (JarUtil.isArchive((String)manifestCpItem)) {
                                        isJar = true;
                                        newJarFileURL = URLFactory.newURL((URL)dirURL, (String)manifestCpItem);
                                        manifestCpItemURL = URLFactory.newJarURL((URL)newJarFileURL, null);
                                    } else {
                                        manifestCpItemURL = URLFactory.newURL((URL)dirURL, (String)manifestCpItem);
                                    }
                                    if (printHeader) {
                                        printHeader = false;
                                        System.out.print(indent.toString());
                                        System.out.println("*** Entries included from manifest: ***");
                                    }
                                    System.out.print(indent.toString());
                                    System.out.println(manifestCpItemURL.getPath());
                                    if (!isJar) continue;
                                    this.expandToIncludeManifestClassPathImpl(manifestCpItemURL, processedJars, indent);
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            indent.setLength(len);
                        }
                    }
                }
            });
        }
    }
}

