/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.model.ApplicationContent;

public final class ApplicationContentLibraryProvider
extends DynamicLibraryProvider {
    @Override
    public void updateClassPath(Project project, URLPath classPath) {
        if (Ide.isRunning()) {
            URL adfUrl = null;
            Workspace workspace = project.getWorkspace();
            if (workspace != null) {
                adfUrl = ApplicationContent.getInstance(workspace).getADFSourceURL();
            }
            if (adfUrl == null) {
                URL projUrl = project.getURL();
                URL jprDir = URLFileSystem.getParent((URL)projUrl);
                URL jwsDir = jprDir != null ? URLFileSystem.getParent((URL)jprDir) : null;
                adfUrl = jwsDir != null ? URLFactory.newDirURL((URL)jwsDir, (String)".adf/") : null;
                URL uRL = adfUrl = adfUrl != null && URLFileSystem.isDirectory((URL)adfUrl) ? adfUrl : null;
            }
            if (adfUrl != null) {
                this.putDotAdfInFrontOfClasspath(adfUrl, classPath);
            }
        }
    }

    private void putDotAdfInFrontOfClasspath(URL adfUrl, URLPath classPath) {
        int i;
        URL[] oldEntries = classPath.getEntries();
        for (i = 0; i < oldEntries.length && !URLFileSystem.equals((URL)oldEntries[i], (URL)adfUrl); ++i) {
        }
        if (i != 0) {
            URL[] newEntries = new URL[oldEntries.length + 1];
            newEntries[0] = adfUrl;
            System.arraycopy(oldEntries, 0, newEntries, 1, i);
            if (i + 1 < oldEntries.length) {
                System.arraycopy(oldEntries, i + 1, newEntries, i + 1, newEntries.length - i - 2);
            }
            classPath.setEntries(newEntries);
        } else if (oldEntries.length == 0) {
            classPath.add(adfUrl);
        }
    }
}

