/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.ide.extension.ProjectDataHandler;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;

public final class AddinLibraryProjectDataHandler
extends ProjectDataHandler {
    public Collection<String> listExtensions(HashStructure tagRootElement) {
        HashSet<String> extensionsToInitialize = new HashSet<String>();
        for (String libName : this.getLibrariesFromProject(tagRootElement)) {
            String extensionId;
            ExtensionLibrary extLib = this.findExtensionLibrary(libName);
            if (extLib == null || !extLib.getForceExtensionInitialization() || (extensionId = extLib.getProviderExtensionId()) == null) continue;
            extensionsToInitialize.add(extensionId);
        }
        return extensionsToInitialize.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(extensionsToInitialize);
    }

    private ExtensionLibrary findExtensionLibrary(String id) {
        JLibrary lib = JLibraryManager.getAddinLibraries().findLibrary(id);
        return lib instanceof ExtensionLibrary ? (ExtensionLibrary)lib : null;
    }

    private List<String> getLibrariesFromProject(HashStructure hashStructure) {
        List<String> result = Collections.emptyList();
        ListStructure list = hashStructure.getListStructure("libraryReferences");
        if (list != null) {
            result = new ArrayList<String>(list.size());
            for (Object obj : list) {
                HashStructure hash = (HashStructure)obj;
                String libString = hash.getString("id");
                result.add(libString);
            }
        }
        return result;
    }
}

