/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.util.concurrent.CopyOnWriteArrayList;
import oracle.jdeveloper.library.LibraryEvent;
import oracle.jdeveloper.library.LibraryEventSource;
import oracle.jdeveloper.library.LibraryListener;

public abstract class AbstractLibraryEventSource
implements LibraryEventSource {
    private int counter;
    private final CopyOnWriteArrayList<LibraryListener> listeners = new CopyOnWriteArrayList();

    @Override
    public synchronized void addLibraryListener(LibraryListener listener) {
        if (this.listeners.addIfAbsent(listener) && this.counter++ == 0) {
            this.attach();
        }
    }

    @Override
    public synchronized void removeLibraryListener(LibraryListener listener) {
        if (this.listeners.remove(listener) && --this.counter == 0) {
            this.detach();
        }
    }

    public abstract void attach();

    public abstract void detach();

    protected void fireLibraryEvent(LibraryEvent e) {
        for (LibraryListener listener : this.listeners) {
            listener.librariesChanged(e);
        }
    }
}

