/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.style;

import java.util.Iterator;
import java.util.List;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public final class CodingStyleTextBuilder {
    private final CodingStyleOptions options;
    private final StringBuilder stringBuilder = new StringBuilder();

    public CodingStyleTextBuilder() {
        CodingStyleManager manager = CodingStyleManager.getCodingStyleManager();
        this.options = manager == null ? null : manager.getCodingStyleOptions();
    }

    public CodingStyleTextBuilder(CodingStyleOptions options) {
        this.options = options;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    public void add(String text) {
        this.stringBuilder.append(text);
    }

    public void addTerminator() {
        if (this.options == null || this.options.getSpaceBeforeSemicolon()) {
            this.stringBuilder.append(" ");
        }
        this.stringBuilder.append(";");
    }

    public void addAssignment() {
        if (this.options == null || this.options.getSpaceAroundAssignment()) {
            this.stringBuilder.append(" = ");
        } else {
            this.stringBuilder.append("=");
        }
    }

    public void addCast(String typeName) {
        this.stringBuilder.append("(");
        if (this.options == null || this.options.getSpaceWithinParenthesis()) {
            this.stringBuilder.append(" ");
        }
        this.stringBuilder.append(typeName);
        if (this.options == null || this.options.getSpaceWithinParenthesis()) {
            this.stringBuilder.append(" ");
        }
        this.stringBuilder.append(")");
        if (this.options == null || this.options.getSpaceAfterTypecast()) {
            this.stringBuilder.append(" ");
        }
    }

    public void addMethodArgumentList(List<String> argumentNames) {
        if (this.options != null && this.options.getSpaceBeforeArguments()) {
            this.stringBuilder.append(" ");
        }
        this.stringBuilder.append("(");
        if (!argumentNames.isEmpty()) {
            if (this.options != null && this.options.getSpaceWithinParenthesis()) {
                this.stringBuilder.append(" ");
            }
            Iterator<String> it = argumentNames.iterator();
            while (it.hasNext()) {
                String name = it.next();
                this.stringBuilder.append(name);
                if (this.options != null && this.options.getSpaceBeforeComma()) {
                    this.stringBuilder.append(" ");
                }
                if (!it.hasNext()) continue;
                this.stringBuilder.append(",");
                if (this.options != null && !this.options.getSpaceAfterComma()) continue;
                this.stringBuilder.append(" ");
            }
            if (this.options != null && this.options.getSpaceWithinParenthesis()) {
                this.stringBuilder.append(" ");
            }
        }
        this.stringBuilder.append(")");
    }

    public void addOperator(String operator) {
        boolean addSpace;
        boolean bl = addSpace = this.options != null && this.options.getSpaceAroundBinaryOperator();
        if (addSpace) {
            this.stringBuilder.append(' ');
        }
        this.stringBuilder.append(operator);
        if (addSpace) {
            this.stringBuilder.append(' ');
        }
    }
}

