/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.Context;
import oracle.jdeveloper.library.LibraryChange;

public class LibraryEvent {
    private final Context context;
    private final Collection<LibraryChange> changes;

    public LibraryEvent(Context context, LibraryChange change) {
        this(context, Collections.singleton(change));
    }

    public LibraryEvent(Context context, Collection<LibraryChange> changes) {
        this.context = context;
        this.changes = new ArrayList<LibraryChange>(changes);
    }

    public Context getContext() {
        return this.context;
    }

    public Collection<LibraryChange> getLibraryChanges() {
        return Collections.unmodifiableCollection(this.changes);
    }

    public Collection<LibraryChange> getLibraryChanges(LibraryChange.Type type) {
        ArrayList<LibraryChange> changes = new ArrayList<LibraryChange>();
        for (LibraryChange change : this.getLibraryChanges()) {
            if (change.getType() != type) continue;
            changes.add(change);
        }
        return Collections.unmodifiableCollection(changes);
    }

    public boolean hasPropertyChange(String name) {
        for (LibraryChange change : this.getLibraryChanges()) {
            if (!change.isPropertyChange(name)) continue;
            return true;
        }
        return false;
    }
}

