/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.AbstractLibrary;
import oracle.jdeveloper.library.DerivedLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.NodeObserver;

public abstract class AbstractDerivedLibrary
extends AbstractLibrary
implements DerivedLibrary,
SubDirtyable,
Observer {
    private Dirtyable _owner;
    private URL _sourceURL;
    private URL _sourceOwnerURL;
    private WeakReference _sourceRef;
    private WeakReference _sourceOwnerRef;

    @Override
    public String getName() throws TransientMarker {
        return URLFileSystem.getFileName((URL)this.getSourceURL());
    }

    public Element getSource() {
        if (this._sourceRef != null && this._sourceRef.get() != null) {
            return (Element)this._sourceRef.get();
        }
        if (this._sourceURL == null) {
            return null;
        }
        this._sourceRef = new WeakReference<Node>(this.createNode(this._sourceURL));
        return (Element)this._sourceRef.get();
    }

    public Folder getSourceOwner() {
        if (this._sourceOwnerRef != null && this._sourceOwnerRef.get() != null) {
            return (Folder)this._sourceOwnerRef.get();
        }
        if (this._sourceOwnerURL == null) {
            return null;
        }
        this._sourceOwnerRef = new WeakReference<Node>(this.createNode(this._sourceOwnerURL));
        return (Folder)this._sourceOwnerRef.get();
    }

    @Override
    public URL getSourceURL() {
        Node node;
        if (this._sourceRef != null && this._sourceRef.get() != null && (node = (Node)this._sourceRef.get()) != null) {
            this._sourceURL = node.getURL();
        }
        return this._sourceURL;
    }

    @Override
    public void setSourceURL(URL url) {
        Assert.precondition((this._sourceURL == null ? 1 : 0) != 0, (String)"Cannot reset a derived library's source URL");
        this._sourceURL = url;
    }

    @Override
    public URL getSourceOwnerURL() {
        Node node;
        if (this._sourceOwnerRef != null && this._sourceOwnerRef.get() != null && (node = (Node)this._sourceOwnerRef.get()) != null) {
            this._sourceOwnerURL = node.getURL();
        }
        return this._sourceOwnerURL;
    }

    @Override
    public void setSourceOwnerURL(URL url) {
        Assert.precondition((this._sourceOwnerURL == null ? 1 : 0) != 0, (String)"Cannot reset a derived library's source owner URL");
        this._sourceOwnerURL = url;
    }

    public void setOwner(Dirtyable owner) {
        this._owner = owner;
    }

    @Override
    public void markDirty(boolean dirty) {
        if (this._owner != null) {
            this._owner.markDirty(dirty);
        }
    }

    @Override
    public boolean isDirty() {
        return this._owner != null ? this._owner.isDirty() : false;
    }

    @Override
    protected boolean equalsImpl(AbstractLibrary other) {
        if (!super.equalsImpl(other)) {
            return false;
        }
        AbstractDerivedLibrary o = (AbstractDerivedLibrary)other;
        return ModelUtil.areEqual((Object)this.getSourceURL(), (Object)o.getSourceURL()) && ModelUtil.areEqual((Object)this.getSourceOwnerURL(), (Object)o.getSourceOwnerURL());
    }

    protected final void copyToImpl(AbstractDerivedLibrary copy) {
        super.copyToImpl(copy);
    }

    protected void checkPropertyChange(String property, String newProperty, UpdateMessage change, List output) {
        PropertyChangeEvent pce = (PropertyChangeEvent)change.getProperty(property);
        if (pce != null) {
            output.add(new PropertyChangeEvent(this, newProperty, null, null));
        }
    }

    protected void firePropertiesChanged(List pList) {
        int size = pList.size();
        if (size > 0) {
            String propertyName;
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.PROPERTY_SET, (Object)JLibraryManager.getInstance());
            boolean hasNullPropertyName = false;
            for (PropertyChangeEvent e : pList) {
                propertyName = e.getPropertyName();
                if (propertyName != null) continue;
                hasNullPropertyName = true;
                break;
            }
            if (!hasNullPropertyName) {
                for (PropertyChangeEvent e : pList) {
                    propertyName = e.getPropertyName();
                    updateMessage.setProperty(propertyName, (Object)e);
                }
            }
            JLibraryManager.getInstance().notifyObservers(this, updateMessage);
        }
    }

    protected boolean isPropertyChange(UpdateMessage change) {
        return change.getMessageID() == UpdateMessage.PROPERTY_SET;
    }

    private Node createNode(URL url) {
        if (url != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                new NodeObserver(node, this);
                return node;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        return null;
    }
}

