/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.file.LibraryPaths;
import oracle.ide.file.Path;
import oracle.ide.file.ProjectCache;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.config.JProjectPaths;

public class JavaProjectCache
extends ProjectCache {
    private static final String ADDITIONAL_PATH_KEY = "add$";
    private static final String JDK_KEY = "jdk2$";
    private static final String LIBRARIES_KEY = "lib2$";
    private static final String EXPORT_LIBRARIES_KEY = "exp2$";
    private static final byte LIBRARY_TYPE_VERSION = 0;
    private static final byte LIBRARY_TYPE_STRING = 1;
    private static final byte LIBRARY_TYPE_URL = 2;
    private static final byte LIBRARY_TYPE_PATHS = 3;
    private final AssemblyFactory jdkFactory = new ProjectCache.CacheEntryFactory((ProjectCache)this, (AssemblyFactory)new CachedJdkFactory());
    private final AssemblyFactory libraryPathsFactory = new LibraryPathsFactory();
    private final AssemblyFactory cachedLibraryFactory = new CachedLibraryFactory();
    private final AssemblyFactory cachedLibrariesFactory = new ProjectCache.CacheEntryFactory((ProjectCache)this, (AssemblyFactory)new CachedLibrariesFactory());

    public static JavaProjectCache getInstance(Workspace workspace) {
        return new JavaProjectCache(workspace);
    }

    protected JavaProjectCache(Workspace workspace) {
        super(workspace);
    }

    public Path getJavaContentPath(Project project) {
        return this.getContentPath(project, PathsConfiguration.JAVA_CONTENT_SET_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getAdditionalClassPath(Project project) {
        if (project == null) {
            return Path.getInstance();
        }
        Path path = this.getPath(project, ADDITIONAL_PATH_KEY);
        if (path == null) {
            JProjectPaths projectPaths = JProjectPaths.getInstance((PropertyStorage)this.loadProject(project));
            URLPath additionalPath = projectPaths.getAdditionalClassPath();
            Logger grammarLogger = Logger.getLogger("oracle.bali.xml.grammar");
            Level oldLevel = grammarLogger.getLevel();
            grammarLogger.setLevel(Level.OFF);
            JLibraryManager mgr = JLibraryManager.getInstance();
            try {
                String[] technologyKeys = this.getTechnologyScopeKeys(project);
                for (DynamicLibraryProvider provider : mgr.getDynamicLibraryProviders(technologyKeys)) {
                    try {
                        provider.updateClassPath(project, additionalPath);
                    }
                    catch (Throwable t) {
                        this.getLogger().log(Level.SEVERE, "Unable to obtain classpath entries from " + provider.getClass().getName(), t);
                    }
                }
            }
            finally {
                grammarLogger.setLevel(oldLevel);
            }
            path = JavaProjectCache.getPath(additionalPath);
            this.putPath(project, ADDITIONAL_PATH_KEY, path);
        }
        return path;
    }

    public LibraryPaths getJdkPaths(Project project) {
        LibraryPaths paths;
        LibraryPaths emptyPath = LibraryPaths.getInstance((String)"", (Path)Path.getInstance(), (Path)Path.getInstance());
        if (project == null) {
            return emptyPath;
        }
        CachedJdk cached = this.getJdk(project, JDK_KEY);
        if (cached != null) {
            LibraryPaths paths2 = JavaProjectCache.resolveJdk(cached);
            return paths2 == null ? emptyPath : paths2;
        }
        JProjectLibraries libraries = JProjectLibraries.getInstance((PropertyStorage)this.loadProject(project));
        JDK jdk = libraries.getJDK();
        if (jdk != null) {
            Object id = jdk.getID();
            paths = JavaProjectCache.getLibraryPaths(jdk);
            JProjectLibraryList list = libraries.getProjectLibraryList();
            if (list != null && list.findJDK(id) != null) {
                this.putJdk(project, JDK_KEY, new CachedJdk(paths));
            } else if (id instanceof String) {
                this.putJdk(project, JDK_KEY, new CachedJdk((String)id, jdk.getJavaVersion()));
            } else if (id instanceof URL) {
                this.putJdk(project, JDK_KEY, new CachedJdk((URL)id, jdk.getJavaVersion()));
            }
        } else {
            paths = emptyPath;
        }
        return paths;
    }

    public List<LibraryPaths> getLibraryPaths(Project project) {
        return this.getLibraryPaths(project, false);
    }

    public List<LibraryPaths> getExportLibraryPaths(Project project) {
        return this.getLibraryPaths(project, true);
    }

    private List<LibraryPaths> getLibraryPaths(Project project, boolean exportsOnly) {
        if (project == null) {
            return Collections.emptyList();
        }
        String key = exportsOnly ? EXPORT_LIBRARIES_KEY : LIBRARIES_KEY;
        Collection<CachedLibrary> cached = this.getLibraries(project, key);
        if (cached != null) {
            return JavaProjectCache.resolveLibraries(cached);
        }
        boolean canCache = true;
        JProjectLibraries libraries = JProjectLibraries.getInstance((PropertyStorage)this.loadProject(project));
        JProjectLibraryList list = libraries.getProjectLibraryList();
        JLibrary[] libs = exportsOnly ? libraries.getExports() : libraries.getLibraries();
        ArrayList<LibraryPaths> path = new ArrayList<LibraryPaths>(libs.length);
        cached = new ArrayList<CachedLibrary>(libs.length);
        for (JLibrary library : libs) {
            LibraryPaths paths = JavaProjectCache.getLibraryPaths(library);
            path.add(paths);
            if (!canCache) continue;
            Object id = library.getID();
            if (list != null && list.findLibrary(id) != null) {
                cached.add(new CachedLibrary(paths));
                continue;
            }
            if (id instanceof String) {
                cached.add(new CachedLibrary((String)id));
                continue;
            }
            if (id instanceof URL) {
                cached.add(new CachedLibrary((URL)id));
                continue;
            }
            canCache = false;
        }
        if (canCache) {
            this.putLibraries(project, key, cached);
        }
        return Collections.unmodifiableList(path);
    }

    protected CachedJdk getJdk(Project project, String key) {
        byte[] record;
        CachedJdk cached = null;
        if (JavaProjectCache.isEnabled() && this.namespace != null && (record = this.namespace.getRecord(this.getProjectKey(project, key))) != null) {
            try {
                ProjectCache.CacheEntry entry = (ProjectCache.CacheEntry)this.jdkFactory.assemble(record);
                if (this.isValid(project, entry)) {
                    cached = (CachedJdk)entry.getEntry();
                }
            }
            catch (AssemblyException assemblyException) {
                // empty catch block
            }
        }
        return cached;
    }

    protected void putJdk(Project project, String key, CachedJdk jdk) {
        if (JavaProjectCache.isEnabled() && this.namespace != null) {
            try {
                ProjectCache.CacheEntry entry = new ProjectCache.CacheEntry((Object)jdk, project.getTimestamp(), JavaProjectCache.getUserTimestamp((Workspace)this.workspace), JavaProjectCache.getUserTimestamp((Project)project));
                byte[] record = this.jdkFactory.disassemble((Object)entry);
                if (record != null) {
                    this.namespace.putRecord(this.getProjectKey(project, key), record);
                }
            }
            catch (AssemblyException assemblyException) {
                // empty catch block
            }
        }
    }

    protected Collection<CachedLibrary> getLibraries(Project project, String key) {
        byte[] record;
        Collection cachedLibraries = null;
        if (JavaProjectCache.isEnabled() && this.namespace != null && (record = this.namespace.getRecord(this.getProjectKey(project, key))) != null) {
            try {
                ProjectCache.CacheEntry entry = (ProjectCache.CacheEntry)this.cachedLibrariesFactory.assemble(record);
                if (this.isValid(project, entry)) {
                    cachedLibraries = (Collection)entry.getEntry();
                }
            }
            catch (AssemblyException e) {
                LOGGER.log(Level.FINE, "Unable to get libraries from cache for " + key, e);
            }
        }
        return cachedLibraries;
    }

    protected void putLibraries(Project project, String key, Collection<CachedLibrary> libraries) {
        if (JavaProjectCache.isEnabled() && this.namespace != null) {
            try {
                ProjectCache.CacheEntry entry = new ProjectCache.CacheEntry(libraries, project.getTimestamp(), JavaProjectCache.getUserTimestamp((Workspace)this.workspace), JavaProjectCache.getUserTimestamp((Project)project));
                byte[] record = this.cachedLibrariesFactory.disassemble((Object)entry);
                if (record != null) {
                    this.namespace.putRecord(this.getProjectKey(project, key), record);
                }
            }
            catch (AssemblyException e) {
                LOGGER.log(Level.FINE, "Unable to put libraries into cache for " + key, e);
            }
        }
    }

    private static Path getPath(URLPath path) {
        return path == null ? Path.getInstance() : Path.getInstance((URLPath)path);
    }

    private static LibraryPaths getLibraryPaths(Library library) {
        Path sourcePath = JavaProjectCache.getPath(library.getSourcePath());
        Path classPath = JavaProjectCache.getPath(library.getClassPath());
        return LibraryPaths.getInstance((String)library.getName(), (Path)sourcePath, (Path)classPath);
    }

    private static List<LibraryPaths> resolveLibraries(Collection<CachedLibrary> libraries) {
        ArrayList<LibraryPaths> paths = new ArrayList<LibraryPaths>(libraries.size());
        for (CachedLibrary library : libraries) {
            LibraryPaths resolved = JavaProjectCache.resolveLibrary(library);
            if (resolved == null) continue;
            paths.add(resolved);
        }
        return paths;
    }

    private static LibraryPaths resolveLibrary(CachedLibrary library) {
        Object id;
        JLibrary resolved;
        LibraryPaths paths = library.getPaths();
        if (paths == null && (resolved = JLibraryManager.findLibrary(id = library.getId())) != null) {
            paths = JavaProjectCache.getLibraryPaths(resolved);
        }
        return paths;
    }

    private static LibraryPaths resolveJdk(CachedJdk jdk) {
        VersionNumber version;
        Object id;
        JDK resolved;
        LibraryPaths paths = jdk.getPaths();
        if (paths == null && (resolved = JLibraryManager.findJDKMatch(id = jdk.getId(), version = jdk.getVersion())) != null) {
            paths = JavaProjectCache.getLibraryPaths(resolved);
        }
        return paths;
    }

    private final class LibraryPathsFactory
    extends ObjectFactory {
        private LibraryPathsFactory() {
        }

        public byte getObjectCode() {
            return -105;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            String name = (String)StringFactory.STRING_FACTORY.assemble(input);
            Path sourcePath = (Path)JavaProjectCache.this.pathFactory.assemble(input);
            Path classPath = (Path)JavaProjectCache.this.pathFactory.assemble(input);
            return LibraryPaths.getInstance((String)name, (Path)sourcePath, (Path)classPath);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            LibraryPaths libraryPaths = (LibraryPaths)object;
            StringFactory.STRING_FACTORY.disassemble((Object)libraryPaths.getLibraryName(), output);
            JavaProjectCache.this.pathFactory.disassemble((Object)libraryPaths.getSourcePath(), output);
            JavaProjectCache.this.pathFactory.disassemble((Object)libraryPaths.getClassPath(), output);
        }
    }

    private final class CachedLibrariesFactory
    extends ObjectFactory {
        private CachedLibrariesFactory() {
        }

        public byte getObjectCode() {
            return -95;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int size = input.readInt();
            ArrayList<CachedLibrary> list = new ArrayList<CachedLibrary>(size);
            for (int i = 0; i < size; ++i) {
                list.add((CachedLibrary)JavaProjectCache.this.cachedLibraryFactory.assemble(input));
            }
            return list;
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            Collection cachedLibraries = (Collection)object;
            output.writeInt(cachedLibraries.size());
            for (CachedLibrary library : cachedLibraries) {
                JavaProjectCache.this.cachedLibraryFactory.disassemble((Object)library, output);
            }
        }
    }

    private final class CachedLibraryFactory
    extends ObjectFactory {
        private CachedLibraryFactory() {
        }

        public byte getObjectCode() {
            return -94;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            byte b = input.readByte();
            if (b == 3) {
                LibraryPaths paths = (LibraryPaths)JavaProjectCache.this.libraryPathsFactory.assemble(input);
                return new CachedLibrary(paths);
            }
            if (b == 1) {
                String id = (String)StringFactory.STRING_FACTORY.assemble(input);
                return new CachedLibrary(id);
            }
            if (b == 2) {
                String relativePath = (String)StringFactory.STRING_FACTORY.assemble(input);
                return new CachedLibrary(JavaProjectCache.this.storage.getURL(relativePath));
            }
            throw new AssemblyException("Unknown library reference type " + b, (AssemblyFactory)this);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            CachedLibrary cached = (CachedLibrary)object;
            LibraryPaths paths = cached.getPaths();
            if (paths != null) {
                output.writeByte(3);
                JavaProjectCache.this.libraryPathsFactory.disassemble((Object)paths, output);
            } else {
                Object id = cached.getId();
                if (id instanceof String) {
                    output.writeByte(1);
                    StringFactory.STRING_FACTORY.disassemble(id, output);
                } else if (id instanceof URL) {
                    output.writeByte(2);
                    String relativePath = JavaProjectCache.this.storage.getRelativePath((URL)id);
                    StringFactory.STRING_FACTORY.disassemble((Object)relativePath, output);
                } else {
                    throw new AssemblyException("Unknown library reference type " + id.getClass(), (AssemblyFactory)this);
                }
            }
        }
    }

    private final class CachedJdkFactory
    extends ObjectFactory {
        private CachedJdkFactory() {
        }

        public byte getObjectCode() {
            return -93;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            byte b = input.readByte();
            if (b == 3) {
                LibraryPaths paths = (LibraryPaths)JavaProjectCache.this.libraryPathsFactory.assemble(input);
                return new CachedJdk(paths);
            }
            if (b == 1) {
                String id = (String)StringFactory.STRING_FACTORY.assemble(input);
                String version = (String)StringFactory.STRING_FACTORY.assemble(input);
                return new CachedJdk(id, new VersionNumber(version));
            }
            if (b == 2) {
                String relativePath = (String)StringFactory.STRING_FACTORY.assemble(input);
                URL id = JavaProjectCache.this.storage.getURL(relativePath);
                String version = (String)StringFactory.STRING_FACTORY.assemble(input);
                return new CachedJdk(id, new VersionNumber(version));
            }
            if (b == 0) {
                String version = (String)StringFactory.STRING_FACTORY.assemble(input);
                return new CachedJdk(new VersionNumber(version));
            }
            throw new AssemblyException("Unknown library reference type " + b, (AssemblyFactory)this);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            CachedJdk cached = (CachedJdk)object;
            LibraryPaths paths = cached.getPaths();
            if (paths != null) {
                output.writeByte(3);
                JavaProjectCache.this.libraryPathsFactory.disassemble((Object)paths, output);
            } else {
                Object id = cached.getId();
                if (id instanceof String) {
                    output.writeByte(1);
                    StringFactory.STRING_FACTORY.disassemble(id, output);
                    StringFactory.STRING_FACTORY.disassemble((Object)cached.getVersion().toString(), output);
                } else if (id instanceof URL) {
                    output.writeByte(2);
                    String relativePath = JavaProjectCache.this.storage.getRelativePath((URL)id);
                    StringFactory.STRING_FACTORY.disassemble((Object)relativePath, output);
                    StringFactory.STRING_FACTORY.disassemble((Object)cached.getVersion().toString(), output);
                } else if (id == null) {
                    output.writeByte(0);
                    StringFactory.STRING_FACTORY.disassemble((Object)cached.getVersion().toString(), output);
                } else {
                    throw new AssemblyException("Unknown library reference type " + id.getClass(), (AssemblyFactory)this);
                }
            }
        }
    }

    private static class CachedLibrary {
        private final Object id;
        private final LibraryPaths paths;

        public CachedLibrary(URL id) {
            this.id = id;
            this.paths = null;
        }

        public CachedLibrary(String id) {
            this.id = id;
            this.paths = null;
        }

        public CachedLibrary(LibraryPaths paths) {
            this.id = null;
            this.paths = paths;
        }

        public Object getId() {
            return this.id;
        }

        public LibraryPaths getPaths() {
            return this.paths;
        }
    }

    private static final class CachedJdk
    extends CachedLibrary {
        private final VersionNumber version;

        public CachedJdk(VersionNumber version) {
            this((String)null, version);
        }

        public CachedJdk(URL id, VersionNumber version) {
            super(id);
            this.version = version;
        }

        public CachedJdk(String id, VersionNumber version) {
            super(id);
            this.version = version;
        }

        public CachedJdk(LibraryPaths paths) {
            super(paths);
            this.version = null;
        }

        public VersionNumber getVersion() {
            return this.version;
        }
    }
}

