/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.StarterFactory;
import oracle.ide.runner.StarterFactoryDescription;
import oracle.ide.util.Assert;
import oracle.ideimpl.runner.RunnerUtils;
import oracle.ideimpl.runner.StarterFactoryHook;
import oracle.javatools.data.HashStructure;

public class StarterFactoryDescriptionImpl
implements StarterFactoryDescription {
    private static final String DEFAULT_STARTER_FACTORY_BASE_CLASS = "oracle.ide.runner.StarterFactory";
    private static final String CLASS_NAME = "class";
    private static final String BASE_CLASS_NAME = "base-class";
    private static final String TARGET_CLASS = "target-class";
    private static final String PROJECT_HAS_FILE = "project-has-file";
    private static final String PROJECT_HAS_PROPERTY = "project-has-property";
    private static final String HASH_STRUCTURE = "hash-structure";
    private static final String CONTENT_SET = "content-set";
    private static final String FILE_RELATIVE_PATH = "relative-path";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_VALUE = "value";
    private static final String TEXT = "#text";
    private StarterFactory starterFactory;
    private String extensionId;
    private String starterFactoryClassName;
    private String starterFactoryBaseClassName;
    private Class starterFactoryClass;
    private Class targetClass;
    private String targetClassName;
    private HashStructure hash;
    private String key;
    private Set<String> _errors;
    private String rule;

    public StarterFactoryDescriptionImpl(HashStructure hash, String extensionId) {
        this.extensionId = extensionId;
        this.hash = hash;
    }

    public StarterFactoryDescriptionImpl(Class targetClass, StarterFactory starterFactory, String key) {
        this.targetClass = targetClass;
        this.targetClassName = targetClass.getName();
        this.starterFactoryClass = starterFactory.getClass();
        this.starterFactoryClassName = this.starterFactoryClass.getName();
        this.starterFactory = starterFactory;
        this.key = key;
        this.rule = "always-enabled";
    }

    @Override
    public boolean isAcceptableProject(Project project) {
        return this.hasRequiredProperties(project) && this.hasRequiredFiles(project);
    }

    @Override
    public boolean isAcceptableNode(Project project, Node node) {
        return true;
    }

    protected boolean hasRequiredFiles(Project project) {
        if (project == null) {
            return true;
        }
        if (this.hash == null || !this.hash.containsKey(PROJECT_HAS_FILE)) {
            return true;
        }
        List fileDefs = this.hash.getAsList(PROJECT_HAS_FILE);
        HashStructure projectProperties = project.getProperties();
        for (Object fileDefObject : fileDefs) {
            if (!(fileDefObject instanceof HashStructure)) {
                this.logError("Incorrect project-has-file definition in starter-factory");
                return false;
            }
            HashStructure fileDef = (HashStructure)fileDefObject;
            if (!fileDef.containsKey(CONTENT_SET) || !fileDef.containsKey(FILE_RELATIVE_PATH)) {
                return false;
            }
            HashStructure fileHash = this.resolveHashStructureDefinitions(projectProperties, fileDef);
            if (fileHash == null) {
                return false;
            }
            ContentSet contentSet = null;
            List contentSetDefs = fileDef.getAsList(CONTENT_SET);
            for (Object objectDef : contentSetDefs) {
                if (!(objectDef instanceof HashStructure)) {
                    this.logError("Incorrect content-set definition in starter-factory definition");
                    return false;
                }
                HashStructure contentSetDef = (HashStructure)objectDef;
                String name = null;
                if (contentSetDef.containsKey(TEXT)) {
                    name = contentSetDef.getObject(TEXT).toString();
                }
                if (name == null) {
                    this.logError("Missing content-set value in starter-factory definition");
                    return false;
                }
                if (contentSet == null) {
                    if (!fileHash.containsKey(name)) {
                        return false;
                    }
                    Object object = fileHash.getObject(name);
                    if (!(object instanceof HashStructure)) {
                        return false;
                    }
                    contentSet = new ContentSet((HashStructure)object);
                } else {
                    int count = contentSet.countContentSets();
                    ContentSet constituentContentSet = null;
                    for (int i = 0; i < count && !name.equals((constituentContentSet = contentSet.getContentSet(i)).getContentSetName()); ++i) {
                        constituentContentSet = null;
                    }
                    contentSet = constituentContentSet;
                }
                if (contentSet != null) continue;
                return false;
            }
            List requiredFileDefs = fileDef.getAsList(FILE_RELATIVE_PATH);
            for (Object requiredFileDefObject : requiredFileDefs) {
                if (!(requiredFileDefObject instanceof HashStructure)) {
                    this.logError("Incorrect relative-path definition in starter-factory");
                    return false;
                }
                HashStructure requiredFileDef = (HashStructure)requiredFileDefObject;
                String relativePath = null;
                if (requiredFileDef.containsKey(TEXT)) {
                    relativePath = requiredFileDef.getObject(TEXT).toString();
                }
                if (relativePath == null) {
                    this.logError("Missing relative path in starter-factory");
                    return false;
                }
                URL url = contentSet.toQualifiedURL(relativePath);
                if (url != null && URLFileSystem.isBound((URL)url)) continue;
                return false;
            }
        }
        return true;
    }

    private HashStructure resolveHashStructureDefinitions(HashStructure projectProperties, HashStructure containsNames) {
        HashStructure fileHash = projectProperties;
        if (containsNames.containsKey(HASH_STRUCTURE)) {
            List hashStructureDefs = containsNames.getAsList(HASH_STRUCTURE);
            for (Object objectDef : hashStructureDefs) {
                if (!(objectDef instanceof HashStructure)) {
                    this.logError("Incorrect hash-structure definition in starter-factory definition");
                    return null;
                }
                HashStructure hashStructureDef = (HashStructure)objectDef;
                String name = null;
                if (hashStructureDef.containsKey(TEXT)) {
                    name = hashStructureDef.getObject(TEXT).toString();
                }
                if (name == null) {
                    this.logError("Missing hash-structure value in starter-factory definition");
                    return null;
                }
                Object fileHashObject = null;
                if (fileHash.containsKey(name)) {
                    fileHashObject = fileHash.getObject(name);
                }
                if (fileHashObject instanceof HashStructure) {
                    fileHash = (HashStructure)fileHashObject;
                    continue;
                }
                this.logError("Incorrect hash-structure value in starter-factory definition");
                return null;
            }
        }
        return fileHash;
    }

    protected boolean hasRequiredProperties(Project project) {
        if (project == null) {
            return true;
        }
        if (this.hash == null || !this.hash.containsKey(PROJECT_HAS_PROPERTY)) {
            return true;
        }
        List propertyDefs = this.hash.getAsList(PROJECT_HAS_PROPERTY);
        HashStructure projectProperties = project.getProperties();
        for (Object propertyDefObject : propertyDefs) {
            if (!(propertyDefObject instanceof HashStructure)) {
                this.logError("Incorrect project-has-property definition in starter-factory");
                return false;
            }
            HashStructure propertyDef = (HashStructure)propertyDefObject;
            HashStructure propertyHash = this.resolveHashStructureDefinitions(projectProperties, propertyDef);
            if (propertyHash == null) {
                return false;
            }
            String propertyName = this.getPropertyString(propertyDef, PROPERTY_NAME);
            String requiredValue = this.getPropertyString(propertyDef, PROPERTY_VALUE);
            if (propertyName == null || requiredValue == null) {
                return false;
            }
            String actualValue = null;
            if (!propertyHash.containsKey(propertyName)) {
                return false;
            }
            actualValue = propertyHash.getObject(propertyName).toString();
            if (requiredValue.equals(actualValue)) continue;
            return false;
        }
        return true;
    }

    private String getPropertyString(HashStructure propertyDef, String name) {
        HashStructure propertyHash;
        Object propertyObject;
        String propertyString = null;
        if (propertyDef.containsKey(name) && (propertyObject = propertyDef.getObject(name)) instanceof HashStructure && (propertyHash = (HashStructure)propertyObject).containsKey(TEXT)) {
            propertyString = propertyHash.getObject(TEXT).toString();
        }
        if (propertyString == null) {
            this.logError("Missing property " + name + " in starter-factory definition");
        }
        return propertyString;
    }

    @Override
    public boolean isAcceptableStarterFactory(Class starterFactoryClass) {
        if (starterFactoryClass == null) {
            return true;
        }
        String baseClass = this.getStarterFactoryBaseClassName();
        if (baseClass == null || baseClass.trim().length() == 0) {
            baseClass = DEFAULT_STARTER_FACTORY_BASE_CLASS;
        }
        return this.isInstanceOf(starterFactoryClass, baseClass);
    }

    @Override
    public boolean areRulesSatisfied(Project project, Node node) {
        return RunnerUtils.areRulesSatisfied(this.getRule(), project, node);
    }

    @Override
    public boolean isAcceptableTarget(Class targetClass, boolean exactTargetClass) {
        if (exactTargetClass) {
            return targetClass.getName().equals(this.getTargetClassName());
        }
        return this.isInstanceOf(targetClass, this.getTargetClassName());
    }

    @Override
    public boolean hasInitializedStarterFactory() {
        if (this.starterFactory != null) {
            return true;
        }
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        Extension extension = registry.findExtension(this.extensionId);
        if (extension != null) {
            return registry.isFullyLoaded(extension);
        }
        return false;
    }

    @Override
    public synchronized StarterFactory getStarterFactory() {
        if (this.starterFactory == null) {
            ClassLoader classLoader = this.getClassLoader();
            MetaClass metaClass = new MetaClass(classLoader, this.getStarterFactoryClassName());
            try {
                this.starterFactory = (StarterFactory)metaClass.newInstance();
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
                this.logError("Failed to create StarterFactory from class " + this.getStarterFactoryClassName());
            }
        }
        return this.starterFactory;
    }

    @Override
    public String getTargetClassName() {
        if (this.targetClassName == null) {
            this.targetClassName = this.getAttributeValue(TARGET_CLASS, true);
        }
        return this.targetClassName;
    }

    @Override
    public String getStarterFactoryClassName() {
        if (this.starterFactoryClassName == null) {
            this.starterFactoryClassName = this.getAttributeValue(CLASS_NAME, true);
        }
        return this.starterFactoryClassName;
    }

    @Override
    public String getStarterFactoryBaseClassName() {
        if (this.starterFactoryBaseClassName == null) {
            this.starterFactoryBaseClassName = this.getAttributeValue(BASE_CLASS_NAME, false);
            if (this.starterFactoryBaseClassName == null) {
                this.starterFactoryBaseClassName = "";
            }
        }
        return this.starterFactoryBaseClassName;
    }

    @Override
    public synchronized Class getTargetClass() {
        if (this.targetClass == null) {
            return this.loadClass(this.getTargetClassName());
        }
        return this.targetClass;
    }

    private String getRule() {
        if (this.rule == null) {
            this.rule = this.getAttributeValue("rule", false);
            String errorMsg = RunnerUtils.checkMissingRule(this.rule, this.getStarterFactoryClassName());
            if (errorMsg != null) {
                this.logError(errorMsg);
                this.rule = "always-enabled";
            } else {
                errorMsg = RunnerUtils.isKnownRule(this.rule, this.getStarterFactoryClassName());
                if (errorMsg != null) {
                    this.logError(errorMsg);
                }
            }
        }
        return this.rule;
    }

    @Override
    public synchronized Class getStarterFactoryClass() {
        if (this.starterFactoryClass == null) {
            return this.loadClass(this.getStarterFactoryClassName());
        }
        return this.starterFactoryClass;
    }

    protected Class loadClass(String className) {
        ClassLoader classLoader = this.getClassLoader();
        MetaClass metaClass = new MetaClass(classLoader, className);
        try {
            return metaClass.toClass();
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
            this.logError("Failed to create Class object for class " + className + " in starter-factory definition");
            return null;
        }
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = Integer.toString(System.identityHashCode(this));
        }
        return this.key;
    }

    protected HashStructure getHash() {
        return this.hash;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader loader = null;
        if (this.extensionId != null) {
            loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(this.extensionId);
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }

    protected String getAttributeValue(String name, boolean required) {
        String value;
        String string = value = this.hash == null ? null : this.hash.getString(name, null);
        if (required && (value == null || value.trim().length() == 0)) {
            this.logError("Missing attribute value in starter-factory definition: " + name);
        }
        return value;
    }

    protected synchronized void logError(String msg) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        if (this.extensionId != null) {
            buf.append(" in extension ");
            buf.append(this.extensionId);
        }
        if (this._errors == null) {
            this._errors = new HashSet<String>();
        }
        if (!this._errors.contains(buf.toString())) {
            this._errors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (this.extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(this.extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    protected boolean isInstanceOf(Class derivedClass, String parentName) {
        return StarterFactoryHook.isInstanceOf(derivedClass, parentName);
    }
}

