/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.HashSet;
import oracle.ide.Context;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Node;
import oracle.ide.model.Project;

class RunnerUtils {
    RunnerUtils() {
    }

    static String checkMissingRule(String rule, String className) {
        if (rule == null || rule.trim().length() == 0) {
            return RunnerUtils.ruleError("Missing", null, className);
        }
        return null;
    }

    static String checkValidRule(String rule, String className) {
        RuleEngine engine = RuleEngine.getInstance();
        Rule engineRule = engine.getRule(rule);
        HashSet<String> acceptedRules = new HashSet<String>(2);
        acceptedRules.add("project-has-techscope");
        acceptedRules.add("always-enabled");
        acceptedRules.add("project-content-has-contents");
        if (engineRule == null || !engineRule.matchesType(acceptedRules)) {
            return RunnerUtils.ruleError("Invalid", rule, className);
        }
        return null;
    }

    static String isKnownRule(String rule, String className) {
        RuleEngine engine = RuleEngine.getInstance();
        if (!engine.isKnownRule(rule)) {
            return RunnerUtils.ruleError("Unknown", rule, className);
        }
        return null;
    }

    static boolean areRulesSatisfied(String rule, Project project, Node node) {
        if (project == null) {
            return true;
        }
        if (rule != null && rule.trim().length() > 0) {
            RuleEngine engine = RuleEngine.getInstance();
            if (engine.isKnownRule(rule)) {
                Context context = new Context(null, project);
                if (node != null) {
                    context.setNode(node);
                }
                return engine.evaluateRule(rule, context);
            }
            return false;
        }
        return true;
    }

    private static String ruleError(String prefix, String rule, String className) {
        StringBuilder buf = new StringBuilder();
        buf.append(prefix);
        buf.append(" rule attribute");
        if (rule != null) {
            buf.append(" '");
            buf.append(rule);
            buf.append("'");
        }
        buf.append(" in ");
        buf.append(className);
        buf.append(" registration");
        return buf.toString();
    }
}

