/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogPage;
import oracle.ide.log.StyledMessage;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;

final class LogOutputThread
extends Thread {
    private final RunProcess runProcess;
    private final LogPage logPage;
    private final AttributeSet attributeSet;
    private final InputStreamReader reader;
    private List duplicates;
    private final char[] array = new char[1000];
    private int len;
    private long[] timeLastRead = new long[1];
    private boolean suppressLogging;

    LogOutputThread(String name, RunProcess runProcess, LogPage logPage, AttributeSet attributeSet, InputStream stream, List duplicates) {
        super("LogOutput - " + name);
        this.runProcess = runProcess;
        this.logPage = logPage;
        this.attributeSet = attributeSet;
        this.reader = new InputStreamReader(stream);
        this.makeDuplicates(duplicates);
    }

    @Override
    public void run() {
        this.setTimeLastRead();
        StringBuffer partial = null;
        block4: while (true) {
            try {
                while (true) {
                    try {
                        this.len = this.reader.read(this.array);
                    }
                    catch (IOException e) {
                        this.len = -1;
                    }
                    this.setTimeLastRead();
                    if (this.len == -1) {
                        if (partial == null) break block4;
                        this.log(partial.toString());
                        partial = null;
                        break block4;
                    }
                    this.writeDuplicates();
                    if (this.logPage == null) continue;
                    StringBuffer now = partial != null ? partial : new StringBuffer();
                    partial = null;
                    now.append(this.array, 0, this.len);
                    char last = this.array[this.len - 1];
                    if (last != '\r' && last != '\n') {
                        int lastLF;
                        int lastCR = now.lastIndexOf("\r");
                        int bol = Math.max(lastCR, lastLF = now.lastIndexOf("\n")) + 1;
                        if (bol == 0) {
                            partial = now;
                            now = null;
                        } else {
                            partial = new StringBuffer(now.substring(bol));
                            now.delete(bol, now.length());
                        }
                    }
                    if (now != null) {
                        this.log(now.toString());
                        now = null;
                    }
                    if (partial == null || this.reader.ready()) continue;
                    while (!this.reader.ready() && System.currentTimeMillis() - this.getTimeLastRead() <= 500L) {
                        LogOutputThread.trySleep(10L);
                    }
                    if (this.reader.ready()) continue;
                    this.log(partial.toString());
                    partial = null;
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        this.closeDuplicates();
    }

    private void logMessage(LogPage log, StyledMessage message) {
        if (log instanceof AbstractLogPage && this.runProcess.getUseLogPageQuietly()) {
            ((AbstractLogPage)log).logQuietly((Object)message);
        } else {
            log.log((Object)message);
        }
    }

    private void log(String s) {
        if (!this.runProcess.getSuppressLogging()) {
            StyledMessage styledMessage = new StyledMessage(this.attributeSet, s);
            if (this.logPage instanceof RunLogPage) {
                ((RunLogPage)this.logPage).logWithoutShow(styledMessage);
            } else {
                this.logMessage(this.logPage, styledMessage);
            }
            if (!this.runProcess.doUILater()) {
                EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                for (int sleepTime = 100; eq.peekEvent() != null && sleepTime < 1000; sleepTime *= 2) {
                    LogOutputThread.trySleep(sleepTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeLastRead() {
        long[] lArray = this.timeLastRead;
        synchronized (this.timeLastRead) {
            this.timeLastRead[0] = System.currentTimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimeLastRead() {
        long[] lArray = this.timeLastRead;
        synchronized (this.timeLastRead) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.timeLastRead[0];
        }
    }

    static synchronized void waitForOutput(LogOutputThread logOutputThread) {
        while (logOutputThread.isAlive() && System.currentTimeMillis() - logOutputThread.getTimeLastRead() <= 1000L) {
            LogOutputThread.trySleep(100L);
        }
    }

    private void makeDuplicates(List duplicates) {
        if (duplicates != null) {
            this.duplicates = new ArrayList();
            for (int i = duplicates.size() - 1; i >= 0; --i) {
                try {
                    PipedInputStream pis = (PipedInputStream)duplicates.get(i);
                    this.duplicates.add(new OutputStreamWriter(new PipedOutputStream(pis)));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void writeDuplicates() {
        if (this.duplicates != null) {
            for (int i = this.duplicates.size() - 1; i >= 0; --i) {
                try {
                    OutputStreamWriter osw = (OutputStreamWriter)this.duplicates.get(i);
                    osw.write(this.array, 0, this.len);
                    osw.flush();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void closeDuplicates() {
        if (this.duplicates != null) {
            for (int i = this.duplicates.size() - 1; i >= 0; --i) {
                try {
                    OutputStreamWriter osw = (OutputStreamWriter)this.duplicates.get(i);
                    osw.flush();
                    osw.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void trySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

