/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public class WindowSettingsColumnManager {
    private static final String COLUMN_VISIBLE = "columnVisible";
    private static final String COLUMN_NUMERIC = "columnNumeric";
    private static final String COLUMN_BREADCRUMB_VISIBLE = "columnBreadcrumbVisible";
    private static final String COLUMN_WIDTH = "columnWidth";
    private static final String COLUMN_BREADCRUMB_WIDTH = "columnBreadcrumbWidth";
    private static final String COLUMN_ORDER = "columnOrder";
    private static final String COLUMN_BREADCRUMB_ORDER = "columnBreadcrumbOrder";
    private static final String COLUMN_NAMES = "columnNames";
    private static final String COLUMN_NAMES_PREFS = "columnNamesInPrefPane";
    private static final String ACTIVE_DATA_VIEW = "activeDataView";
    private static final String VM_NAMES = "vmNames";

    static boolean getColumnVisible(HashStructure hash, String VMName, int column) {
        return hash.getBoolean(COLUMN_VISIBLE + VMName + column);
    }

    static void setColumnVisible(HashStructure hash, String VMName, int column, boolean visible) {
        if (hash == null) {
            return;
        }
        hash.remove(COLUMN_VISIBLE);
        hash.putBoolean(COLUMN_VISIBLE + VMName + column, visible);
    }

    static boolean getColumnNumeric(HashStructure hash, String VMName, int column) {
        return hash.getBoolean(COLUMN_NUMERIC + VMName + column);
    }

    static void setColumnNumeric(HashStructure hash, String VMName, int column, boolean numeric) {
        if (hash == null) {
            return;
        }
        hash.putBoolean(COLUMN_NUMERIC + VMName + column, numeric);
    }

    static boolean getColumnBreadcrumbVisible(HashStructure hash, String vmName, int columnIndex) {
        boolean defaultValue = columnIndex == 0 || columnIndex == 2 || columnIndex == 1;
        return hash.getBoolean(COLUMN_BREADCRUMB_VISIBLE + vmName + columnIndex, defaultValue);
    }

    static void setColumnBreadcrumbVisible(HashStructure hash, String vmName, int columnIndex, boolean columnVisible) {
        if (hash == null) {
            return;
        }
        hash.putBoolean(COLUMN_BREADCRUMB_VISIBLE + vmName + columnIndex, columnVisible);
    }

    static int getColumnWidth(HashStructure hash, String VMName, int column) {
        return hash.getInt(COLUMN_WIDTH + VMName + column, 0);
    }

    static void setColumnWidth(HashStructure hash, String VMName, int column, int width) {
        if (hash == null) {
            return;
        }
        hash.remove(COLUMN_WIDTH);
        hash.putInt(COLUMN_WIDTH + VMName + column, width);
    }

    static int getColumnBreadcrumbWidth(HashStructure hash, String vmName, int columnIndex) {
        return hash.getInt(COLUMN_BREADCRUMB_WIDTH + vmName + columnIndex, 0);
    }

    static void setColumnBreadcrumbWidth(HashStructure hash, String vmName, int columnIndex, int columnWidth) {
        if (hash == null) {
            return;
        }
        hash.putInt(COLUMN_BREADCRUMB_WIDTH + vmName + columnIndex, columnWidth);
    }

    static String getColumnOrder(HashStructure hash, String VMName) {
        return hash.getString(COLUMN_ORDER + VMName);
    }

    static void setColumnOrder(HashStructure hash, String VMName, String columnOrder) {
        if (hash == null) {
            return;
        }
        hash.remove(COLUMN_ORDER);
        hash.putString(COLUMN_ORDER + VMName, columnOrder);
    }

    static String getColumnBreadcrumbOrder(HashStructure hash, String vmName) {
        return hash.getString(COLUMN_BREADCRUMB_ORDER + vmName);
    }

    static void setColumnBreadcrumbOrder(HashStructure hash, String vmName, String columnOrder) {
        if (hash == null) {
            return;
        }
        hash.putString(COLUMN_BREADCRUMB_ORDER + vmName, columnOrder);
    }

    static List<String> getColumnNames(HashStructure hash, String VMName) {
        if (hash == null) {
            return Collections.emptyList();
        }
        ListStructure names = hash.getListStructure(COLUMN_NAMES + VMName);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i) == null ? null : names.get(i).toString());
        }
        return stringList;
    }

    static void setColumnNames(HashStructure hash, String VMName, List<String> columnNames) {
        if (hash == null) {
            return;
        }
        ListStructure names = ListStructure.newInstance();
        for (String name : columnNames) {
            names.add((Object)name);
        }
        hash.putListStructure(COLUMN_NAMES + VMName, names);
    }

    static List<String> getColumnNamesInPreferences(HashStructure hash, String VMName) {
        ListStructure names = hash.getListStructure(COLUMN_NAMES_PREFS + VMName);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i) == null ? null : names.get(i).toString());
        }
        return stringList;
    }

    static void setColumnNamesInPreferences(HashStructure hash, String VMName, List<String> columnNames) {
        if (hash == null) {
            return;
        }
        ListStructure names = ListStructure.newInstance();
        for (String name : columnNames) {
            names.add((Object)name);
        }
        hash.putListStructure(COLUMN_NAMES_PREFS + VMName, names);
    }

    public static String getActiveDataView(HashStructure hash, String VMName, String windowId) {
        return hash.getString(ACTIVE_DATA_VIEW + VMName + windowId, "TABLE_TABLE");
    }

    public static String getActiveDataViewNoDefault(HashStructure hash, String VMName, String windowId) {
        return hash.getString(ACTIVE_DATA_VIEW + VMName + windowId);
    }

    public static void setActiveDataView(HashStructure hash, String VMName, String windowId, String dataView) {
        if (hash == null) {
            return;
        }
        hash.putString(ACTIVE_DATA_VIEW + VMName + windowId, dataView);
    }

    static List<String> getVMNames(HashStructure hash) {
        if (hash == null) {
            return Collections.emptyList();
        }
        ListStructure names = hash.getListStructure(VM_NAMES);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i).toString());
        }
        return stringList;
    }

    static void addVMName(HashStructure hash, String VMName) {
        if (hash == null) {
            return;
        }
        ListStructure names = hash.getListStructure(VM_NAMES);
        if (names == null) {
            names = ListStructure.newInstance();
        }
        if (!names.contains((Object)VMName)) {
            names.add((Object)VMName);
            hash.putListStructure(VM_NAMES, names);
        }
    }
}

