/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.hover.Hover;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.runner.debug.CustomDataProvider;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataTipDisplayer;
import oracle.jdevimpl.runner.debug.DataValueHelper;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.ExpressionProvider;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.StackWindow;
import oracle.jdevimpl.runner.debug.ToolTipSettings;

class ToolTipEvaluator {
    private JDebugger jdebugger;
    private Evaluator evaluator;

    ToolTipEvaluator(JDebugger jdebugger) {
        this.jdebugger = jdebugger;
        this.evaluator = new Evaluator(false);
    }

    String getToolTip(CodeEditor codeEditor, int offset) {
        try {
            Set<ExpressionProvider.ExpressionWithMetaData> expressions = ExpressionProvider.getToolTipExpressions(codeEditor, offset);
            Window w = SwingUtilities.getWindowAncestor((Component)codeEditor.getFocusedEditorPane());
            for (ExpressionProvider.ExpressionWithMetaData expression : expressions) {
                if (!this.evaluateAndShow(expression, w)) continue;
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    Hover showDataHover(CodeEditor codeEditor, int offset) {
        try {
            Set<ExpressionProvider.ExpressionWithMetaData> expressions = ExpressionProvider.getToolTipExpressions(codeEditor, offset);
            Window w = SwingUtilities.getWindowAncestor((Component)codeEditor.getFocusedEditorPane());
            for (ExpressionProvider.ExpressionWithMetaData expression : expressions) {
                Hover hover = this.evaluateAndShowHover(expression, w);
                if (hover == null) continue;
                return hover;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean evaluateAndShow(ExpressionProvider.ExpressionWithMetaData expression, Window w) {
        Hover hover = this.evaluateAndShowHover(expression, w);
        return hover != null;
    }

    private Hover evaluateAndShowHover(ExpressionProvider.ExpressionWithMetaData expression, Window w) {
        StackWindow stackWindow = this.jdebugger.getStackWindow(true);
        stackWindow.updateEvaluator(this.evaluator);
        Object info = this.evaluator.evaluate(expression.getExpression());
        if (info != null) {
            DebugDataInfo data = null;
            try {
                data = Evaluator.getDataInfo(info);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (data == null && !(info instanceof DebugStackSlotInfo) && !expression.isSelection()) {
                return null;
            }
            String dataValue = DataValueHelper.makeDataValue(info, data);
            if ((dataValue == null || dataValue.length() == 0) && data instanceof DebugDataCompositeInfo && !((DebugDataCompositeInfo)data).isNull()) {
                DebugClassInfo clazz = data.getClassInfo();
                dataValue = "( " + DebugShared.makeCourtesyClassName(clazz, true) + " )";
            }
            if (dataValue != null && dataValue.length() > 0) {
                CustomDataProvider dataProvider = new CustomDataProvider();
                dataProvider.getGUI();
                dataProvider.updateContext(this.jdebugger.getActiveDebuggingProcess(), this.evaluator.vm, this.evaluator.thread, this.evaluator.frame);
                DataItem dataItem = dataProvider.makeDataItem(data == null ? info : data, expression.getExpression());
                ToolTipSettings toolTipSettings = ToolTipSettings.getInstance();
                ArrayList<Integer> visibleColumns = new ArrayList<Integer>();
                for (int i = 0; i < 8; ++i) {
                    if (!toolTipSettings.getColumnVisible(i)) continue;
                    visibleColumns.add(i);
                }
                DataTipDisplayer dataTipDisplayer = new DataTipDisplayer(dataProvider, dataItem, visibleColumns);
                return dataTipDisplayer.prepareAndShowAsHover(w);
            }
        }
        return null;
    }

    void clearEvaluator() {
        StackWindow stackWindow = this.jdebugger.getStackWindow(true);
        stackWindow.updateEvaluator(this.evaluator);
    }
}

