/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.plsql.old.PlsqlParser;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ExpressionList;
import oracle.javatools.parser.plsql.old.symbol.ExpressionSymbol;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.EvaluationInfo;

class PlsqlEvaluator
extends BaseEvaluator {
    private static final String BUILTIN_TYPE_INT = "PLS_INTEGER";
    private static final String FANCY_BUILTIN_TYPE_INT = "$Oracle.Builtin.PLS_INTEGER";
    private static final String BUILTIN_TYPE_DOUBLE = "NUMBER";
    private static final String FANCY_BUILTIN_TYPE_DOUBLE = "$Oracle.Builtin.NUMBER";
    private static final String BUILTIN_TYPE_BOOLEAN = "BOOLEAN";
    private static final String FANCY_BUILTIN_TYPE_BOOLEAN = "$Oracle.Builtin.BOOLEAN";
    private static final String BUILTIN_TYPE_STRING = "VARCHAR";
    private static final String FANCY_BUILTIN_TYPE_STRING = "$Oracle.Builtin.VARCHAR2";
    private static final String BUILTIN_TYPE_UNKNOWN = "UNKNOWN";
    private static final String FANCY_BUILTIN_TYPE_UNKNOWN = "$Oracle.Builtin.VARCHAR2";
    private static final int SIGNATURE_INT = 0;
    private static final int SIGNATURE_DOUBLE = 1;
    private static final int SIGNATURE_BOOLEAN = 2;
    private static final int SIGNATURE_STRING = 3;
    private static final int SIGNATURE_UNKNOWN = 4;

    PlsqlEvaluator(DebugContext debugContext) {
        super(debugContext);
    }

    @Override
    public boolean validate(String exp) {
        block3: {
            try {
                ReadTextBuffer buffer = TextBufferFactory.createReadTextBuffer((String)exp);
                PlsqlParser.ParsingOptions options = new PlsqlParser.ParsingOptions();
                options.inputType = 2;
                options.parseDepth = 2;
                ErrorReporter ps = PlsqlParser.parse((ReadTextBuffer)buffer, (PlsqlParser.ParsingOptions)options);
                if (ps instanceof ExpressionSymbol) {
                    return true;
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)e;
            }
        }
        return false;
    }

    @Override
    public int evaluateConditionResult(Object o, boolean allowMethodInvocation) {
        block4: {
            try {
                EvaluationInfo eval = this.convertToEvaluationInfo(o);
                if (eval != null && this.classNamesMatch(eval.getClassInfo().getName(), BUILTIN_TYPE_BOOLEAN)) {
                    if (DebugSharedPrimitives.booleanDecode(eval.getValue())) {
                        return 1;
                    }
                    return 0;
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block4;
                throw (ThreadDeath)e;
            }
        }
        return -1;
    }

    @Override
    public boolean canEvaluate(String expression) {
        return this.validate(expression);
    }

    @Override
    public Object evaluate(String exp, boolean allowMethodInvocation) {
        String upper;
        Object o = this.evaluateInternal(exp);
        if (o == null && !(upper = exp.toUpperCase()).equals(exp)) {
            o = this.evaluateInternal(upper);
        }
        return o;
    }

    private Object evaluateInternal(String exp) {
        block4: {
            try {
                ReadTextBuffer buffer = TextBufferFactory.createReadTextBuffer((String)exp);
                PlsqlParser.ParsingOptions options = new PlsqlParser.ParsingOptions();
                options.inputType = 2;
                options.parseDepth = 2;
                ErrorReporter ps = PlsqlParser.parse((ReadTextBuffer)buffer, (PlsqlParser.ParsingOptions)options);
                if (ps instanceof ExpressionSymbol) {
                    Object o = this.processExpressionSymbol((ExpressionSymbol)ps);
                    if (o instanceof String) {
                        o = this.evaluateSimple((String)o);
                    }
                    return o;
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block4;
                throw (ThreadDeath)e;
            }
        }
        return null;
    }

    private Object processExpressionSymbol(ExpressionSymbol es) throws Exception {
        switch (es.getCategory()) {
            case 600: {
                return this.processExpressionSymbol(es.getFirstOperand());
            }
            case -1: {
                throw new Exception("Unable to process expression symbol: unknown");
            }
            case 610: {
                return this.processExpressionSymbol(es.getFirstOperand());
            }
            case 630: {
                throw new Exception("Unable to process expression symbol: sql");
            }
            case 711: {
                return this.evaluatePrefixOperator(es);
            }
            case 712: {
                return this.evaluateInfixOperator(es);
            }
            case 713: {
                return this.evaluateSpecialOperator(es);
            }
            case 750: {
                return this.evaluatePrimary(es);
            }
            case 760: {
                return this.evaluateArguments(es);
            }
        }
        throw new Exception("Unable to process expression symbol");
    }

    private EvaluationInfo evaluateInfixOperator(ExpressionSymbol es) throws Exception {
        Object o1 = this.processExpressionSymbol(es.getFirstOperand());
        EvaluationInfo eval1 = this.convertToEvaluationInfo(o1);
        int operator = es.getExactCode();
        if (operator == 1002 || operator == 1108) {
            return this.evaluateLogicalInfixOperator(eval1, es, operator);
        }
        Object o2 = this.processExpressionSymbol(es.getSecondOperand());
        EvaluationInfo eval2 = this.convertToEvaluationInfo(o2);
        switch (operator) {
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                return this.evaluateComparisonOperator(o1, eval1, o2, eval2, operator);
            }
            case 100: 
            case 103: 
            case 108: 
            case 111: 
            case 115: {
                return this.evaluateArithmeticInfixOperator(eval1, eval2, operator);
            }
            case 114: {
                return this.concatenate(eval1, eval2);
            }
        }
        throw new Exception("Unable to evaluate infix operator");
    }

    private EvaluationInfo concatenate(EvaluationInfo eval1, EvaluationInfo eval2) throws Exception {
        String class2;
        EvaluationInfo casted2;
        String class1 = eval1.getClassInfo().getName();
        EvaluationInfo casted1 = (EvaluationInfo)this.performBuiltinPromotion(eval1, class1, BUILTIN_TYPE_STRING);
        if (casted1 != eval1) {
            eval1.copyFrom(casted1);
        }
        if ((casted2 = (EvaluationInfo)this.performBuiltinPromotion(eval2, class2 = eval2.getClassInfo().getName(), BUILTIN_TYPE_STRING)) != eval2) {
            eval2.copyFrom(casted2);
        }
        String s1 = eval1.getValue();
        String s2 = eval2.getValue();
        if (s1.startsWith("'") && s1.endsWith("'")) {
            s1 = s1.substring(1, s1.length() - 1);
        }
        if (s2.startsWith("'") && s2.endsWith("'")) {
            s2 = s2.substring(1, s2.length() - 1);
        }
        String result = "'" + s1 + s2 + "'";
        return new EvaluationInfo(result, this.findBuiltinStringClass());
    }

    private EvaluationInfo evaluateLogicalInfixOperator(EvaluationInfo eval1, ExpressionSymbol es, int operator) throws Exception {
        boolean bad = false;
        Boolean result = null;
        if (this.isBoolean(eval1)) {
            switch (operator) {
                case 1108: {
                    Boolean b1 = this.getBooleanValue(eval1);
                    if (b1 == Boolean.TRUE) {
                        result = Boolean.TRUE;
                        break;
                    }
                    Object o2 = this.processExpressionSymbol(es.getSecondOperand());
                    EvaluationInfo eval2 = this.convertToEvaluationInfo(o2);
                    if (this.isBoolean(eval2)) {
                        Boolean b2 = this.getBooleanValue(eval2);
                        if (b2 == Boolean.TRUE) {
                            result = Boolean.TRUE;
                            break;
                        }
                        if (b1 == null || b2 == null) {
                            result = null;
                            break;
                        }
                        result = Boolean.FALSE;
                        break;
                    }
                    bad = true;
                    break;
                }
                case 1002: {
                    Boolean b1 = this.getBooleanValue(eval1);
                    if (b1 == Boolean.FALSE) {
                        result = Boolean.FALSE;
                        break;
                    }
                    Object o2 = this.processExpressionSymbol(es.getSecondOperand());
                    EvaluationInfo eval2 = this.convertToEvaluationInfo(o2);
                    if (this.isBoolean(eval2)) {
                        Boolean b2 = this.getBooleanValue(eval2);
                        if (b2 == Boolean.FALSE) {
                            result = Boolean.FALSE;
                            break;
                        }
                        if (b1 == null || b2 == null) {
                            result = null;
                            break;
                        }
                        result = Boolean.TRUE;
                        break;
                    }
                    bad = true;
                    break;
                }
            }
        } else {
            bad = true;
        }
        if (!bad) {
            return this.makeBooleanValue(result);
        }
        throw new Exception("Unable to evaluate logical infix operator");
    }

    private EvaluationInfo evaluateComparisonOperator(Object o1, EvaluationInfo eval1, Object o2, EvaluationInfo eval2, int operator) throws Exception {
        int sig = this.comparisonPromotion(eval1, eval2);
        switch (sig) {
            case 0: {
                int n1 = Integer.decode(eval1.getValue());
                int n2 = Integer.decode(eval2.getValue());
                boolean result = false;
                switch (operator) {
                    case 119: {
                        result = n1 == n2;
                        break;
                    }
                    case 122: {
                        result = n1 != n2;
                        break;
                    }
                    case 120: {
                        result = n1 < n2;
                        break;
                    }
                    case 121: {
                        result = n1 > n2;
                        break;
                    }
                    case 123: {
                        result = n1 <= n2;
                        break;
                    }
                    case 124: {
                        result = n1 >= n2;
                    }
                }
                return this.makeBooleanValue(result ? Boolean.TRUE : Boolean.FALSE);
            }
            case 1: {
                double n1 = Double.parseDouble(eval1.getValue());
                double n2 = Double.parseDouble(eval2.getValue());
                boolean result = false;
                switch (operator) {
                    case 119: {
                        result = n1 == n2;
                        break;
                    }
                    case 122: {
                        result = n1 != n2;
                        break;
                    }
                    case 120: {
                        result = n1 < n2;
                        break;
                    }
                    case 121: {
                        result = n1 > n2;
                        break;
                    }
                    case 123: {
                        result = n1 <= n2;
                        break;
                    }
                    case 124: {
                        result = n1 >= n2;
                    }
                }
                return this.makeBooleanValue(result ? Boolean.TRUE : Boolean.FALSE);
            }
            case 2: {
                boolean n1 = Boolean.valueOf(eval1.getValue());
                boolean n2 = Boolean.valueOf(eval2.getValue());
                boolean result = false;
                switch (operator) {
                    case 119: {
                        result = n1 == n2;
                        break;
                    }
                    case 122: {
                        result = n1 != n2;
                        break;
                    }
                    case 120: 
                    case 121: 
                    case 123: 
                    case 124: {
                        throw new Exception("Unable to evaluate comparison operator");
                    }
                }
                return this.makeBooleanValue(result ? Boolean.TRUE : Boolean.FALSE);
            }
            case 3: {
                String s1 = eval1.getValue();
                String s2 = eval2.getValue();
                boolean result = false;
                switch (operator) {
                    case 119: {
                        result = ModelUtil.areEqual((Object)s1, (Object)s2);
                        break;
                    }
                    case 122: {
                        result = !ModelUtil.areEqual((Object)s1, (Object)s2);
                        break;
                    }
                    case 120: {
                        result = s1.compareTo(s2) < 0;
                        break;
                    }
                    case 121: {
                        result = s1.compareTo(s2) > 0;
                        break;
                    }
                    case 123: {
                        result = s1.compareTo(s2) <= 0;
                        break;
                    }
                    case 124: {
                        result = s1.compareTo(s2) >= 0;
                    }
                }
                return this.makeBooleanValue(result ? Boolean.TRUE : Boolean.FALSE);
            }
            case 4: {
                String s1 = eval1.getValue();
                String s2 = eval2.getValue();
                boolean result = false;
                switch (operator) {
                    case 119: {
                        result = ModelUtil.areEqual((Object)s1, (Object)s2);
                        break;
                    }
                    case 122: {
                        result = !ModelUtil.areEqual((Object)s1, (Object)s2);
                        break;
                    }
                    case 120: 
                    case 121: 
                    case 123: 
                    case 124: {
                        throw new Exception("Unable to evaluate comparison operator");
                    }
                }
                return this.makeBooleanValue(result ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        throw new Exception("Unable to evaluate comparison operator");
    }

    private EvaluationInfo evaluateArithmeticInfixOperator(EvaluationInfo eval1, EvaluationInfo eval2, int operator) throws Exception {
        int sig = this.binaryNumericPromotion(eval1, eval2);
        switch (sig) {
            case 0: {
                int n1 = Integer.decode(eval1.getValue());
                int n2 = Integer.decode(eval2.getValue());
                int result = 0;
                switch (operator) {
                    case 100: {
                        result = n1 + n2;
                        break;
                    }
                    case 111: {
                        result = n1 - n2;
                        break;
                    }
                    case 108: {
                        result = n1 * n2;
                        break;
                    }
                    case 103: {
                        result = n1 / n2;
                        break;
                    }
                    case 115: {
                        result = (int)Math.pow(n1, n2);
                    }
                }
                return new EvaluationInfo(result, this.findBuiltinIntClass());
            }
            case 1: {
                double n1 = Double.parseDouble(eval1.getValue());
                double n2 = Double.parseDouble(eval2.getValue());
                double result = 0.0;
                switch (operator) {
                    case 100: {
                        result = n1 + n2;
                        break;
                    }
                    case 111: {
                        result = n1 - n2;
                        break;
                    }
                    case 108: {
                        result = n1 * n2;
                        break;
                    }
                    case 103: {
                        result = n1 / n2;
                        break;
                    }
                    case 115: {
                        result = Math.pow(n1, n2);
                    }
                }
                return new EvaluationInfo(result, this.findBuiltinDoubleClass());
            }
        }
        throw new Exception("Unable to evaluate arithmetic infix operator");
    }

    private EvaluationInfo evaluateSpecialOperator(ExpressionSymbol es) throws Exception {
        int operator = es.getExactCode();
        boolean negative = false;
        if (operator < 0) {
            operator = -operator;
            negative = true;
        }
        switch (operator) {
            case 1074: {
                Object o1 = this.processExpressionSymbol(es.getFirstOperand());
                EvaluationInfo eval1 = this.convertToEvaluationInfo(o1);
                boolean isNull = PlsqlEvaluator.isNull(eval1);
                boolean result = negative ? !isNull : isNull;
                return this.makeBooleanValue(result ? Boolean.TRUE : Boolean.FALSE);
            }
            case 1011: {
                Object o1 = this.processExpressionSymbol(es.getFirstOperand());
                Object o2 = this.processExpressionSymbol(es.getSecondOperand());
                Object o3 = this.processExpressionSymbol(es.getThirdOperand());
                EvaluationInfo eval1 = this.convertToEvaluationInfo(o1);
                EvaluationInfo eval2 = this.convertToEvaluationInfo(o2);
                EvaluationInfo eval3 = this.convertToEvaluationInfo(o3);
                EvaluationInfo result1 = this.evaluateComparisonOperator(o1, eval1, o2, eval2, 124);
                EvaluationInfo result2 = this.evaluateComparisonOperator(o1, eval1, o3, eval3, 123);
                boolean b1 = Boolean.valueOf(result1.getValue());
                boolean b2 = Boolean.valueOf(result2.getValue());
                boolean result = b1 && b2;
                return this.makeBooleanValue(result ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        throw new Exception("Unable to process expression symbol: special operator");
    }

    private static boolean isNull(EvaluationInfo eval) {
        String value = eval.getValue(true);
        return value != null && value.equals("NULL");
    }

    private EvaluationInfo evaluatePrefixOperator(ExpressionSymbol es) throws Exception {
        Object o1 = this.processExpressionSymbol(es.getFirstOperand());
        EvaluationInfo eval1 = this.convertToEvaluationInfo(o1);
        int operator = es.getExactCode();
        switch (operator) {
            case 1096: {
                return this.evaluateLogicalPrefixOperator(eval1, operator);
            }
            case 100: 
            case 111: {
                return this.evaluateArithmeticPrefixOperator(eval1, operator);
            }
        }
        throw new Exception("Unable to evaluate prefix operator");
    }

    private EvaluationInfo evaluateArithmeticPrefixOperator(EvaluationInfo eval1, int operator) throws Exception {
        int sig = this.unaryNumericPromotion(eval1);
        switch (sig) {
            case 0: {
                int n1 = Integer.decode(eval1.getValue());
                int result = 0;
                switch (operator) {
                    case 100: {
                        result = n1;
                        break;
                    }
                    case 111: {
                        result = -n1;
                    }
                }
                return new EvaluationInfo(result, this.findBuiltinIntClass());
            }
            case 1: {
                double n1 = Double.parseDouble(eval1.getValue());
                double result = 0.0;
                switch (operator) {
                    case 100: {
                        result = n1;
                        break;
                    }
                    case 111: {
                        result = -n1;
                    }
                }
                return new EvaluationInfo(result, this.findBuiltinDoubleClass());
            }
        }
        throw new Exception("Unable to evaluate arithmetic prefix operator");
    }

    private EvaluationInfo evaluateLogicalPrefixOperator(EvaluationInfo eval1, int operator) throws Exception {
        if (this.isBoolean(eval1)) {
            Boolean result = Boolean.FALSE;
            switch (operator) {
                case 1096: {
                    Boolean b1 = this.getBooleanValue(eval1);
                    result = PlsqlEvaluator.notBooleanValue(b1);
                    break;
                }
            }
            return this.makeBooleanValue(result);
        }
        throw new Exception("Unable to evaluate logical prefix operator");
    }

    private boolean isBoolean(EvaluationInfo eval) {
        String className = eval.getClassInfo().getName();
        if (this.classNamesMatch(className, BUILTIN_TYPE_BOOLEAN)) {
            return true;
        }
        return this.classNamesMatch(className, BUILTIN_TYPE_UNKNOWN) && PlsqlEvaluator.isNull(eval);
    }

    private Boolean getBooleanValue(EvaluationInfo eval) throws Exception {
        try {
            if (PlsqlEvaluator.isNull(eval)) {
                return null;
            }
            String s = eval.getValue();
            if (s.equalsIgnoreCase("TRUE")) {
                return Boolean.TRUE;
            }
            if (s.equalsIgnoreCase("FALSE")) {
                return Boolean.FALSE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new Exception("Unable to process boolean");
    }

    private static Boolean notBooleanValue(Boolean b) {
        if (b == Boolean.TRUE) {
            return Boolean.FALSE;
        }
        if (b == Boolean.FALSE) {
            return Boolean.TRUE;
        }
        return null;
    }

    private EvaluationInfo makeBooleanValue(Boolean b) throws Exception {
        String value = b == Boolean.TRUE ? "TRUE" : (b == Boolean.FALSE ? "FALSE" : "NULL");
        return new EvaluationInfo(value, this.findBuiltinBooleanClass());
    }

    private int comparisonPromotion(EvaluationInfo eval1, EvaluationInfo eval2) throws Exception {
        String class1 = eval1.getClassInfo().getName();
        String class2 = eval2.getClassInfo().getName();
        String promotionClass = null;
        int sig = -1;
        if (this.classNamesMatch(class1, BUILTIN_TYPE_DOUBLE) || this.classNamesMatch(class2, BUILTIN_TYPE_DOUBLE)) {
            promotionClass = BUILTIN_TYPE_DOUBLE;
            sig = 1;
        } else if (this.classNamesMatch(class1, BUILTIN_TYPE_INT) || this.classNamesMatch(class2, BUILTIN_TYPE_INT)) {
            promotionClass = BUILTIN_TYPE_INT;
            sig = 0;
        } else if (this.classNamesMatch(class1, BUILTIN_TYPE_BOOLEAN) || this.classNamesMatch(class2, BUILTIN_TYPE_BOOLEAN)) {
            promotionClass = BUILTIN_TYPE_BOOLEAN;
            sig = 2;
        } else if (this.classNamesMatch(class1, BUILTIN_TYPE_STRING) || this.classNamesMatch(class2, BUILTIN_TYPE_STRING)) {
            promotionClass = BUILTIN_TYPE_STRING;
            sig = 3;
        } else if (this.classNamesMatch(class1, BUILTIN_TYPE_UNKNOWN) || this.classNamesMatch(class2, BUILTIN_TYPE_UNKNOWN)) {
            promotionClass = BUILTIN_TYPE_UNKNOWN;
            sig = 4;
        }
        if (promotionClass != null) {
            EvaluationInfo casted2;
            EvaluationInfo casted1 = (EvaluationInfo)this.performBuiltinPromotion(eval1, class1, promotionClass);
            if (casted1 != eval1) {
                eval1.copyFrom(casted1);
            }
            if ((casted2 = (EvaluationInfo)this.performBuiltinPromotion(eval2, class2, promotionClass)) != eval2) {
                eval2.copyFrom(casted2);
            }
            return sig;
        }
        throw new Exception("Unable to evaluate comparison operator");
    }

    private void evaluateArgValue(EvaluationInfo evalInfo) throws Exception {
        DebugClassInfo c1;
        String className = "";
        if (evalInfo != null && (c1 = evalInfo.getClassInfo()) != null) {
            className = c1.getName();
        }
        EvaluationInfo casted = (EvaluationInfo)this.performBuiltinPromotion(evalInfo, className, className);
        if ((casted = this.truncateIntegerValue(casted)) != evalInfo) {
            evalInfo.copyFrom(casted);
        }
    }

    private EvaluationInfo truncateIntegerValue(EvaluationInfo evalInfo) {
        EvaluationInfo retval = evalInfo;
        String val = evalInfo.getValue();
        try {
            if (val.endsWith(".0")) {
                val = val.substring(0, val.length() - 2);
                int intval = Integer.decode(val);
                retval = new EvaluationInfo(intval, this.findBuiltinIntClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private int unaryNumericPromotion(EvaluationInfo eval1) throws Exception {
        DebugClassInfo c1;
        String class1 = "";
        if (eval1 != null && (c1 = eval1.getClassInfo()) != null) {
            class1 = c1.getName();
        }
        return this.unaryNumericPromotion(eval1, class1);
    }

    private int unaryNumericPromotion(EvaluationInfo eval1, String class1) throws Exception {
        String promotionClass = null;
        int sig = -1;
        if (this.classNamesMatch(class1, BUILTIN_TYPE_DOUBLE)) {
            promotionClass = BUILTIN_TYPE_DOUBLE;
            sig = 1;
        } else {
            promotionClass = BUILTIN_TYPE_INT;
            sig = 0;
        }
        EvaluationInfo casted1 = (EvaluationInfo)this.performBuiltinPromotion(eval1, class1, promotionClass);
        if (casted1 != eval1) {
            eval1.copyFrom(casted1);
        }
        return sig;
    }

    private int binaryNumericPromotion(EvaluationInfo eval1, EvaluationInfo eval2) throws Exception {
        DebugClassInfo c2;
        DebugClassInfo c1;
        String class1 = "";
        String class2 = "";
        if (eval1 != null && (c1 = eval1.getClassInfo()) != null) {
            class1 = c1.getName();
        }
        if (eval2 != null && (c2 = eval2.getClassInfo()) != null) {
            class2 = c2.getName();
        }
        return this.binaryNumericPromotion(eval1, class1, eval2, class2);
    }

    private int binaryNumericPromotion(EvaluationInfo eval1, String class1, EvaluationInfo eval2, String class2) throws Exception {
        EvaluationInfo casted2;
        String promotionClass = null;
        int sig = -1;
        if (this.classNamesMatch(class1, BUILTIN_TYPE_DOUBLE) || this.classNamesMatch(class2, BUILTIN_TYPE_DOUBLE)) {
            promotionClass = BUILTIN_TYPE_DOUBLE;
            sig = 1;
        } else {
            promotionClass = BUILTIN_TYPE_INT;
            sig = 0;
        }
        EvaluationInfo casted1 = (EvaluationInfo)this.performBuiltinPromotion(eval1, class1, promotionClass);
        if (casted1 != eval1) {
            eval1.copyFrom(casted1);
        }
        if ((casted2 = (EvaluationInfo)this.performBuiltinPromotion(eval2, class2, promotionClass)) != eval2) {
            eval2.copyFrom(casted2);
        }
        return sig;
    }

    private Object evaluatePrimary(ExpressionSymbol es) throws Exception {
        int exactCode = es.getExactCode();
        if (PlsqlSyntaxRecognizer.isLiteralToken((int)exactCode) || exactCode == 1051 || exactCode == 1162) {
            return this.evaluateConstant(es);
        }
        String name = es.getName().getValue();
        if (es instanceof ExpressionList) {
            ExpressionList el = (ExpressionList)es;
            ExpressionSymbol[] expressions = el.getExpressions();
            int expressionsLength = expressions.length;
            for (int i = 0; i < expressionsLength; ++i) {
                Object o = this.processExpressionSymbol(expressions[i]);
                if (!(o instanceof String)) {
                    throw new Exception("Unable to process expression symbol: primary");
                }
                name = name + o;
            }
        }
        return name;
    }

    private EvaluationInfo evaluateConstant(ExpressionSymbol es) throws Exception {
        String value = es.getName().getValue();
        switch (es.getExactCode()) {
            case 51: {
                return new EvaluationInfo(DebugSharedPrimitives.intDecode(value), this.findBuiltinIntClass());
            }
            case 52: {
                return new EvaluationInfo(DebugSharedPrimitives.doubleDecode(value), this.findBuiltinDoubleClass());
            }
            case 53: {
                return this.makeBooleanValue(DebugSharedPrimitives.booleanDecode(value) ? Boolean.TRUE : Boolean.FALSE);
            }
            case 1051: {
                return this.makeBooleanValue(Boolean.FALSE);
            }
            case 1162: {
                return this.makeBooleanValue(Boolean.TRUE);
            }
            case 54: {
                return new EvaluationInfo(value, this.findBuiltinStringClass());
            }
            case 55: {
                return new EvaluationInfo("NULL", this.findBuiltinUnknownClass(), null);
            }
        }
        throw new Exception("Evaluate Constant unknown constant type");
    }

    private Object evaluateArguments(ExpressionSymbol es) throws Exception {
        if (es instanceof ExpressionList) {
            ExpressionList el = (ExpressionList)es;
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            ExpressionSymbol[] symbols = el.getExpressions();
            int symbolsLength = symbols.length;
            for (int i = 0; i < symbolsLength; ++i) {
                Object o = this.processExpressionSymbol(symbols[i]);
                if (o == null) {
                    throw new Exception("Unable to evaluate arguments");
                }
                EvaluationInfo eval = this.convertToEvaluationInfo(o);
                this.evaluateArgValue(eval);
                sb.append(eval.getValue());
                if (i >= symbolsLength - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            return sb.toString();
        }
        throw new Exception("Unable to process expression symbol: arguments");
    }

    private Object performBuiltinPromotion(EvaluationInfo eval1, String classFrom, String classTo) throws Exception {
        if (this.classNamesMatch(classTo, BUILTIN_TYPE_BOOLEAN)) {
            boolean result = false;
            if (!this.classNamesMatch(classFrom, BUILTIN_TYPE_BOOLEAN) && !this.classNamesMatch(classFrom, BUILTIN_TYPE_UNKNOWN)) {
                throw new Exception("Unable to perform promotion from " + classFrom + " to " + BUILTIN_TYPE_BOOLEAN);
            }
            result = DebugSharedPrimitives.booleanDecode(eval1.getValue(true));
            return this.makeBooleanValue(result ? Boolean.TRUE : Boolean.FALSE);
        }
        if (this.classNamesMatch(classTo, BUILTIN_TYPE_STRING)) {
            String result = "";
            if (this.classNamesMatch(classFrom, BUILTIN_TYPE_STRING)) {
                result = eval1.getValue(true);
            } else if (this.classNamesMatch(classFrom, BUILTIN_TYPE_BOOLEAN) || this.classNamesMatch(classFrom, BUILTIN_TYPE_INT) || this.classNamesMatch(classFrom, BUILTIN_TYPE_DOUBLE) || this.classNamesMatch(classFrom, BUILTIN_TYPE_UNKNOWN)) {
                result = "'" + eval1.getValue(true) + "'";
            } else {
                throw new Exception("Unable to perform promotion from " + classFrom + " to " + BUILTIN_TYPE_STRING);
            }
            return new EvaluationInfo(result, this.findBuiltinStringClass());
        }
        if (this.classNamesMatch(classTo, BUILTIN_TYPE_INT)) {
            int result = 0;
            if (this.classNamesMatch(classFrom, BUILTIN_TYPE_INT) || this.classNamesMatch(classFrom, BUILTIN_TYPE_UNKNOWN)) {
                result = DebugSharedPrimitives.intDecode(eval1.getValue(true));
            } else if (this.classNamesMatch(classFrom, BUILTIN_TYPE_DOUBLE)) {
                double n1 = DebugSharedPrimitives.doubleDecode(eval1.getValue(true));
                result = (int)n1;
            } else {
                throw new Exception("Unable to perform promotion from " + classFrom + " to " + BUILTIN_TYPE_INT);
            }
            return new EvaluationInfo(result, this.findBuiltinIntClass());
        }
        if (this.classNamesMatch(classTo, BUILTIN_TYPE_DOUBLE)) {
            double result = 0.0;
            if (this.classNamesMatch(classFrom, BUILTIN_TYPE_INT)) {
                int n1 = Integer.decode(eval1.getValue(true));
                result = n1;
            } else if (this.classNamesMatch(classFrom, BUILTIN_TYPE_DOUBLE) || this.classNamesMatch(classFrom, BUILTIN_TYPE_UNKNOWN)) {
                result = DebugSharedPrimitives.doubleDecode(eval1.getValue(true));
            } else {
                throw new Exception("Unable to perform promotion from " + classFrom + " to " + BUILTIN_TYPE_DOUBLE);
            }
            return new EvaluationInfo(result, this.findBuiltinDoubleClass());
        }
        if (this.classNamesMatch(classTo, BUILTIN_TYPE_UNKNOWN)) {
            throw new Exception("Unable to perform promotion from " + classFrom + " to " + BUILTIN_TYPE_UNKNOWN);
        }
        throw new Exception("Unable to perform promotion from " + classFrom + " to " + classTo);
    }

    private EvaluationInfo convertToEvaluationInfo(Object o) throws Exception {
        DebugDataInfo data;
        if (o instanceof EvaluationInfo) {
            return (EvaluationInfo)o;
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.equalsIgnoreCase("NULL")) {
                return new EvaluationInfo("NULL", this.findBuiltinUnknownClass(), null);
            }
            Object data2 = this.evaluateSimple(s);
            if (data2 != null) {
                o = data2;
            }
            if (o instanceof EvaluationInfo) {
                return (EvaluationInfo)o;
            }
        }
        if ((data = PlsqlEvaluator.getDataInfo(o)) != null) {
            return new EvaluationInfo(data.getValue(), data.getClassInfo(), data);
        }
        throw new Exception("Unable to evaluate: " + o);
    }

    private String getBuiltinClass(String className) {
        if (className.equals(FANCY_BUILTIN_TYPE_INT)) {
            return BUILTIN_TYPE_INT;
        }
        if (className.equals(FANCY_BUILTIN_TYPE_DOUBLE)) {
            return BUILTIN_TYPE_DOUBLE;
        }
        if (className.equals(FANCY_BUILTIN_TYPE_BOOLEAN)) {
            return BUILTIN_TYPE_BOOLEAN;
        }
        if (className.equals("$Oracle.Builtin.VARCHAR2")) {
            return BUILTIN_TYPE_STRING;
        }
        String upper = className.toUpperCase();
        if (upper.equals("BINARY_INTEGER") || upper.equals("INT") || upper.equals("INTEGER") || upper.equals("NATURAL") || upper.equals("NATURALN") || upper.equals(BUILTIN_TYPE_INT) || upper.equals("POSITIVE") || upper.equals("POSITIVEN") || upper.equals("SIGNTYPE") || upper.equals("SMALLINT")) {
            return BUILTIN_TYPE_INT;
        }
        if (upper.equals("DEC") || upper.equals("DECIMAL") || upper.equals("DOUBLE PRECISION") || upper.equals("FLOAT") || upper.startsWith(BUILTIN_TYPE_DOUBLE) || upper.equals("NUMERIC") || upper.equals("REAL")) {
            return BUILTIN_TYPE_DOUBLE;
        }
        if (upper.equals(BUILTIN_TYPE_BOOLEAN)) {
            return BUILTIN_TYPE_BOOLEAN;
        }
        if (upper.startsWith("VARCHAR2") || upper.startsWith("CHAR") || upper.startsWith("LONG") || upper.startsWith("NCHAR") || upper.startsWith("NVARCHAR2") || upper.startsWith(BUILTIN_TYPE_STRING)) {
            return BUILTIN_TYPE_STRING;
        }
        if (upper.equals(BUILTIN_TYPE_UNKNOWN)) {
            return BUILTIN_TYPE_UNKNOWN;
        }
        return null;
    }

    private boolean classNamesMatch(String class1, String class2) {
        String builtin2;
        String builtin1 = this.getBuiltinClass(class1);
        if (builtin1 != null && (builtin2 = this.getBuiltinClass(class2)) != null) {
            return builtin1 == builtin2;
        }
        return false;
    }

    @Override
    protected DebugClassInfo findPrimitiveIntClass() {
        return this.findBuiltinIntClass();
    }

    private DebugClassInfo findBuiltinIntClass() {
        DebugClassInfo classInfo = this.findClass(BUILTIN_TYPE_INT);
        if (classInfo == null) {
            classInfo = this.findClass(FANCY_BUILTIN_TYPE_INT);
        }
        return classInfo;
    }

    private DebugClassInfo findBuiltinDoubleClass() {
        DebugClassInfo classInfo = this.findClass(BUILTIN_TYPE_DOUBLE);
        if (classInfo == null) {
            classInfo = this.findClass(FANCY_BUILTIN_TYPE_DOUBLE);
        }
        return classInfo;
    }

    private DebugClassInfo findBuiltinBooleanClass() {
        DebugClassInfo classInfo = this.findClass(BUILTIN_TYPE_BOOLEAN);
        if (classInfo == null) {
            classInfo = this.findClass(FANCY_BUILTIN_TYPE_BOOLEAN);
        }
        return classInfo;
    }

    private DebugClassInfo findBuiltinStringClass() {
        DebugClassInfo classInfo = this.findClass(BUILTIN_TYPE_STRING);
        if (classInfo == null) {
            classInfo = this.findClass("$Oracle.Builtin.VARCHAR2");
        }
        return classInfo;
    }

    private DebugClassInfo findBuiltinUnknownClass() {
        DebugClassInfo classInfo = this.findClass(BUILTIN_TYPE_UNKNOWN);
        if (classInfo == null) {
            classInfo = this.findClass("$Oracle.Builtin.VARCHAR2");
        }
        return classInfo;
    }
}

