/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import javax.swing.Icon;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.LocalsPanel;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;

final class LocalsWindow
extends DataWindow {
    static final String LOCALS_WINDOW_ID = "Debugger.LocalsWindow";
    private LocalsPanel localsPanel;
    private Boolean useFilters;

    LocalsWindow() {
        super(LOCALS_WINDOW_ID, DbgArb.getString(540), "f1_deb_datawindow_html");
    }

    @Override
    protected final DataPanel getDataPanel(boolean forceCreate) {
        if (this.localsPanel == null && forceCreate) {
            this.localsPanel = new LocalsPanel(this, LocalsWindowSettings.getInstance());
            if (this.useFilters != null) {
                this.localsPanel.setUseFilters(this.useFilters);
            }
        }
        return this.localsPanel;
    }

    @Override
    final void setUseFilters(boolean useFilters) {
        if (this.localsPanel != null) {
            this.localsPanel.setUseFilters(useFilters);
        } else {
            this.useFilters = useFilters;
        }
    }

    public Icon getTabIcon() {
        DataPanel panel = this.getDataPanel(true);
        DataController controller = panel.getController();
        DebuggerDataWindowOptions options = controller.getDebuggerWindowOptions();
        if (options != null) {
            return options.getTabIcon();
        }
        return OracleIcons.getIcon((String)"field.png");
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    public boolean installByDefault() {
        return true;
    }
}

