/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.InspectorWindowSettings;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public final class InspectorWindowSettingsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private DataPanelSettingsPanel dataPanel = new DataPanelSettingsPanel("Debugger.InspectorWindow");
    private JLabel spacerLabel = new JLabel();
    private JComboBox vmChooser;
    private JLabel vmChooserLabel;
    private MultiLineLabel disclaimerLabel;
    private transient InspectorWindowSettings settings;
    private JPanel spacer;
    private JPanel optionPanel;

    public InspectorWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_inspectorwinsetpanel_html");
        this.setLayout(new GridBagLayout());
        this.spacerLabel.setEnabled(false);
        this.spacer = new JPanel();
        this.optionPanel = new JPanel(new GridBagLayout());
        this.disclaimerLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), DbgArb.format(861, DbgArb.getString(558)));
        this.vmChooser = new JComboBox();
        this.vmChooserLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.vmChooserLabel, (Component)this.vmChooser, (String)DbgArb.getString(860));
    }

    private InspectorWindowSettings getData(TraversableContext tc) {
        return InspectorWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.settings = this.getData(tc);
        DataPanelSettings dpSettings = this.settings.getDataPanelSettings();
        HashStructure hash = dpSettings.getHash();
        this.removeAll();
        this.add((Component)this.disclaimerLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 16, 0), 0, 0));
        this.dataPanel.onEntry(this.settings.getDataPanelSettings());
        this.vmChooser.removeAllItems();
        int y = 1;
        List<String> vmNames = WindowSettingsColumnManager.getVMNames(hash);
        if (vmNames.size() > 0) {
            for (String vmName : vmNames) {
                this.vmChooser.addItem(vmName);
                boolean[] visibilities = new boolean[8];
                for (int j = 0; j < 8; ++j) {
                    visibilities[j] = WindowSettingsColumnManager.getColumnVisible(hash, vmName, j);
                }
            }
            this.vmChooser.setEditable(false);
            if (vmNames.size() > 1) {
                this.add(this.vmChooserLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 8, 8), 0, 0));
                this.add(this.vmChooser, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
            }
            this.add(this.optionPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            constraints.gridy = y;
            constraints.insets.top = 8;
            this.add(this.dataPanel.makeShowPanel(null), constraints);
            ++constraints.gridy;
            this.add(this.dataPanel.makeViewSelectPanel(), constraints);
            ++constraints.gridy;
            constraints.weighty = 1.0;
            this.add(this.spacerLabel, constraints);
            this.vmChooser.addActionListener(this);
            this.vmChooser.setSelectedIndex(0);
        } else {
            this.add(this.spacer, new GridBagConstraints(0, y, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        InspectorWindowSettings settings = this.getData(tc);
        this.dataPanel.onExit(settings.getDataPanelSettings());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.vmChooser && this.vmChooser.getSelectedIndex() != -1) {
            String newVM = this.vmChooser.getSelectedItem().toString();
            String window = DbgArb.getString(558);
            String title = DbgArb.format(862, window, newVM);
            TitledBorder border = BorderFactory.createTitledBorder(title);
            this.optionPanel.setBorder(border);
            this.optionPanel.removeAll();
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            this.optionPanel.add((Component)this.dataPanel.makeChooseColumnsPanel(this.settings.getDataPanelSettings(), newVM, null), constraints);
            this.optionPanel.revalidate();
        }
    }
}

