/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Version;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public final class HeapWindowSettingsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private DataPanelSettingsPanel dataPanel = new DataPanelSettingsPanel("Debugger.HeapWindow");
    private JCheckBox showUnrelatedCheckBox = new JCheckBox();
    private JCheckBox ignoreSoftWeakCheckBox = new JCheckBox();
    private JCheckBox rootsOnlyCheckBox = new JCheckBox();
    private JLabel maximumDepthLabel = new JLabel();
    private NumericSpinBox maximumDepthBox = new NumericSpinBox(-1, 1000);
    private JLabel spacerLabel = new JLabel();
    private JComboBox vmChooser;
    private JLabel vmChooserLabel;
    private MultiLineLabel disclaimerLabel;
    private transient HeapWindowSettings settings;
    private JPanel optionPanel;
    private JPanel spacer;

    public HeapWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_heapwinsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.showUnrelatedCheckBox, (String)DbgArb.getString(718));
        ResourceUtils.resButton((AbstractButton)this.ignoreSoftWeakCheckBox, (String)DbgArb.getString(719));
        ResourceUtils.resButton((AbstractButton)this.rootsOnlyCheckBox, (String)DbgArb.getString(720));
        ResourceUtils.resLabel((JLabel)this.maximumDepthLabel, (Component)this.maximumDepthBox, (String)DbgArb.getString(721));
        SpinBuddy buddy = this.maximumDepthBox.getSpinBuddy();
        if (buddy instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        this.spacerLabel.setEnabled(false);
        this.spacer = new JPanel();
        this.optionPanel = new JPanel(new GridBagLayout());
        this.disclaimerLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), DbgArb.format(861, DbgArb.getString(565)));
        this.vmChooser = new JComboBox();
        this.vmChooserLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.vmChooserLabel, (Component)this.vmChooser, (String)DbgArb.getString(860));
    }

    private JPanel makeExtraPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        int y = 0;
        panel.add((Component)this.ignoreSoftWeakCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        if (Version.DEBUG_BUILD != 0) {
            panel.add((Component)this.rootsOnlyCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
            panel.add((Component)this.maximumDepthLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 0), 0, 0));
            panel.add((Component)this.maximumDepthBox, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        }
        return panel;
    }

    private HeapWindowSettings getData(TraversableContext tc) {
        return HeapWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.settings = this.getData(tc);
        DataPanelSettings dpSettings = this.settings.getDataPanelSettings();
        HashStructure hash = dpSettings.getHash();
        this.removeAll();
        this.add((Component)this.disclaimerLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 16, 0), 0, 0));
        this.dataPanel.onEntry(dpSettings);
        this.vmChooser.removeAllItems();
        int y = 1;
        List<String> vmNames = WindowSettingsColumnManager.getVMNames(hash);
        if (vmNames.size() > 0) {
            for (String vmName : vmNames) {
                this.vmChooser.addItem(vmName);
                boolean[] visibilities = new boolean[8];
                for (int j = 0; j < 8; ++j) {
                    visibilities[j] = WindowSettingsColumnManager.getColumnVisible(hash, vmName, j);
                }
            }
            this.vmChooser.setEditable(false);
            if (vmNames.size() > 1) {
                this.add(this.vmChooserLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 8, 8), 0, 0));
                this.add(this.vmChooser, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
            }
            this.add(this.optionPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            ++constraints.gridy;
            constraints.insets.top = 8;
            ArrayList<JCheckBox> addedFields = new ArrayList<JCheckBox>();
            addedFields.add(this.showUnrelatedCheckBox);
            this.add(this.dataPanel.makeShowPanel(addedFields), constraints);
            ++constraints.gridy;
            this.add(this.dataPanel.makeViewSelectPanel(), constraints);
            ++constraints.gridy;
            Insets borderInsets = new Insets(0, 0, 0, 0);
            this.add(this.makeExtraPanel(borderInsets), constraints);
            ++constraints.gridy;
            constraints.weighty = 1.0;
            this.add(this.spacerLabel, constraints);
            this.vmChooser.addActionListener(this);
            this.vmChooser.setSelectedIndex(0);
        } else {
            this.add(this.spacer, new GridBagConstraints(0, y, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.showUnrelatedCheckBox.setSelected(!dpSettings.isHideUnrelated());
        this.ignoreSoftWeakCheckBox.setSelected(this.settings.isIgnoreSoftWeak());
        if (Version.DEBUG_BUILD != 0) {
            this.rootsOnlyCheckBox.setSelected(dpSettings.isShowOnlyRootAncestors());
            this.maximumDepthBox.setIntValue(this.settings.getMaximumDepth());
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        HeapWindowSettings settings = this.getData(tc);
        DataPanelSettings dataPanelSettings = settings.getDataPanelSettings();
        this.dataPanel.onExit(dataPanelSettings);
        dataPanelSettings.setHideUnrelated(!this.showUnrelatedCheckBox.isSelected());
        settings.setIgnoreSoftWeak(this.ignoreSoftWeakCheckBox.isSelected());
        if (Version.DEBUG_BUILD != 0) {
            dataPanelSettings.setShowOnlyRootAncestors(this.rootsOnlyCheckBox.isSelected());
            settings.setMaximumDepth(this.maximumDepthBox.getIntValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.vmChooser && this.vmChooser.getSelectedIndex() != -1) {
            String newVM = this.vmChooser.getSelectedItem().toString();
            String window = DbgArb.getString(565);
            String title = DbgArb.format(862, window, newVM);
            TitledBorder border = BorderFactory.createTitledBorder(title);
            this.optionPanel.setBorder(border);
            this.optionPanel.removeAll();
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            Insets borderInsets = new Insets(0, 0, 0, 0);
            this.optionPanel.add((Component)this.dataPanel.makeChooseColumnsPanel(this.settings.getDataPanelSettings(), newVM, borderInsets), constraints);
            this.optionPanel.add((Component)this.dataPanel.makeSortPanel(newVM, null), new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.optionPanel.revalidate();
        }
    }
}

