/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointDeclarator;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtenderCallback;
import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.debugger.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.CustomDataProvider;
import oracle.jdevimpl.runner.debug.ExtenderBreakpoint;
import oracle.jdevimpl.runner.debug.ExtenderManager;
import oracle.jdevimpl.runner.debug.JDebugger;

class ExtenderCallback
implements DebuggerExtenderCallback {
    private DebuggerExtender extender;
    private String extenderID;
    private List<ExtenderBreakpoint> extenderBreakpoints;
    private CustomDataProvider customDataProvider;
    private Map<String, DebuggerBreakpointDeclarator> customBreakpointTypes = new HashMap<String, DebuggerBreakpointDeclarator>();

    ExtenderCallback(DebuggerExtender extender, String extenderID) {
        this.extender = extender;
        this.extenderID = extenderID;
    }

    DebuggerExtender getExtender() {
        return this.extender;
    }

    String getExtenderId() {
        return this.extenderID;
    }

    public DebuggerBreakpoint addBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        final Breakpoint bp = ExtenderManager.createBreakpoint(breakpoint, null, this.extenderID);
        ExtenderBreakpoint extenderBreakpoint = new ExtenderBreakpoint(bp);
        this.addExtenderBreakpoint(extenderBreakpoint);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDebugger.getInstance().addBreakpoint(bp);
            }
        });
        return extenderBreakpoint;
    }

    public boolean deleteBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            this.deleteExtenderBreakpoint(extenderBreakpoint);
            JDebugger.getInstance().deleteBreakpoint(extenderBreakpoint.getBreakpoint());
            return true;
        }
        return false;
    }

    synchronized void deleteExtenderBreakpoint(ExtenderBreakpoint breakpoint) {
        this.getExtenderBreakpoints();
        this.extenderBreakpoints.remove(breakpoint);
    }

    synchronized void addExtenderBreakpoint(ExtenderBreakpoint breakpoint) {
        this.getExtenderBreakpoints();
        this.extenderBreakpoints.add(breakpoint);
    }

    public boolean setEnableBreakpoint(DebuggerBreakpoint breakpoint, boolean enable) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            extenderBreakpoint.enableBreakpoint(enable);
            return true;
        }
        return false;
    }

    public DebuggerBreakpoint.BreakpointState getBreakpointState(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            return extenderBreakpoint.getActiveState();
        }
        return null;
    }

    public Icon getBreakpointIcon(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            return extenderBreakpoint.getIcon();
        }
        return null;
    }

    public synchronized List<? extends DebuggerBreakpoint> getBreakpoints() {
        if (Breakpoint.breakpointsLoaded()) {
            List<ExtenderBreakpoint> currentBreakpoints = this.getExtenderBreakpoints();
            ArrayList<ExtenderBreakpoint> copy = new ArrayList<ExtenderBreakpoint>(currentBreakpoints.size());
            for (ExtenderBreakpoint extenderBreakpoint : currentBreakpoints) {
                copy.add(extenderBreakpoint);
            }
            return copy;
        }
        return null;
    }

    synchronized List<ExtenderBreakpoint> getExtenderBreakpoints() {
        if (this.extenderBreakpoints == null) {
            List breakpoints = Breakpoint.getExtenderBreakpoints((String)this.extenderID);
            this.extenderBreakpoints = new ArrayList<ExtenderBreakpoint>();
            for (Breakpoint breakpoint : breakpoints) {
                ExtenderBreakpoint extenderBp = new ExtenderBreakpoint(breakpoint);
                this.extenderBreakpoints.add(extenderBp);
            }
        }
        return this.extenderBreakpoints;
    }

    synchronized ExtenderBreakpoint getExtenderBreakpoint(Breakpoint breakpoint) {
        List<ExtenderBreakpoint> extenderBreakpoints = this.getExtenderBreakpoints();
        for (ExtenderBreakpoint extenderBreakpoint : extenderBreakpoints) {
            if (extenderBreakpoint.getBreakpoint() != breakpoint) continue;
            return extenderBreakpoint;
        }
        return null;
    }

    CustomDataProvider getCustomDataProvider() {
        if (this.customDataProvider == null) {
            this.customDataProvider = new CustomDataProvider();
        }
        return this.customDataProvider;
    }

    private ExtenderBreakpoint recognizeBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint instanceof ExtenderBreakpoint) {
            return (ExtenderBreakpoint)breakpoint;
        }
        List<? extends DebuggerBreakpoint> extenderBreakpoints = this.getBreakpoints();
        if (extenderBreakpoints != null) {
            for (DebuggerBreakpoint debuggerBreakpoint : extenderBreakpoints) {
                if (!this.extender.breakpointsEqual(debuggerBreakpoint, breakpoint)) continue;
                return (ExtenderBreakpoint)debuggerBreakpoint;
            }
        }
        return null;
    }

    @Deprecated
    public void registerCustomBreakpointType(String customBreakpointType, DebuggerBreakpoint.BreakpointKind breakpointKind) {
        this.registerCustomBreakpointType(customBreakpointType, breakpointKind, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCustomBreakpointType(String customBreakpointType, DebuggerBreakpoint.BreakpointKind breakpointKind, DebuggerBreakpoint breakpointTemplate) {
        if (customBreakpointType == null || customBreakpointType.trim().length() == 0) {
            throw new IllegalArgumentException("Need valid custom breakpoint type");
        }
        Map<String, DebuggerBreakpointDeclarator> map = this.customBreakpointTypes;
        synchronized (map) {
            CustomBreakpointDetails details = new CustomBreakpointDetails(this.getExtender().getID(), customBreakpointType, breakpointKind, breakpointTemplate);
            this.customBreakpointTypes.put(customBreakpointType, details);
        }
    }

    public DebuggerBreakpoint.BreakpointScope getDefaultBreakpointScope() {
        String defaultScope = BreakpointsWindowSettings.getInstance().getBreakpointScope();
        if (defaultScope.equals("workspace")) {
            return DebuggerBreakpoint.BreakpointScope.WORKSPACE;
        }
        if (defaultScope.equals("project")) {
            return DebuggerBreakpoint.BreakpointScope.PROJECT;
        }
        if (defaultScope.equals("global")) {
            return DebuggerBreakpoint.BreakpointScope.GLOBAL;
        }
        return DebuggerBreakpoint.BreakpointScope.WORKSPACE;
    }

    public boolean editBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            return JDebugger.getInstance().editBreakpoint(extenderBreakpoint.getBreakpoint());
        }
        return false;
    }

    public DebuggerBreakpoint getDefaultBreakpointSettings() {
        return new ExtenderBreakpoint(new Breakpoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean knowsCustomBreakpointType(String customBreakpointType) {
        Map<String, DebuggerBreakpointDeclarator> map = this.customBreakpointTypes;
        synchronized (map) {
            return this.customBreakpointTypes.get(customBreakpointType) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebuggerBreakpointDeclarator getCustomBreakpointDeclarator(String breakpointTypeString) {
        Map<String, DebuggerBreakpointDeclarator> map = this.customBreakpointTypes;
        synchronized (map) {
            return this.customBreakpointTypes.get(breakpointTypeString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> getCustomBreakpointTypes() {
        Map<String, DebuggerBreakpointDeclarator> map = this.customBreakpointTypes;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.customBreakpointTypes.keySet());
        }
    }

    private static class CustomBreakpointDetails
    implements DebuggerBreakpointDeclarator {
        private String customBreakpointType;
        private DebuggerBreakpoint.BreakpointKind kind;
        private DebuggerBreakpoint breakpointTemplate;
        private String debuggerExtenderId;

        CustomBreakpointDetails(String debuggerExtenderId, String customBreakpointType, DebuggerBreakpoint.BreakpointKind kind, DebuggerBreakpoint breakpointTemplate) {
            this.debuggerExtenderId = debuggerExtenderId;
            this.customBreakpointType = customBreakpointType;
            this.kind = kind;
            this.breakpointTemplate = breakpointTemplate;
        }

        public String getDebuggerExtenderId() {
            return this.debuggerExtenderId;
        }

        public DebuggerBreakpoint.BreakpointKind getBreakpointKind() {
            return this.kind;
        }

        public DebuggerBreakpoint getBreakpointTemplate() {
            return this.breakpointTemplate;
        }

        public String getBreakpointTypeString() {
            return this.customBreakpointType;
        }
    }
}

