/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerEventSource;
import oracle.ideimpl.runner.ExecutionEvent;
import oracle.ideimpl.runner.ExecutionEventType;
import oracle.ideimpl.runner.ExecutionListener;
import oracle.ideimpl.runner.ExecutionTrackerForDebuggingProcess;
import oracle.ideimpl.runner.ExecutionTrackingInfo;
import oracle.ideimpl.runner.ExecutionTrackingTrigger;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.CustomDataProvider;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorHandle;
import oracle.jdevimpl.runner.debug.ExecutionTrackerForVirtualMachine;
import oracle.jdevimpl.runner.debug.ExecutionTrackerImplForVirtualMachine;
import oracle.jdevimpl.runner.debug.VMExecutionEvent;
import oracle.jdevimpl.runner.debug.VMExecutionListener;

final class ExecutionTrackerImplForDebuggingProcess
implements ExecutionTrackerForDebuggingProcess,
VMExecutionListener {
    private ExecutionTrackerForVirtualMachine et4vm;
    private DebuggingProcess debuggingProcess;
    private DebuggerEventSource eventSource;
    private List<ExecutionListener> listeners = new ArrayList<ExecutionListener>();
    private boolean isBackgroundSteppingActive = false;
    private CustomDataProvider customDataProvider = new CustomDataProvider();

    ExecutionTrackerImplForDebuggingProcess(DebuggingProcess debuggingProcess, DebuggerEventSource eventSource, DebugVirtualMachine vm) {
        this.debuggingProcess = debuggingProcess;
        this.eventSource = eventSource;
        this.et4vm = new ExecutionTrackerImplForVirtualMachine(vm);
        this.et4vm.addVMExecutionListener(this);
        this.listeners = debuggingProcess.getExecutionListeners();
    }

    public void startBackgroundStepping() {
        this.et4vm.startBackgroundStepping();
    }

    public void stopBackgroundStepping() {
        this.et4vm.stopBackgroundStepping();
    }

    public boolean isBackgroundStepping() {
        return this.isBackgroundSteppingActive;
    }

    @Override
    public void vmExecutionEvent(VMExecutionEvent evt) {
        ExecutionTrackingInfo info = evt.getTrackingInfo();
        ExecutionEventType eeType = evt.getExecutionEventType();
        ExecutionEvent forwardedEvent = new ExecutionEvent((ExecutionTrackerForDebuggingProcess)this, info, this.eventSource, eeType);
        switch (eeType) {
            case DEBUGGER_STARTING: 
            case DEBUGGER_FINISHED: 
            case DEBUGGER_STOPPING: 
            case DEBUGGER_RESUMING: 
            case CLASS_REDEFINED: {
                break;
            }
            case BACKGROUND_STEPPING_STARTED: {
                this.isBackgroundSteppingActive = true;
                break;
            }
            case BACKGROUND_STEPPING_STOPPED: 
            case BACKGROUND_STEP_REACHED_BACKSTOP: {
                this.isBackgroundSteppingActive = false;
            }
        }
        this.sendEventToDebuggingProcess(forwardedEvent);
    }

    private void sendEventToDebuggingProcess(ExecutionEvent evt) {
        for (ExecutionListener listener : this.listeners) {
            listener.executionEvent(evt);
        }
    }

    public void addTrigger(ExecutionTrackingTrigger trigger) {
        this.et4vm.addTrigger(trigger);
    }

    public void removeTrigger(ExecutionTrackingTrigger trigger) {
        this.et4vm.removeTrigger(trigger);
    }

    public DebuggerEvaluator getEvaluator() {
        Evaluator evaluator = new Evaluator(true);
        DebugVirtualMachine vm = this.debuggingProcess.getVM();
        DebugThreadInfo thread = this.debuggingProcess.getCurrentThread();
        DebugStackFrameInfo frame = this.debuggingProcess.getCurrentStackFrame();
        evaluator.setDebugContext(vm, thread, frame);
        EvaluatorHandle handle = new EvaluatorHandle(evaluator, this.debuggingProcess, this.customDataProvider);
        return handle;
    }
}

