/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.macros.MacroUtils;
import oracle.ideimpl.macros.ui.MacroDialogOptions;
import oracle.ideimpl.macros.ui.MacroSelectionDialog;
import oracle.ideimpl.macros.ui.MacroURLShortcutProvider;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.RunMgrArb;

public class DefaultRunnablePanel
extends JPanel {
    private final URLTextField targetTextField;
    private final JCheckBox runActiveFileCheckBox;
    private Context context;
    private URL urlSourcePath;
    private String pathMacroSelection;
    private JEWTDialog dlg;

    public DefaultRunnablePanel() {
        this(true, RunMgrArb.getString(22));
    }

    public DefaultRunnablePanel(boolean displayActiveFileCheckbox, String defaultTargetPrompt) {
        JLabel textFieldLabel = new JLabel();
        this.targetTextField = new URLTextField(null, false, true);
        JButton browseButton = new JButton();
        JButton macroButton = new JButton();
        this.runActiveFileCheckBox = new JCheckBox();
        ResourceUtils.resLabel((JLabel)textFieldLabel, (Component)this.targetTextField, (String)defaultTargetPrompt);
        ResourceUtils.resButton((AbstractButton)browseButton, (String)RunMgrArb.getString(23));
        ResourceUtils.resButton((AbstractButton)macroButton, (String)RunMgrArb.getString(104));
        this.targetTextField.setDialogTitle(RunMgrArb.getString(20));
        this.targetTextField.setChooserInit(new URLChooserInit(){

            public void initURLChooser(URLChooser urlChooser) {
                if (DefaultRunnablePanel.this.pathMacroSelection != null) {
                    DefaultRunnablePanel.this.urlSourcePath = MacroUtils.getValueAsURL((Context)DefaultRunnablePanel.this.context, (String)DefaultRunnablePanel.this.pathMacroSelection);
                    MacroUtils.URLWrapper wrappedURL = new MacroUtils.URLWrapper(DefaultRunnablePanel.this.urlSourcePath);
                    if (DefaultRunnablePanel.this.context != null) {
                        DefaultRunnablePanel.this.context.setSelection(new Element[]{wrappedURL});
                    }
                    MacroURLShortcutProvider scProvider = new MacroURLShortcutProvider(DefaultRunnablePanel.this.pathMacroSelection, DefaultRunnablePanel.this.urlSourcePath);
                    DialogUtil.replaceURLChooserShortcutProviderOfSameClass((URLChooserShortcutProvider)scProvider);
                }
                if (DefaultRunnablePanel.this.context != null) {
                    DialogUtil.addShortcutButtons((URLChooser)urlChooser, (Context)DefaultRunnablePanel.this.context);
                }
                if (DefaultRunnablePanel.this.urlSourcePath != null && DefaultRunnablePanel.this.targetTextField.getURL() == null) {
                    urlChooser.setSelectedURL(DefaultRunnablePanel.this.urlSourcePath);
                }
            }
        });
        browseButton.addActionListener((ActionListener)this.targetTextField);
        macroButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroDialogOptions options = new MacroDialogOptions();
                options.setDialogTitle(RunMgrArb.getString(107));
                options.setEnableFiltering(true);
                options.setRestrictToLocationMacros(true);
                if (MacroSelectionDialog.showDialog((MacroDialogOptions)options, (Context)DefaultRunnablePanel.this.context)) {
                    DefaultRunnablePanel.this.pathMacroSelection = MacroSelectionDialog.getSelection();
                    if (DefaultRunnablePanel.this.pathMacroSelection != null) {
                        DefaultRunnablePanel.this.targetTextField.setText(DefaultRunnablePanel.this.pathMacroSelection);
                        DefaultRunnablePanel.this.targetTextField.setActiveMacro(DefaultRunnablePanel.this.pathMacroSelection, MacroUtils.getValue((Context)DefaultRunnablePanel.this.context, (String)DefaultRunnablePanel.this.pathMacroSelection));
                    }
                }
            }
        });
        ResourceUtils.resButton((AbstractButton)this.runActiveFileCheckBox, (String)RunMgrArb.getString(24));
        this.targetTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DefaultRunnablePanel.this.enableOk();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DefaultRunnablePanel.this.enableOk();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DefaultRunnablePanel.this.enableOk();
            }
        });
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add((Component)textFieldLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.targetTextField, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)macroButton, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)browseButton, new GridBagConstraints(2, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        if (displayActiveFileCheckbox) {
            this.add((Component)this.runActiveFileCheckBox, new GridBagConstraints(0, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        }
    }

    public Component getInitialFocus() {
        return this.targetTextField;
    }

    private URL _getURL(boolean expandMacros) {
        String text = this.targetTextField.getText();
        if (text.trim().length() == 0) {
            return null;
        }
        URL url = null;
        url = expandMacros ? MacroUtils.expandAndMakeURL((Context)this.context, (String)text) : this.targetTextField.getURL(false);
        if (url == null) {
            if (!text.startsWith("${")) {
                url = URLFactory.newDirURL((String)this.context.getProject().getBaseDirectory());
                url = URLFactory.newURL((URL)url, (String)text);
            } else {
                url = URLFactory.newDirURL((String)".");
                url = URLFactory.replacePathPart((URL)url, (String)text);
            }
            URLFileSystem.canonicalize((URL)url);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateDefaultRunTarget(JRunProcess jrunProcess) {
        URL url;
        if (jrunProcess != null && (url = this._getURL(true)) != null) {
            boolean failure = false;
            Node node = null;
            ArrayList<String> errors = new ArrayList<String>();
            WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            try {
                node = DefaultRunnablePanel.getNode(url);
                if (node != null) {
                    Project project = this.context != null ? this.context.getProject() : null;
                    String starterFactoryName = jrunProcess.canGetStarterForTarget(project, node, null, errors);
                    if (starterFactoryName == null) {
                        failure = true;
                    }
                } else {
                    errors.add(RunMgrArb.format(52, URLFileSystem.getFileName((URL)url)));
                    failure = true;
                }
            }
            finally {
                wc.hide();
            }
            if (failure) {
                String s;
                if (node != null) {
                    s = node.getShortLabel();
                } else if (URLFileSystem.isDirectoryPath((URL)url)) {
                    s = URLFileSystem.getPlatformPathName((URL)url);
                } else {
                    String fn = URLFileSystem.getFileName((URL)url);
                    String ffn = URLFileSystem.getPlatformPathName((URL)url);
                    s = RunMgrArb.format(82, fn, ffn);
                }
                errors.add(0, RunMgrArb.format(26, s));
                errors.add(1, "");
                errors.add("");
                errors.add(RunMgrArb.format(27, s));
                StringBuffer msg = new StringBuffer();
                for (int i = 0; i < errors.size(); ++i) {
                    msg.append(errors.get(i));
                    if (i >= errors.size() - 1) continue;
                    msg.append("\n");
                }
                return MessageDialog.optionalConfirm((String)"jdeveloper.runner.defaultRunnableMessage", (Component)this, (Object)msg.toString(), (String)RunMgrArb.getString(25), null);
            }
        }
        return true;
    }

    private void enableOk() {
        if (this.dlg != null) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }
    }

    public void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
    }

    public boolean canOk() {
        return this.targetTextField.getURL() != null;
    }

    public void loadFrom(RunConfiguration runConfiguration, Object sourceForTargets) {
        String macroInURL;
        URL url = runConfiguration.getTargetURL(false);
        this.targetTextField.setURL(url);
        String string = macroInURL = url == null ? null : MacroUtils.getFirstMacroInExpression((String)url.toExternalForm());
        if (macroInURL != null) {
            this.pathMacroSelection = macroInURL;
            this.targetTextField.setActiveMacro(this.pathMacroSelection, MacroUtils.getValue((Context)this.context, (String)this.pathMacroSelection));
        }
        this.runActiveFileCheckBox.setSelected(runConfiguration.isRunActiveFile());
        this.context = null;
        this.urlSourcePath = null;
        if (sourceForTargets instanceof Project) {
            Project project = (Project)sourceForTargets;
            this.context = Context.newIdeContext((Node)project);
            this.context.setWorkspace(Ide.getActiveWorkspace());
            this.urlSourcePath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath().getFirstEntry();
        }
    }

    public void commitTo(RunConfiguration runConfiguration) {
        URL url = this._getURL(false);
        runConfiguration.setTargetURL(url);
        runConfiguration.setRunActiveFile(this.runActiveFileCheckBox.isSelected());
    }

    static Node getNode(URL url) {
        try {
            Node node = NodeFactory.find((URL)url);
            if (node == null && URLFileSystem.exists((URL)url)) {
                node = NodeFactory.findOrCreate((URL)url);
            }
            return node;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

