/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import java.util.Map;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.MethodVisitationInfoRetrievalKey;
import oracle.jdevimpl.debugger.support.TargetMethod;

public interface DebugThreadInfo {
    public static final int STATUS_Unknown = 0;
    public static final int STATUS_NotStarted = 1;
    public static final int STATUS_Blocked = 2;
    public static final int STATUS_Waiting = 3;
    public static final int STATUS_Sleeping = 4;
    public static final int STATUS_Runnable = 5;
    public static final int STATUS_Completed = 6;

    public boolean hasExited();

    public long getThreadId();

    public String getName();

    public String getGroupName();

    public DebugThreadGroupInfo getThreadGroup();

    public int getStatus();

    public boolean isThreadSuspended();

    public void suspendThread();

    public void resumeThread();

    public void interruptThread();

    public void stopThread();

    public DebugDataObjectInfo getThreadObject();

    public void stepInto();

    public void stepOver();

    public void stepIntoBC();

    public void stepOverBC();

    public void stepOut();

    public boolean isAtEndOfMethod();

    public void stepToEndOfMethod();

    public void stepIntoMethod(String var1, String var2, String var3, int var4);

    public void stepIntoMethod(String var1, String var2, String var3, int var4, int var5);

    public MethodVisitationInfoRetrievalKey stepIntoMethod(TargetMethod var1, Map<TargetMethod, TargetMethod.VisitationTrackingInfo> var2);

    public Map<TargetMethod, TargetMethod.VisitationTrackingInfo> getMethodVisitationInfo(MethodVisitationInfoRetrievalKey var1);

    public void clearMethodVisitationInfo(MethodVisitationInfoRetrievalKey var1);

    public int getStackFrameCount();

    public DebugStackFrameInfo getStackFrame(int var1);

    public DebugStackFrameInfo[] listStack();

    public DebugMonitorInfo[] listOwnedMonitors();

    public DebugMonitorInfo getMonitorThreadWaitingFor();

    public DebugMonitorInfo getMonitorThreadBlockedFor();

    public DebugRegisterInfo[] listRegisters();

    public DebugRegisterInfo[] listFloatRegisters();

    public DebugVariableInfo getReturnValue();

    public DebugVariableInfo getReturnedValue();

    public boolean setLocation(DebugLocation var1);

    public DebugDataObjectInfo getContextClassLoaderObject();

    public DebugClassLoaderInfo getContextClassLoader();

    public boolean isThreadInterrupted();

    public boolean isThreadDebuggerStopped();

    public boolean canDebuggerStopThread();
}

