/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public class DebugLocationUtils {
    private DebugLocationUtils() {
    }

    public static int getFirstLineOfStatementEncompassingLocation(DebugLocation currentLocation) {
        int currentLine = currentLocation.getLine();
        return DebugLocationUtils.getFirstLineOfStatementEncompassingLocation(currentLocation, currentLine);
    }

    public static int getFirstLineOfStatementEncompassingLocation(DebugLocation currentLocation, int line) {
        int lineMin = line;
        DebugMethodInfo method = currentLocation.getMethod();
        int[] executableLines = method.getMethodLines();
        int len = executableLines.length - 1;
        if (executableLines.length > 0 && executableLines[0] <= line && executableLines[len] >= line) {
            for (int x = len; x >= 0; --x) {
                if (line < executableLines[x]) continue;
                lineMin = executableLines[x];
                break;
            }
        }
        return lineMin;
    }

    public static int getLastLineOfStatementEncompassingLocation(DebugLocation location) {
        int line = location.getLine();
        return DebugLocationUtils.getLastLineOfStatementEncompassingLocation(location, line);
    }

    public static int getLastLineOfStatementEncompassingLocation(DebugLocation location, int line) {
        DebugMethodInfo method = location.getMethod();
        int[] executableLines = method.getMethodLines();
        int len = executableLines.length - 1;
        if (executableLines.length > 0 && executableLines[0] <= line && executableLines[len] >= line) {
            boolean foundCaretLine = false;
            for (int i = 0; i <= len; ++i) {
                if (!foundCaretLine) {
                    if (executableLines[i] < line) continue;
                    foundCaretLine = true;
                    continue;
                }
                if (executableLines[i] > line) continue;
                return executableLines[i - 1];
            }
        }
        return line;
    }
}

