/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;

public final class DebugHeapSubsetAncestors
extends DebugHeapSubset {
    public static final int IgnoreNone = 0;
    public static final int IgnorePhantom = 1;
    public static final int IgnoreFinalPhantom = 2;
    public static final int IgnoreWeakFinalPhantom = 3;
    public static final int IgnoreSoftWeakFinalPhantom = 4;
    private long address;
    private int depth;
    private int ignoreLevel;

    public DebugHeapSubsetAncestors(long address, boolean directAncestorsOnly, int ignoreLevel, DebugClassInfo classInfo) {
        this(null, address, directAncestorsOnly ? 1 : -1, ignoreLevel, classInfo);
    }

    public DebugHeapSubsetAncestors(String name, long address, boolean directAncestorsOnly, int ignoreLevel, DebugClassInfo classInfo) {
        this(name, address, directAncestorsOnly ? 1 : -1, ignoreLevel, classInfo);
    }

    public DebugHeapSubsetAncestors(String name, long address, int depth, int ignoreLevel, DebugClassInfo classInfo) {
        super(name, classInfo);
        this.address = address;
        this.depth = depth;
        this.ignoreLevel = ignoreLevel;
    }

    public long getAddress() {
        return this.address;
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public boolean getDirectAncestorsOnly() {
        return this.depth == 1;
    }

    public void setDirectAncestorsOnly(boolean directAncestorsOnly) {
        this.depth = directAncestorsOnly ? 1 : -1;
    }

    public int getIgnoreLevel() {
        return this.ignoreLevel;
    }

    public void setIgnoreLevel(int ignoreLevel) {
        this.ignoreLevel = ignoreLevel;
    }
}

