/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.insight;

import java.awt.Color;
import java.awt.Component;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.accessibility.AccessibleContext;
import javax.swing.JList;
import oracle.ide.config.Preferences;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.completion.ui.InsightCellRenderer;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.debugger.insight.JavaInsightOptions;

public class JavaCellRenderer
extends InsightCellRenderer<InsightItem> {
    private final boolean strikeThruDeprecated;
    private final boolean boldClassMembers;

    public JavaCellRenderer(InsightViewCustomizer customizer) {
        super(customizer);
        JavaInsightOptions options = JavaInsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        this.strikeThruDeprecated = options.getStrikethruDeprecated();
        this.boldClassMembers = options.getBoldDeclaredMembers();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean hasDescription;
        InsightItem item = (InsightItem)value;
        this.setIconTextGap(4);
        AccessibleContext ac = this.getAccessibleContext();
        if (ac != null) {
            ac.setAccessibleName(item.getAccessibleText());
        }
        this.setIcon(item.getIcon());
        AttributedString aText = new AttributedString(item.getName());
        AttributedString description = new AttributedString("");
        boolean hasText = aText.getIterator().getEndIndex() > 0;
        boolean bl = hasDescription = description.getIterator().getEndIndex() > 0;
        if (hasText) {
            aText.addAttribute(TextAttribute.FAMILY, list.getFont().getFamily());
        }
        if (hasDescription) {
            description.addAttribute(TextAttribute.FAMILY, list.getFont().getFamily());
        }
        if (item.getGroup() == 20) {
            Color fg = new Color(70, 70, 70);
            if (hasText) {
                aText.addAttribute(TextAttribute.FOREGROUND, fg);
            }
            if (hasDescription) {
                description.addAttribute(TextAttribute.FOREGROUND, fg);
            }
            this.setBackground(new Color(220, 220, 220));
        }
        this.setAttributedText(aText);
        this.setDescription(description);
        return super.getListCellRendererComponent(list, (Object)item, index, isSelected, cellHasFocus);
    }
}

