/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.runner.Starter;
import oracle.ide.util.Assert;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdevimpl.ant.AntHook;
import oracle.jdevimpl.runner.EnvironmentVariable;
import oracle.jdevimpl.runner.RunConfigurationLaunchPanel;

public abstract class JRunProcess
extends RunProcess {
    private static final String PROCESS_ACTION_BUTTON = "JRunProcess.process-action-button";
    private static final String PROCESS_ACTION_BUTTON_GROUP = "DebuggingProcess.process-action-button-group";
    protected boolean considerDefaultRunTarget = true;
    protected RunConfiguration runConfiguration;
    protected long timeAfterCompile;
    protected boolean lockCompiler = true;
    protected boolean compileSavedAll = false;
    protected List<Object> compilationTargets = Collections.emptyList();
    public static String COMPILE_FROM_JRUNPROCESS = "COMPILE_FROM_JRUNPROCESS";
    protected boolean canceledSelectionOfDefaultRunTarget = false;
    public static final String RUN_TYPE_JAVA = "Java";
    public static final String RUN_TYPE_DATABASE = "Database";
    public static final String RUN_TYPE_XSLT = "XSLT";
    public static final String RUN_TYPE_XQUERY = "XQuery";
    public static final String RUN_TYPE_JS_MOZILLA_FIREFOX = "Mozilla_FireFox";
    public static final String RUN_COOKIE_JAVA_EMBEDDED_SERVER = "Embedded Server";
    public static final String JAVA_FIRST_COMMAND_OPTIONS = "FirstJavaCommandOptions";
    public static final String JAVA_LAST_COMMAND_OPTIONS = "LastJavaCommandOptions";
    public static final String JAVA_CLASS_PATH = "ClassPath";
    public static final String JAVA_BOOT_CLASS_PATH = "BootClassPath";
    public static final String DATABASE_RUN_HELPER = "DatabaseRunHelper";
    public static final String XSLT_FIRST_COMMAND_OPTIONS = "FirstXSLTCommandOptions";
    public static final String XSLT_LAST_COMMAND_OPTIONS = "LastXSLTCommandOptions";

    public JRunProcess() {
        this(null);
    }

    public JRunProcess(Context context) {
        super(context);
        RunConfiguration contextRunConfiguration;
        if (context != null) {
            this.context = context;
        } else {
            Context icontext = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            icontext.setWorkspace(Ide.getActiveWorkspace());
            icontext.setProject(Ide.getActiveProject());
            this.context = icontext;
        }
        if (this.context.getProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT) != null) {
            this.considerDefaultRunTarget = false;
            this.context.removeProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT);
        }
        RunConfiguration runConfiguration = contextRunConfiguration = context == null ? null : (RunConfiguration)((Object)context.getProperty("RunContext.RUN_CONFIGURATION"));
        if (contextRunConfiguration == null) {
            boolean storeAtWorkspaceLevel;
            Project project = null;
            project = context != null ? context.getProject() : Ide.getActiveProject();
            if (project == null) {
                project = Ide.getDefaultProject();
            }
            this.runConfiguration = (storeAtWorkspaceLevel = SharedPropertiesManager.get().isUsingSharedProperties(project, "oracle.jdeveloper.runner.RunConfigurations")) ? RunConfiguration.getInstance((PropertyStorage)this.getWorkspace()) : RunConfiguration.getInstance((PropertyStorage)project);
        } else {
            this.runConfiguration = contextRunConfiguration;
        }
        if (!this.considerDefaultRunTarget && this.runConfiguration != null) {
            this.considerDefaultRunTarget = !this.runConfiguration.isRunActiveFile();
        }
        this.logCommandString = this.runConfiguration.isLogCommand();
        this.logOutput = this.runConfiguration.isLogOutput();
        this.logError = this.runConfiguration.isLogError();
        this.allowInput = this.runConfiguration.isAllowInput();
        this.logExit = this.runConfiguration.isLogExit();
    }

    public Project getJProject() {
        return this.getProject();
    }

    public Project getJProject(Context context) {
        return JRunProcess.getProject((Context)context);
    }

    public RunConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    public long getTimeAfterCompile() {
        return this.timeAfterCompile;
    }

    protected void determineTargetAndStarter(Class starterFactorySubClass) {
        Runner runner = Runner.getRunner();
        Project project = this.getProject();
        boolean projectIsDefaultProject = project.isDefault();
        URL defaultRunTargetURL = null;
        if (this.runConfiguration != null) {
            defaultRunTargetURL = this.runConfiguration.getTargetURL();
        }
        boolean runActiveFile = true;
        if (this.considerDefaultRunTarget && this.runConfiguration != null && !projectIsDefaultProject) {
            runActiveFile = this.runConfiguration.isRunActiveFile();
        }
        Node contextNodeCouldBeRunnable = null;
        if (runActiveFile) {
            super.determineTargetAndStarter(starterFactorySubClass);
            if (this.target != null) {
                return;
            }
            Node contextNode = RunProcess.getContextNodeForRun((Context)this.context);
            if (contextNode != null) {
                if (CmJavaUtil.isCMUrl((URL)contextNode.getURL())) {
                    return;
                }
                if (runner.couldNodeBeRunnable(contextNode, starterFactorySubClass)) {
                    contextNodeCouldBeRunnable = contextNode;
                }
            }
        }
        if (this.considerDefaultRunTarget) {
            if (defaultRunTargetURL == null && !projectIsDefaultProject) {
                if (RunConfigurationLaunchPanel.showTargetDialog(project, this)) {
                    defaultRunTargetURL = this.runConfiguration.getTargetURL();
                } else {
                    this.errors.clear();
                    this.canceledSelectionOfDefaultRunTarget = true;
                    return;
                }
            }
            if (defaultRunTargetURL != null) {
                Node targetNode = this.makeTargetNode(defaultRunTargetURL);
                if (targetNode != null) {
                    if (targetNode != contextNodeCouldBeRunnable) {
                        String error;
                        boolean needToAddError = false;
                        if (runner.couldNodeBeRunnable(targetNode, starterFactorySubClass)) {
                            if (contextNodeCouldBeRunnable != null) {
                                error = RunMgrArb.format(5, contextNodeCouldBeRunnable.getShortLabel(), targetNode.getShortLabel());
                                this.errors.add(error);
                            }
                            int errorCountBeforeGetStarter = this.errors.size();
                            Starter s = this.getStarterForTarget(project, targetNode, starterFactorySubClass);
                            if (s != null) {
                                this.target = targetNode;
                                this.starter = s;
                                if (contextNodeCouldBeRunnable != null) {
                                    String warning = RunMgrArb.format(6, contextNodeCouldBeRunnable.getShortLabel(), this.target.getShortLabel());
                                    this.log(warning + "\n");
                                }
                                return;
                            }
                            needToAddError = this.errors.size() == errorCountBeforeGetStarter;
                        } else {
                            needToAddError = true;
                        }
                        if (needToAddError) {
                            error = RunMgrArb.format(4, targetNode.getShortLabel());
                            this.errors.add(error);
                        }
                    }
                } else {
                    String targetFileName = URLFileSystem.getFileName((URL)defaultRunTargetURL);
                    String error = RunMgrArb.format(3, targetFileName);
                    this.errors.add(error);
                }
            }
        }
    }

    protected boolean checkStarter(Starter starter, List errors) {
        if (!(starter instanceof JStarter)) {
            return false;
        }
        return super.checkStarter(starter, errors);
    }

    private Node makeTargetNode(URL url) {
        try {
            Node node = NodeFactory.find((URL)url);
            if (node != null) {
                return node;
            }
            if (URLFileSystem.exists((URL)url)) {
                node = NodeFactory.findOrCreate((URL)url);
                return node;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public File getStartDirectory() {
        URL url = this.runConfiguration.getRunDirectoryURL();
        if (url != null) {
            return new File(url.getPath());
        }
        return null;
    }

    private void super_start() {
        super.start();
    }

    public String[] getStartEnvironmentParams() {
        Map<String, String> inheritedEnv = System.getenv();
        List<EnvironmentVariable> evs = this.runConfiguration.getEnvironmentVariables();
        if (evs == null) {
            return null;
        }
        ArrayList<String> evStrings = new ArrayList<String>(inheritedEnv.size() + evs.size());
        for (String key : inheritedEnv.keySet()) {
            evStrings.add(key + "=" + inheritedEnv.get(key));
        }
        for (EnvironmentVariable ev : evs) {
            evStrings.add(ev.toString());
        }
        return evStrings.toArray(new String[evStrings.size()]);
    }

    public final void start() {
        this.initProgressHandle(RunMgrArb.getString(119));
        this.updateProgressHandle(RunMgrArb.getString(126));
        this.canceledSelectionOfDefaultRunTarget = false;
        this.determineTargetAndStarter();
        this.updateProgressHandle(RunMgrArb.getString(127));
        if (this.canceledSelectionOfDefaultRunTarget) {
            this.finishProgressHandle();
            return;
        }
        Thread compileThread = new Thread(){

            @Override
            public void run() {
                if (JRunProcess.this.compile()) {
                    JRunProcess.this.timeAfterCompile = System.currentTimeMillis();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!JRunProcess.this.compileSavedAll && JRunProcess.this.runConfiguration.isSaveAllBeforeRun() && Ide.getIdeArgs().getCreateUI()) {
                                try {
                                    SaveAllCommand.saveAll();
                                }
                                catch (Exception e) {
                                    Assert.printStackTrace((Throwable)e);
                                }
                            }
                            JRunProcess.this.super_start();
                        }
                    });
                } else if (JRunProcess.this.starter instanceof JStarter) {
                    ((JStarter)JRunProcess.this.starter).fireCompilationError();
                }
            }
        };
        compileThread.setPriority(Math.max(1, compileThread.getPriority() - 1));
        compileThread.start();
    }

    protected boolean compile() {
        if (this.runConfiguration != null && !Product.isRaptor()) {
            URL url;
            Node node;
            if (this.runConfiguration.isRemoteDebuggingProfiling()) {
                return true;
            }
            if (this.runConfiguration.isRunAntBeforeRun() && this.runConfiguration.isRunAntBeforeCompile()) {
                this.runAnt();
            }
            Node node2 = node = this.context != null ? this.context.getNode() : null;
            if (node != null && (url = node.getURL()) != null && "sqldev.nav".equals(url.getProtocol())) {
                return true;
            }
            if (this.runConfiguration.isCompileBeforeRun() || this.runConfiguration.isCompileProjectOnlyBeforeRun()) {
                Project project;
                this.updateProgressHandle(RunMgrArb.getString(122));
                Compiler compiler = Compiler.getCompiler();
                if (compiler != null && (project = this.getProject()) != null && !project.isDefault()) {
                    Context compileContext = new Context();
                    compileContext.setProject(project);
                    compileContext.setWorkspace(this.context.getWorkspace());
                    compileContext.setProperty(COMPILE_FROM_JRUNPROCESS, (Object)"true");
                    CompilationScope compileScope = null;
                    if (this.starter instanceof JStarter) {
                        compileScope = ((JStarter)this.starter).getCompilationScope();
                    }
                    if (compileScope == null) {
                        compileScope = this.getCompilationScope();
                    }
                    switch (compileScope) {
                        case DO_NOT_COMPILE: {
                            return true;
                        }
                        case COMPILE_PROJECT: {
                            compileContext.setNode((Node)project);
                            break;
                        }
                        case COMPILE_PROJECT_AND_DEPENDENCIES: {
                            compileContext.setNode((Node)project);
                            break;
                        }
                        case COMPILE_WORKSPACE: {
                            compileContext.setNode((Node)this.context.getWorkspace());
                            break;
                        }
                        case COMPILE_EXPLICIT_TARGETS: {
                            Element[] targets = ((JStarter)this.starter).getExplicitCompilationTargets();
                            compileContext.setSelection(targets);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("JStarter returned illegal compilation scope");
                        }
                    }
                    this.compileSavedAll = Ide.getEnvironOptions().getSaveBeforeCompile();
                    CompileArguments compileArguments = new CompileArguments(compileContext);
                    compileArguments.setRebuildAllSources(false);
                    compileArguments.setSaveBeforeCompiling(true);
                    compileArguments.setWaitForTermination(true);
                    if (compileScope == CompilationScope.COMPILE_PROJECT_AND_DEPENDENCIES) {
                        compileArguments.setCompileDependencies(true);
                    } else {
                        compileArguments.setCompileDependencies(false);
                    }
                    if (!compiler.compile(compileArguments)) {
                        this.updateProgressHandle(RunMgrArb.getString(123));
                        this.finishProgressHandle();
                        return false;
                    }
                }
            }
            this.updateProgressHandle(RunMgrArb.getString(123));
            if (this.runConfiguration.isRunAntBeforeRun() && !this.runConfiguration.isRunAntBeforeCompile()) {
                this.runAnt();
            }
        }
        return true;
    }

    public CompilationScope getCompilationScope() {
        if (this.runConfiguration.isCompileBeforeRun()) {
            return CompilationScope.COMPILE_PROJECT_AND_DEPENDENCIES;
        }
        return CompilationScope.COMPILE_PROJECT;
    }

    private void runAnt() {
        AntHook hook;
        this.updateProgressHandle(RunMgrArb.getString(120));
        Project project = this.getProject();
        if (project != null && !project.isDefault() && (hook = AntHook.getAntHook()) != null) {
            Context antContext = new Context();
            antContext.setWorkspace(this.context.getWorkspace());
            antContext.setProject(project);
            hook.runAnt(this.context);
        }
        this.updateProgressHandle(RunMgrArb.getString(121));
    }

    protected LogPage makeLogPage(boolean create) {
        LogPage logPage = super.makeLogPage(create);
        if (logPage != null && this.runConfiguration != null && this.runConfiguration.isClearLogBeforeRun()) {
            logPage.clearAll();
        }
        return logPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startTarget() {
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null && this.lockCompiler) {
            boolean giveError = false;
            if (IdeBootProperties.isHeadlessMode()) {
                if (!compiler.lock(this.context, 10000L)) {
                    giveError = true;
                }
            } else if (!compiler.lock(this.context, true)) {
                giveError = true;
            }
            if (giveError) {
                String error = RunMgrArb.getString(7);
                this.log(error + "\n");
                return false;
            }
        }
        boolean result = false;
        try {
            result = super.startTarget();
        }
        finally {
            if (compiler != null && this.lockCompiler) {
                compiler.unlock(this.context);
            }
        }
        return result;
    }

    public JDK getJdkDefinition() {
        Project project = this.getProject();
        JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        if (projectLibs != null) {
            return projectLibs.getJDK();
        }
        return null;
    }

    public boolean isPlainRun() {
        String[] javaCommandOptions = (String[])this.getValue(RUN_TYPE_JAVA, null, JAVA_FIRST_COMMAND_OPTIONS);
        if (javaCommandOptions != null && javaCommandOptions.length > 0) {
            return false;
        }
        javaCommandOptions = (String[])this.getValue(RUN_TYPE_JAVA, null, JAVA_LAST_COMMAND_OPTIONS);
        return javaCommandOptions == null || javaCommandOptions.length <= 0;
    }

    public boolean isSameType(JRunProcess other) {
        return other != null && ((Object)((Object)this)).getClass() == ((Object)((Object)other)).getClass();
    }

    protected void showLogPageToolbar(boolean visible) {
        Toolbar toolbar = this.getLogPageToolbar();
        if (toolbar != null) {
            toolbar.setVisible(visible);
        }
    }

    protected Toolbar getLogPageToolbar() {
        LogPage lp = this.getLogPage();
        if (lp instanceof RunLogPage) {
            return ((RunLogPage)lp).getToolbar();
        }
        return null;
    }

    protected ToolButton addProcessActionButtonToToolbar(IdeAction action, String group) {
        Toolbar toolbar = this.getLogPageToolbar();
        if (toolbar != null) {
            ToolButton button = toolbar.add((ToggleAction)action);
            button.putClientProperty((Object)PROCESS_ACTION_BUTTON, (Object)Boolean.TRUE);
            if (group != null) {
                button.putClientProperty((Object)PROCESS_ACTION_BUTTON_GROUP, (Object)group);
            }
            toolbar.validate();
            return button;
        }
        return null;
    }

    protected boolean addProcessActionButtonToToolbar(JComponent actionButton, String group) {
        Toolbar toolbar = this.getLogPageToolbar();
        if (toolbar != null) {
            actionButton.putClientProperty(PROCESS_ACTION_BUTTON, Boolean.TRUE);
            if (group != null) {
                actionButton.putClientProperty(PROCESS_ACTION_BUTTON_GROUP, group);
            }
            toolbar.add((Component)actionButton);
            toolbar.validate();
            return true;
        }
        return false;
    }

    protected void setProcessActionButtonGroup(JComponent actionButton, String group) {
        actionButton.putClientProperty(PROCESS_ACTION_BUTTON_GROUP, group);
    }

    protected String getProcessActionButtonGroup(JComponent actionButton) {
        return (String)actionButton.getClientProperty(PROCESS_ACTION_BUTTON_GROUP);
    }

    protected void showProcessActionButtonsOnToolbar(String group, boolean visible) {
        Toolbar logPageToolbar = this.getLogPageToolbar();
        if (logPageToolbar != null) {
            for (Component component : logPageToolbar.getComponents()) {
                String groupProperty;
                if (!(component instanceof JComponent) || !group.equals(groupProperty = (String)((JComponent)component).getClientProperty(PROCESS_ACTION_BUTTON_GROUP))) continue;
                component.setVisible(visible);
            }
            logPageToolbar.validate();
        }
    }

    protected void clearProcessActionButtonsFromToolbar() {
        final Toolbar toolbar = this.getLogPageToolbar();
        if (toolbar != null) {
            for (Component component : toolbar.getComponents()) {
                if (!(component instanceof JComponent) || ((JComponent)component).getClientProperty(PROCESS_ACTION_BUTTON) != Boolean.TRUE) continue;
                toolbar.remove(component);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    toolbar.validate();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    public static enum CompilationScope {
        DO_NOT_COMPILE,
        COMPILE_PROJECT,
        COMPILE_PROJECT_AND_DEPENDENCIES,
        COMPILE_WORKSPACE,
        COMPILE_EXPLICIT_TARGETS;

    }
}

