/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.treetable;

import java.awt.Component;
import java.awt.Font;
import javax.swing.ButtonModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.util.TriStateBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeCategory;
import oracle.jdevimpl.style.treetable.CodingStyleTreeCategoryBoolean;
import oracle.jdevimpl.style.treetable.CodingStyleTreeList;
import oracle.jdevimpl.style.treetable.CodingStyleTreeNumber;

public class CodingStyleTreeTable
extends JFastTreeTable {
    public CodingStyleTreeTable(TreeTableModel model) {
        super(model);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.setAutoResizeMode(1);
        this.setSelectionMode(0);
        this.setTableHeader(null);
        this.setShowGrid(false);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(190);
        columnModel.getColumn(1).setPreferredWidth(40);
        columnModel.setColumnSelectionAllowed(false);
        this.tree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            public Icon getIcon() {
                return null;
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof CodingStyleTreeCategory) {
                    Font f = this.getFont();
                    this.setFont(f.deriveFont(1));
                } else {
                    this.setFont(null);
                }
                return this;
            }
        });
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Object component = this.tree.getPathForRow(row).getLastPathComponent();
        TableCellEditor editor = null;
        if (column > 0) {
            if (component instanceof CodingStyleTreeNumber) {
                CodingStyleTreeNumber treeNumber = (CodingStyleTreeNumber)component;
                NumericSpinBox numericSpinBox = new NumericSpinBox(treeNumber.getMin(), treeNumber.getMax());
                SpinBuddy spinBuddy = numericSpinBox.getSpinBuddy();
                JTextField textField = spinBuddy instanceof JTextField ? (JTextField)spinBuddy : new NumberTextField();
                editor = new DefaultCellEditor(textField);
                ((DefaultCellEditor)editor).setClickCountToStart(1);
            } else if (component instanceof CodingStyleTreeList) {
                CodingStyleTreeList treeList = (CodingStyleTreeList)component;
                editor = new DefaultCellEditor(new JComboBox<String>(treeList.getValues()));
            } else if (component instanceof CodingStyleTreeBoolean) {
                editor = new DefaultCellEditor(new JCheckBox());
            } else if (component instanceof CodingStyleTreeCategoryBoolean) {
                editor = new TriStateBooleanEditor(new TriStateCheckBox());
            }
        }
        if (editor == null) {
            editor = super.getCellEditor(row, column);
        }
        return editor;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = null;
        if (column > 0) {
            Object component = this.tree.getPathForRow(row).getLastPathComponent();
            if (component instanceof CodingStyleTreeBoolean) {
                renderer = new BooleanRenderer();
            } else if (component instanceof CodingStyleTreeCategoryBoolean) {
                renderer = new TriStateBooleanRenderer();
            }
        }
        if (renderer == null) {
            renderer = super.getCellRenderer(row, column);
        }
        return renderer;
    }

    static class TriStateBooleanRenderer
    extends TriStateCheckBox
    implements TableCellRenderer {
        TriStateBooleanRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (value instanceof TriStateBoolean) {
                this.setTriState((TriStateBoolean)value);
            }
            return this;
        }
    }

    static class TriStateBooleanEditor
    extends DefaultCellEditor {
        TriStateBooleanEditor(final TriStateCheckBox triStateCheckBox) {
            super(triStateCheckBox);
            final DefaultCellEditor.EditorDelegate oldDelegate = this.delegate;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    if (value instanceof TriStateBoolean) {
                        triStateCheckBox.setTriState((TriStateBoolean)value);
                    } else {
                        oldDelegate.setValue(value);
                    }
                }

                @Override
                public Object getCellEditorValue() {
                    return oldDelegate.getCellEditorValue();
                }
            };
            triStateCheckBox.removeActionListener(oldDelegate);
            triStateCheckBox.addActionListener(this.delegate);
        }
    }

    static class TriStateCheckBox
    extends JCheckBox {
        TriStateCheckBox() {
        }

        void setTriState(TriStateBoolean tri) {
            if (tri == null) {
                tri = TriStateBoolean.TRI_STATE;
            }
            if (tri.isTrue()) {
                super.setSelected(true);
                ButtonModel model = this.getModel();
                model.setArmed(false);
                model.setPressed(false);
            } else if (tri.isFalse()) {
                super.setSelected(false);
                ButtonModel model = this.getModel();
                model.setArmed(false);
                model.setPressed(false);
            } else {
                super.setSelected(true);
                ButtonModel model = this.getModel();
                model.setArmed(true);
                model.setPressed(true);
            }
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BooleanRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            }
            return this;
        }
    }
}

