/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.orest;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.jdbc.orest.LogUtil;
import oracle.dbtools.jdbc.orest.ORestConnection;

public class Driver
extends oracle.dbtools.jdbc.Driver {
    public static final String PREFIX = "jdbc:oracle:orest";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        LogUtil.log();
        return new ORestConnection(url, info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        LogUtil.log();
        return url != null && url.startsWith(PREFIX) && url.indexOf("@") != -1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        LogUtil.log();
        return null;
    }

    static {
        LogUtil.log();
        try {
            Driver driver = new Driver();
            DriverManager.registerDriver(driver);
            LogUtil.setOn();
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't register Driver!");
        }
    }
}

