/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.jdbc.Connection;
import oracle.dbtools.jdbc.RestjdbcResources;
import oracle.dbtools.jdbc.ResultSet;
import oracle.dbtools.parser.plsql.SyntaxError;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class Statement
implements java.sql.Statement {
    Logger LOGGER = Logger.getLogger(Statement.class.getName());
    private Connection conn = null;
    private static final String ADHOC_ENDPOINT = "_/sql/test";
    java.sql.ResultSet currentResultSet;
    private boolean closed = false;
    SQLWarning sqlWarning;
    private long maxRows = 0L;
    private String sql;
    protected long fetchSize = 0L;
    boolean isCloseOnCompletion = false;

    public Statement() {
    }

    public Statement(Connection conn) {
        this.conn = conn;
        this.closed = false;
    }

    private void validator(String sql) throws SQLException {
        SyntaxError err = null;
        if (!(sql.contains("drop") || sql.contains("DROP") || sql.contains("Drop"))) {
            err = SyntaxError.checkSingleStatement((String)sql);
        }
        if (err != null) {
            throw new SQLException(err.getDetailedMessage());
        }
    }

    protected String generateJsonPost(String sql) {
        this.sql = sql;
        JsonFactory f = new JsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator g = null;
        try {
            g = f.createGenerator((Writer)writer);
            g.writeStartObject();
            g.writeStringField("statementText", sql);
            g.writeNumberField("offset", 0);
            if (this.fetchSize > 0L) {
                g.writeNumberField("limit", this.fetchSize);
            } else {
                g.writeNumberField("limit", 25);
            }
            g.writeEndObject();
            g.close();
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage());
        }
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableHttpResponse executeInternal(String sql) throws SQLException {
        this.sql = sql;
        this.validator(sql);
        CloseableHttpResponse response = null;
        Connection connection = this.conn;
        synchronized (connection) {
            Session session = this.conn.getConnection();
            StringBuilder uri = new StringBuilder();
            uri.append(this.conn.getUri());
            uri.append(ADHOC_ENDPOINT);
            URI root = URI.create(uri.toString());
            try {
                HttpPost post = session.createPost(root);
                post.addHeader("Content-Type", "application/json");
                String jsonPost = this.generateJsonPost(sql);
                StringEntity strEntity = new StringEntity(jsonPost);
                post.setEntity((HttpEntity)strEntity);
                response = session.executeRequest((HttpUriRequest)post);
            }
            catch (IOException | IllegalStateException | SessionException e) {
                this.LOGGER.log(Level.SEVERE, e.getMessage());
            }
            return response;
        }
    }

    protected void handleErrors(JsonNode node) throws SQLException {
        if (node.findValue("errorCode") != null) {
            int error_code = node.findValue("errorCode").asInt();
            int error_line = node.findValue("errorLine").asInt();
            int error_column = node.findValue("errorColumn").asInt();
            String error_details = node.findValue("errorDetails").asText();
            throw new SQLException(error_details + "\n", "" + error_code);
        }
        if (node.findValue("error") != null) {
            throw new SQLException(node.findValue("error").asText());
        }
    }

    protected JsonNode createJsonNode(CloseableHttpResponse response) throws SQLException {
        HttpEntity entity = response.getEntity();
        JsonNode node = null;
        try {
            InputStream is = entity.getContent();
            JsonFactory f = new JsonFactory();
            JsonParser jp = f.createJsonParser(is);
            ObjectMapper mapper = new ObjectMapper();
            node = (JsonNode)mapper.readTree(jp);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.LOGGER.severe(e.getMessage());
            throw new SQLException(RestjdbcResources.getString("ORA_17001"));
        }
        return node;
    }

    protected int getResult(JsonNode node) throws SQLException {
        int result = 0;
        if (node.findValue("result") != null) {
            result = node.findValue("result").asInt();
        }
        return result;
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        CloseableHttpResponse response = this.executeInternal(sql);
        this.currentResultSet = new ResultSet(response, this, this.conn);
        return this.currentResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        boolean result = false;
        CloseableHttpResponse response = null;
        try {
            result = true;
            response = this.executeInternal(sql);
            JsonNode node = this.createJsonNode(response);
            this.handleErrors(node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage(), e.getStackTrace());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        int result = 0;
        CloseableHttpResponse response = null;
        try {
            response = this.executeInternal(sql);
            JsonNode node = this.createJsonNode(response);
            this.handleErrors(node);
            result = this.getResult(node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage(), e.getStackTrace());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            this.closed = true;
            if (this.currentResultSet != null) {
                this.currentResultSet = null;
            }
            this.maxRows = 0L;
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        this.ensureOpen();
        return this.conn;
    }

    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(RestjdbcResources.getString("ORA_17009"));
        }
        if (this.conn == null) {
            throw new SQLException(RestjdbcResources.getString("ORA_17008"));
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            this.ensureOpen();
            if (direction != 1000) {
                if (direction == 1001 || direction == 1002) {
                    this.sqlWarning = new SQLWarning(RestjdbcResources.get("RESTJDBC_007"));
                } else {
                    throw new SQLException(RestjdbcResources.getString("ORA_17308"));
                }
            }
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureOpen();
        return (int)this.maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int max) throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            this.ensureOpen();
            if (max < 0) {
                throw new SQLException(RestjdbcResources.getString("ORA_17433"));
            }
            if (this.closed) {
                throw new SQLException(RestjdbcResources.getString("ORA_17009"));
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ensureOpen();
        if (rows < 0) {
            throw new SQLException(RestjdbcResources.getString("ORA_17433"));
        }
        if (this.closed) {
            throw new SQLException(RestjdbcResources.getString("ORA_17009"));
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return (int)this.fetchSize;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        this.isCloseOnCompletion = true;
        this.close();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.isCloseOnCompletion;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.currentResultSet;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
        this.sqlWarning = null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return this.sqlWarning;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    public String getSqlString() {
        return this.sql;
    }
}

