/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Iterator;
import oracle.dbtools.jdbc.RestjdbcResources;

public class SQLStateMapping {
    static String mappingResource = "errorMap.json";

    public static String getSQLState(int errorCode) throws SQLException {
        try {
            InputStream s = SQLStateMapping.class.getResourceAsStream(mappingResource);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(s).get("oraErrorSqlStateSqlExceptionMapping").get("error");
            Iterator iterator = node.elements();
            while (iterator.hasNext()) {
                JsonNode obj = (JsonNode)iterator.next();
                int oraErrorFrom = obj.get("oraErrorFrom").asInt();
                if (obj.get("oraErrorTo") != null) {
                    int oraErrorTo = obj.get("oraErrorTo").asInt();
                    if (errorCode < oraErrorFrom || errorCode > oraErrorTo) continue;
                    return obj.get("sqlState").asText();
                }
                if (errorCode != oraErrorFrom) continue;
                return obj.get("sqlState").asText();
            }
        }
        catch (Exception e) {
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), "99999", 17001);
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17001"), "99999", 17001);
    }
}

