/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.xml.bind.DatatypeConverter;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.jdbc.CallableStatement;
import oracle.dbtools.jdbc.Connection;
import oracle.dbtools.jdbc.PreparedStatement;
import oracle.dbtools.jdbc.RestjdbcResources;
import oracle.dbtools.jdbc.ResultSetMetadata;
import oracle.dbtools.jdbc.SQLStateMapping;
import oracle.dbtools.jdbc.Statement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class ResultSet
implements java.sql.ResultSet {
    Logger LOGGER = Logger.getLogger(ResultSet.class.getName());
    private static final String TOKEN_START_SECTION = "resultSet";
    private static final String TOKEN_START_STR = "items";
    private static final String TOKEN_START_METADATA = "metadata";
    private static final String TOKEN_ERR = "error";
    private static final String TOKEN_RESPONSE = "response";
    private static final int QUOTES = 34;
    private static final int BACKSLASH = 92;
    private static final int NEWLINE = 110;
    private static final int SPACE = 32;
    private static final int START_OBJECT = 123;
    private static final int END_OBJECT = 125;
    private static final int START_ARRAY = 91;
    private static final int END_ARRAY = 93;
    private boolean debug = false;
    private boolean isResultsStarted = false;
    private boolean isResultsEnded = false;
    private int c;
    private Map<String, Integer> colNames = new HashMap<String, Integer>();
    private Map<Integer, JsonNode> rowData = new HashMap<Integer, JsonNode>();
    private JsonNode rsMetadataTree = null;
    private InputStream stream = null;
    private boolean metadata = false;
    private boolean emptyResultSet = false;
    private java.sql.Statement stmt = null;
    private PreparedStatement pstmt = null;
    private CallableStatement cstmt = null;
    private boolean isResultSetClosed = false;
    private long maxRows = 0L;
    private boolean closed = false;
    private int offset = 0;
    private String sql = null;
    private Connection conn = null;
    private static final String ADHOC_ENDPOINT = "_/sql/test";
    private int rowCount = 0;
    private boolean metadataCreated = false;
    public long fetchSize = 0L;

    public ResultSet(CloseableHttpResponse response, Statement stmt, Connection conn) throws SQLException {
        HttpEntity entity = response.getEntity();
        this.conn = conn;
        this.sql = stmt.getSqlString();
        this.fetchSize = stmt.getFetchSize();
        this.stmt = stmt;
        this.pstmt = null;
        this.cstmt = null;
        try {
            this.maxRows = stmt.getMaxRows();
            this.stream = entity.getContent();
            if (!this.metadataCreated && this.isResultSetSection()) {
                this.startMetaData();
                this.createMetadataTree();
                this.metadataCreated = true;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    public ResultSet(HttpResponse response, PreparedStatement stmt) throws SQLException {
        HttpEntity entity = response.getEntity();
        this.pstmt = stmt;
        this.stmt = null;
        this.cstmt = null;
        this.fetchSize = stmt.getFetchSize();
        try {
            this.maxRows = stmt.getMaxRows();
            this.stream = entity.getContent();
            if (!this.metadataCreated && this.isResultSetSection()) {
                this.startMetaData();
                this.createMetadataTree();
                this.metadataCreated = true;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    public ResultSet(HttpResponse response, CallableStatement stmt) throws SQLException {
        HttpEntity entity = response.getEntity();
        this.cstmt = stmt;
        this.pstmt = null;
        this.stmt = null;
        this.fetchSize = stmt.getFetchSize();
        try {
            this.maxRows = stmt.getMaxRows();
            this.stream = entity.getContent();
            if (!this.metadataCreated && this.isResultSetSection()) {
                this.startMetaData();
                this.createMetadataTree();
                this.metadataCreated = true;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    public ResultSet(InputStream is, CallableStatement stmt) throws SQLException {
        this.cstmt = stmt;
        this.pstmt = null;
        this.stmt = null;
        this.fetchSize = stmt.getFetchSize();
        try {
            this.maxRows = stmt.getMaxRows();
            this.stream = is;
            if (!this.metadataCreated && this.isResultSetSection()) {
                this.startMetaData();
                this.createMetadataTree();
                this.metadataCreated = true;
            }
        }
        catch (IllegalStateException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    public void createMetadataTree() throws SQLException {
        if (this.emptyResultSet) {
            throw new SQLException(RestjdbcResources.getString("RESTJDBC_007"));
        }
        this.LOGGER.info("Extracting ResultSet metadata");
        boolean metadataEnded = false;
        StringBuilder sb = new StringBuilder();
        int innerJsonObj = 0;
        int innerJsonArray = 0;
        sb.append('{');
        sb.append("\"");
        sb.append(TOKEN_START_METADATA);
        sb.append("\"");
        while (!metadataEnded) {
            try {
                this.c = this.stream.read();
                if (this.c == 123) {
                    ++innerJsonObj;
                } else if (this.c == 91) {
                    ++innerJsonArray;
                } else if (this.c == 125) {
                    --innerJsonObj;
                } else if (this.c == 93) {
                    --innerJsonArray;
                }
                if (innerJsonArray == 0 && innerJsonObj == 0 && this.c == 93) {
                    metadataEnded = true;
                    int n = this.stream.read();
                }
                sb.append((char)this.c);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, e.getMessage(), e);
            }
        }
        sb.append('}');
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.rsMetadataTree = mapper.readTree(sb.toString());
            sb = null;
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, e.getMessage(), e);
        }
    }

    public boolean isResultSetSection() throws SQLException {
        this.LOGGER.finest("Checking to see if there is a ResultSet returned");
        boolean result = false;
        int quotes = 0;
        StringBuilder sb = new StringBuilder();
        boolean rsSection = false;
        String resultSetToken = TOKEN_START_SECTION;
        while (!rsSection && this.c > -1) {
            try {
                this.c = this.stream.read();
                if (this.c == 34) {
                    ++quotes;
                } else if (quotes == 1) {
                    sb.append((char)this.c);
                }
                if (quotes != 2) continue;
                quotes = 0;
                if (sb.toString().equals(resultSetToken)) {
                    rsSection = true;
                    this.metadata = true;
                    result = true;
                    continue;
                }
                sb.setLength(0);
            }
            catch (IOException e) {
                this.LOGGER.severe(e.getMessage());
            }
        }
        if (!result) {
            this.emptyResultSet = true;
            this.metadata = false;
        }
        return result;
    }

    public void startMetaData() throws SQLException {
        boolean metadata_started = false;
        this.LOGGER.finer("Starting metadata section");
        int quotes = 0;
        StringBuilder sb = new StringBuilder();
        while (!metadata_started && this.c > -1) {
            try {
                this.c = this.stream.read();
                if (this.c == 34) {
                    ++quotes;
                } else if (quotes == 1) {
                    sb.append((char)this.c);
                }
                if (quotes != 2) continue;
                quotes = 0;
                if (sb.toString().equals(TOKEN_START_METADATA)) {
                    metadata_started = true;
                    this.metadata = true;
                    break;
                }
                if (sb.toString().equals(TOKEN_RESPONSE)) {
                    this.processResponse();
                    return;
                }
                if (sb.toString().contains(TOKEN_ERR)) {
                    this.processError();
                    return;
                }
                sb.setLength(0);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                    continue;
                }
                this.LOGGER.log(Level.SEVERE, "Exception: Error in reading ResultSetMetadata");
            }
        }
        sb.setLength(0);
    }

    private void processError() throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        this.stream.read();
        boolean endErr = false;
        int count = 0;
        while (!endErr) {
            try {
                int c = this.stream.read();
                if (c == 34) {
                    ++count;
                    continue;
                }
                if (count < 2) {
                    if (c == 92 && this.stream.read() == 110) {
                        sb.append(System.lineSeparator());
                        continue;
                    }
                    sb.append((char)c);
                    continue;
                }
                String exception = sb.toString();
                throw new SQLException(exception);
            }
            catch (IOException e) {
                this.LOGGER.log(Level.WARNING, e.getCause().toString());
            }
        }
    }

    private void processResponse() throws SQLException {
        boolean endErr = false;
        boolean firstwordRead = false;
        int array = 0;
        boolean entered = false;
        String s = null;
        StringBuilder sb = new StringBuilder();
        boolean error = false;
        try {
            while (!endErr) {
                int c = this.stream.read();
                if (c == 91) {
                    ++array;
                    c = this.stream.read();
                    c = this.stream.read();
                    entered = true;
                } else if (c == 93) {
                    --array;
                } else if (array >= 1) {
                    if (c == 92 && (c = this.stream.read()) == 110) {
                        sb.append(System.lineSeparator());
                    } else if (!firstwordRead) {
                        byte[] b = new byte[5];
                        this.stream.read(b);
                        s = new String(b);
                        sb.append(s);
                        firstwordRead = true;
                    } else {
                        if (s.equalsIgnoreCase("Error")) {
                            error = true;
                        }
                        sb.append((char)c);
                    }
                }
                if (array != 0 || !entered) continue;
                endErr = true;
                if (!error) {
                    this.LOGGER.info(sb.toString().substring(0, sb.toString().length() - 1));
                    continue;
                }
                throw new SQLException(sb.toString().substring(0, sb.toString().length() - 1));
            }
        }
        catch (IOException e) {
            this.LOGGER.log(Level.INFO, e.getCause().toString());
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.metadataCreated) {
            return false;
        }
        if (!this.isResultsStarted) {
            this.startResults();
            this.isResultsStarted = true;
        }
        if (this.emptyResultSet) {
            this.LOGGER.log(Level.INFO, RestjdbcResources.getString("RESTJDBC_014"));
            return false;
        }
        JsonNode node = null;
        if (this.isResultsStarted && !this.isResultsEnded) {
            ++this.rowCount;
            if (this.maxRows == 0L || this.maxRows > 0L && (long)this.rowCount <= this.maxRows) {
                String row = this.walkRow();
                ObjectMapper mapper = new ObjectMapper();
                try {
                    node = mapper.readTree(row);
                }
                catch (IOException e) {
                    this.LOGGER.info(e.getMessage());
                }
                row = null;
                Iterator iterator = node.fields();
                int count = 0;
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    this.rowData.put(++count, (JsonNode)entry.getValue());
                    this.colNames.put((String)entry.getKey(), count);
                    iterator.remove();
                }
                node = null;
                if (this.LOGGER.isLoggable(Level.FINEST)) {
                    Runtime runtime = Runtime.getRuntime();
                    long memory = runtime.totalMemory() - runtime.freeMemory();
                    this.LOGGER.log(Level.FINEST, "Used memory in MBs: " + (double)memory / Math.pow(10.0, 6.0));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected String generateJsonPostStmt(String sql) {
        JsonFactory f = new JsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator g = null;
        if (this.fetchSize == 0L) {
            this.fetchSize = 25L;
        }
        this.offset = (int)((long)this.offset + this.fetchSize);
        try {
            g = f.createGenerator((Writer)writer);
            g.writeStartObject();
            g.writeStringField("statementText", sql);
            g.writeNumberField("offset", this.offset);
            g.writeNumberField("limit", this.fetchSize);
            g.writeEndObject();
            g.close();
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage());
        }
        return ((Object)writer).toString();
    }

    private CloseableHttpResponse executeInternal() {
        CloseableHttpResponse response = null;
        Session session = this.conn.getConnection();
        StringBuilder uri = new StringBuilder();
        uri.append(this.conn.getUri());
        uri.append(ADHOC_ENDPOINT);
        URI root = URI.create(uri.toString());
        try {
            HttpPost post = session.createPost(root);
            post.addHeader("Content-Type", "application/json");
            String jsonPost = null;
            if (this.stmt != null) {
                jsonPost = this.generateJsonPostStmt(this.sql);
            } else if (this.pstmt != null || this.cstmt != null) {
                // empty if block
            }
            StringEntity strEntity = new StringEntity(jsonPost);
            post.setEntity((HttpEntity)strEntity);
            response = session.executeRequest((HttpUriRequest)post);
        }
        catch (IOException | IllegalStateException | SessionException e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage());
        }
        return response;
    }

    private void startNewFetch() {
        try {
            this.stream.read();
            byte[] buffer1 = new byte[9];
            this.stream.read(buffer1);
            String hasMore = "";
            for (byte by : buffer1) {
                hasMore = hasMore + (char)by;
            }
            buffer1 = null;
            byte[] buffer2 = new byte[5];
            this.stream.read();
            this.stream.read(buffer2);
            String value = "";
            for (byte b : buffer2) {
                value = value + (char)b;
            }
            if (value.contains("false")) {
                this.isResultsEnded = true;
            } else if (value.contains("true") && ((long)this.rowCount <= this.maxRows || this.maxRows == 0L)) {
                CloseableHttpResponse response = this.executeInternal();
                HttpEntity httpEntity = response.getEntity();
                this.stream = httpEntity.getContent();
                this.isResultsEnded = false;
                this.isResultsStarted = false;
                this.metadataCreated = false;
            }
        }
        catch (Exception e) {
            this.LOGGER.severe(e.getMessage());
        }
    }

    public String walkRow() {
        boolean hasRowEnded = false;
        StringBuilder row = new StringBuilder();
        int innerJsonObj = 0;
        int innerJsonArray = 0;
        while (!hasRowEnded && !this.isResultsEnded) {
            try {
                if (this.c == -1) {
                    return row.toString();
                }
                if (this.c == 123) {
                    ++innerJsonObj;
                } else if (this.c == 91) {
                    ++innerJsonArray;
                } else if (this.c == 125) {
                    --innerJsonObj;
                } else if (this.c == 93) {
                    --innerJsonArray;
                }
                if (innerJsonArray == 0 && innerJsonObj == 0 && this.c == 125) {
                    hasRowEnded = true;
                    int s = this.stream.read();
                    char s_char = (char)s;
                    if (s == 93) {
                        this.startNewFetch();
                    }
                }
                row.append((char)this.c);
                this.c = this.stream.read();
            }
            catch (IOException e) {
                this.LOGGER.log(Level.INFO, e.getCause().toString());
            }
        }
        return row.toString();
    }

    public void startResults() {
        int quotes = 0;
        StringBuilder sb = new StringBuilder();
        while (!this.isResultsStarted && this.c > -1) {
            try {
                this.c = this.stream.read();
                if (this.c == 34) {
                    ++quotes;
                } else if (quotes == 1) {
                    sb.append((char)this.c);
                }
                if (quotes != 2) continue;
                quotes = 0;
                if (sb.toString().equals(TOKEN_START_STR)) {
                    while (this.c != 91 && this.c > -1) {
                        this.c = this.stream.read();
                    }
                    this.c = this.stream.read();
                    if (this.c == 93) {
                        this.emptyResultSet = true;
                        return;
                    }
                    while (this.c != 123) {
                        this.c = this.stream.read();
                    }
                    this.isResultsStarted = true;
                    continue;
                }
                sb.setLength(0);
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                    continue;
                }
                this.LOGGER.log(Level.SEVERE, "Exception: Error reading ResultSet");
            }
        }
    }

    private Object getObjectHelper(int columnIndex) throws SQLException {
        block15: {
            try {
                if (this.closed) {
                    int error_code = 17010;
                    throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
                }
                String type = this.rsMetadataTree.get(TOKEN_START_METADATA).get(columnIndex - 1).get("columnTypeName").toString();
                if (type.contains("NUMBER")) {
                    BigDecimal number = this.rowData.get(columnIndex).decimalValue();
                    return number;
                }
                if (type.contains("BINARY_DOUBLE")) {
                    double binary_double = this.rowData.get(columnIndex).doubleValue();
                    return binary_double;
                }
                if (type.contains("BINARY_FLOAT")) {
                    float binary_float = this.rowData.get(columnIndex).floatValue();
                    return Float.valueOf(binary_float);
                }
                if (type.contains("LONG")) {
                    long long_value = this.rowData.get(columnIndex).asLong();
                    return long_value;
                }
                if (type.contains("CHAR")) {
                    String char_value = this.rowData.get(columnIndex).asText();
                    return char_value;
                }
                if (type.contains("VARCHAR")) {
                    String varchar_value = this.rowData.get(columnIndex).asText();
                    return varchar_value;
                }
                if (type.contains("VARCHAR2")) {
                    String varchar2_value = this.rowData.get(columnIndex).asText();
                    return varchar2_value;
                }
                if (type.contains("DATE")) {
                    Date date_value = this.getDate(columnIndex);
                    return date_value;
                }
                if (type.contains("TIMESTAMP")) {
                    Timestamp timestamp_value = this.getTimestamp(columnIndex);
                    return timestamp_value;
                }
                if (type.contains("TIME")) {
                    Time time_value = this.getTime(columnIndex);
                    return time_value;
                }
            }
            catch (NullPointerException ne) {
                if (ne.getMessage() != null) {
                    this.LOGGER.log(Level.SEVERE, ne.getMessage());
                }
                int error_code = 17003;
                throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            catch (SQLException e) {
                if (e.getMessage() == null) break block15;
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17005"), SQLStateMapping.getSQLState(17005), 17005);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object obj = this.getObjectHelper(columnIndex);
        return obj;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        int columnIndex = this.colNames.get(columnLabel);
        Object obj = this.getObjectHelper(columnIndex);
        return obj;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            return this.rowData.get(columnIndex).asText();
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"));
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            return Short.parseShort(this.rowData.get(columnIndex).toString());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (Exception e) {
            int error_code = 17001;
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(error_code), error_code);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            if (this.rowData.get(columnIndex).canConvertToInt()) {
                return this.rowData.get(columnIndex).asInt();
            }
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            if (this.rowData.get(columnIndex).canConvertToLong()) {
                return this.rowData.get(columnIndex).longValue();
            }
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            return Float.parseFloat(this.rowData.get(columnIndex).toString());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            return Double.parseDouble(this.rowData.get(columnIndex).toString());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.rowData.get(columnIndex).toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            String date_str = this.rowData.get(columnIndex).toString();
            date_str = date_str.substring(1, date_str.length() - 1);
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            java.util.Date date = cal.getTime();
            return new Date(date.getTime());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (IllegalArgumentException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            String date_str = this.rowData.get(columnIndex).toString();
            date_str = date_str.substring(1, date_str.length() - 1);
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            Long timeMillis = cal.getTimeInMillis();
            return new Time(timeMillis);
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (IllegalArgumentException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            String date_str = this.rowData.get(columnIndex).toString();
            date_str = date_str.substring(1, date_str.length() - 1);
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            Long timeMillis = cal.getTimeInMillis();
            Timestamp timeStamp = new Timestamp(timeMillis);
            String nano = null;
            if (date_str.contains(".")) {
                if (date_str.contains("Z")) {
                    nano = date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(90));
                    return timeStamp;
                }
                nano = date_str.contains("+") ? date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(43)) : (date_str.lastIndexOf(45) > 10 ? date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(45)) : date_str.substring(date_str.indexOf(".") + 1));
                String padded_nano = String.format("%-9d", Integer.parseInt(nano)).replace(' ', '0');
                timeStamp.setNanos(Integer.parseInt(padded_nano));
                return timeStamp;
            }
            return timeStamp;
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (IllegalArgumentException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return new SerialClob(this.rowData.get(columnIndex).toString().toCharArray()).getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return new SerialBlob(this.rowData.get(columnIndex).toString().getBytes()).getBinaryStream();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        byte[] arr = this.rowData.get(columnIndex).toString().getBytes();
        return new SerialBlob(arr);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        char[] ch = this.rowData.get(columnIndex).toString().toCharArray();
        return new SerialClob(ch);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return new SerialClob(this.rowData.get(columnIndex).toString().toCharArray()).getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return new SerialClob(this.rowData.get(this.colNames.get(columnLabel)).toString().toCharArray()).getCharacterStream();
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return new SerialBlob(this.rowData.get(this.colNames.get(columnLabel)).toString().getBytes());
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return new SerialClob(this.rowData.get(this.colNames.get(columnLabel)).toString().toCharArray());
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return new SerialClob(this.rowData.get(this.colNames.get(columnLabel)).toString().toCharArray()).getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return new SerialBlob(this.rowData.get(this.colNames.get(columnLabel)).toString().getBytes()).getBinaryStream();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            return this.rowData.get(this.colNames.get(columnLabel)).asText();
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"));
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        int columnIndex = this.colNames.get(columnLabel);
        return this.getShort(columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int columnIndex = this.colNames.get(columnLabel);
        return this.getInt(columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        int columnIndex = this.colNames.get(columnLabel);
        return this.getLong(columnIndex);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        int columnIndex = this.colNames.get(columnLabel);
        return this.getFloat(columnIndex);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        int columnIndex = this.colNames.get(columnLabel);
        return this.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            return new BigDecimal(this.rowData.get(columnIndex).toString());
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        int columnIndex = this.colNames.get(columnLabel);
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            boolean value = this.rowData.get(columnIndex).asBoolean();
            if (value) {
                return value;
            }
            String type = this.rsMetadataTree.get(TOKEN_START_METADATA).get(columnIndex - 1).get("columnTypeName").toString();
            if (type.contains("NUMBER")) {
                if (this.rowData.get(columnIndex).asLong() > 0L) {
                    return true;
                }
                if (this.rowData.get(columnIndex).asLong() == 0L) {
                    return false;
                }
            } else if (type.contains("VARCHAR")) {
                return this.rowData.get(columnIndex).asText().equalsIgnoreCase("true");
            }
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        int columnIndex = this.colNames.get(columnLabel);
        try {
            boolean value = this.rowData.get(columnIndex).asBoolean();
            if (value) {
                return value;
            }
            String type = this.rsMetadataTree.get(TOKEN_START_METADATA).get(columnIndex - 1).get("columnTypeName").toString();
            if (type.contains("NUMBER")) {
                if (this.rowData.get(columnIndex).asLong() > 0L) {
                    return true;
                }
                if (this.rowData.get(columnIndex).asLong() == 0L) {
                    return false;
                }
            } else if (type.contains("VARCHAR")) {
                return this.rowData.get(columnIndex).asText().equalsIgnoreCase("true");
            }
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.rowData.get(this.colNames.get(columnLabel)).toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        String date_str = this.rowData.get(this.colNames.get(columnLabel)).toString();
        date_str = date_str.substring(1, date_str.length() - 1);
        try {
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            java.util.Date date = cal.getTime();
            return new Date(date.getTime());
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        String date_str = this.rowData.get(this.colNames.get(columnLabel)).toString();
        date_str = date_str.substring(1, date_str.length() - 1);
        try {
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            Long timeMillis = cal.getTimeInMillis();
            return new Time(timeMillis);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        String date_str = this.rowData.get(this.colNames.get(columnLabel)).toString();
        date_str = date_str.substring(1, date_str.length() - 1);
        try {
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            Long timeMillis = cal.getTimeInMillis();
            Timestamp timeStamp = new Timestamp(timeMillis);
            String nano = null;
            if (date_str.contains(".")) {
                if (date_str.contains("Z")) {
                    nano = date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(90));
                    return timeStamp;
                }
                nano = date_str.contains("+") ? date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(43)) : (date_str.lastIndexOf(45) > 10 ? date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(45)) : date_str.substring(date_str.indexOf(".") + 1));
                String padded_nano = String.format("%-9d", Integer.parseInt(nano)).replace(' ', '0');
                timeStamp.setNanos(Integer.parseInt(padded_nano));
                return timeStamp;
            }
            return timeStamp;
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.stream.close();
            this.rsMetadataTree = null;
            this.colNames = null;
            this.rowData = null;
            this.isResultSetClosed = true;
            this.closed = true;
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    public Set columnNames() {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.metadata = false;
        if (false) {
            int errorCode = 17283;
            throw new SQLException(RestjdbcResources.getString("ORA_17283"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return new ResultSetMetadata(this.rsMetadataTree);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public java.sql.Statement getStatement() throws SQLException {
        try {
            if (this.isResultSetClosed) {
                throw new SQLException(RestjdbcResources.getString("RESTJDBC_006"));
            }
            if (this.stmt != null && this.pstmt == null && this.cstmt == null) {
                return this.stmt;
            }
            if (this.stmt == null && this.pstmt != null && this.cstmt == null) {
                return this.pstmt;
            }
            if (this.stmt == null && this.pstmt == null && this.cstmt != null) {
                return this.cstmt;
            }
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
        throw new SQLException(RestjdbcResources.get("ORA_17001"));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return 0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return null;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return 0;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return 0;
    }

    @Override
    public void beforeFirst() throws SQLException {
    }

    @Override
    public void afterLast() throws SQLException {
    }

    @Override
    public boolean first() throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowCount;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException(RestjdbcResources.getString("ORA_17433"));
        }
        if (this.closed) {
            throw new SQLException(RestjdbcResources.getString("ORA_17009"));
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.closed) {
            throw new SQLException(RestjdbcResources.getString("ORA_17009"));
        }
        return (int)this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return 0;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new UnsupportedOperationException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", new Exception().getStackTrace()[0].getMethodName(), this.getClass().getSimpleName()));
    }
}

