/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.jdbc.Connection;
import oracle.dbtools.jdbc.ParameterMetaData;
import oracle.dbtools.jdbc.RestjdbcResources;
import oracle.dbtools.jdbc.ResultSet;
import oracle.dbtools.jdbc.Statement;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.DataTypeConnectionProviderImpl;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    Logger LOGGER = Logger.getLogger(PreparedStatement.class.getName());
    private Connection conn = null;
    protected String sql;
    private static final String ADHOC_ENDPOINT = "_/sql/test";
    protected JsonFactory f = new JsonFactory();
    protected Writer writer = new StringWriter();
    protected JsonGenerator g = null;
    private boolean closed = false;
    private java.sql.ResultSet currResultSet = null;
    protected Map<Object, Object> data = new HashMap<Object, Object>();
    protected Map<Object, String> types = new HashMap<Object, String>();
    private Map<Integer, Integer> isNullable = new HashMap<Integer, Integer>();
    private Map<Integer, Boolean> isSigned = new HashMap<Integer, Boolean>();
    private Map<Integer, Integer> precision = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> scale = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> parameterType = new HashMap<Integer, Integer>();
    private Map<Integer, String> parameterTypeName = new HashMap<Integer, String>();
    private Map<Integer, String> parameterClassName = new HashMap<Integer, String>();

    protected PreparedStatement() {
    }

    public PreparedStatement(Connection conn, String sql) {
        this.conn = conn;
        this.sql = sql;
    }

    private void validator(String sql) throws SQLException {
        SyntaxError err = null;
        if (!(sql.contains("drop") || sql.contains("DROP") || sql.contains("Drop"))) {
            err = SyntaxError.checkSingleStatement((String)sql);
        }
        if (err != null) {
            throw new SQLException(err.getDetailedMessage());
        }
    }

    protected void generatePost(String sql) throws SQLException {
        this.f = new JsonFactory();
        this.writer = new StringWriter();
        this.g = null;
        String stmtTxt = "statementText";
        String binds = "binds";
        try {
            long fetchSize = this.getFetchSize();
            this.g = this.f.createGenerator(this.writer);
            this.g.writeStartObject();
            this.g.writeStringField(stmtTxt, sql);
            this.g.writeNumberField("offset", 0);
            if (fetchSize > 0L) {
                this.g.writeNumberField("limit", fetchSize);
            } else {
                this.g.writeNumberField("limit", 25);
            }
            if (this.types.isEmpty()) {
                this.g.writeEndObject();
            } else {
                this.g.writeFieldName(binds);
                this.g.writeStartArray();
            }
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (IOException ioe) {
            this.LOGGER.log(Level.SEVERE, ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseableHttpResponse executeInternal(String sql) throws SQLException {
        CloseableHttpResponse response = null;
        Connection connection = this.conn;
        synchronized (connection) {
            Session session = this.conn.getConnection();
            StringBuilder uri = new StringBuilder();
            uri.append(this.conn.getUri());
            uri.append(ADHOC_ENDPOINT);
            URI root = URI.create(uri.toString());
            try {
                HttpPost post = session.createPost(root);
                post.addHeader("Content-Type", "application/json");
                if (this.types.isEmpty()) {
                    this.LOGGER.fine("No bind variables set");
                    this.generatePost(sql);
                    this.g.close();
                    StringEntity strEntity = new StringEntity(this.writer.toString());
                    post.setEntity((HttpEntity)strEntity);
                } else {
                    this.LOGGER.fine("Bind variables are set");
                    this.processSets(sql);
                    this.g.close();
                    StringEntity strEntity = new StringEntity(this.writer.toString());
                    System.out.println(this.writer.toString());
                    post.setEntity((HttpEntity)strEntity);
                }
                response = session.executeRequest((HttpUriRequest)post);
            }
            catch (IOException | IllegalStateException | SessionException e) {
                this.LOGGER.log(Level.SEVERE, e.getMessage());
            }
        }
        return response;
    }

    @Override
    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(RestjdbcResources.getString("ORA_17009"));
        }
        if (this.conn == null) {
            throw new SQLException(RestjdbcResources.getString("ORA_17008"));
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        CloseableHttpResponse response = this.executeInternal(this.sql);
        this.currResultSet = new ResultSet((HttpResponse)response, this);
        return this.currResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int result = 0;
        CloseableHttpResponse response = null;
        try {
            response = this.executeInternal(this.sql);
            JsonNode node = this.createJsonNode(response);
            this.handleErrors(node);
            result = this.getResult(node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean result = false;
        CloseableHttpResponse response = null;
        try {
            result = true;
            response = this.executeInternal(this.sql);
            JsonNode node = this.createJsonNode(response);
            this.handleErrors(node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            this.closed = true;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            this.ensureOpen();
            return this.currResultSet;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        this.ensureOpen();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected void processSets(String sql) throws SQLException {
        String value = "value";
        this.generatePost(sql);
        try {
            for (Object i : this.types.keySet()) {
                this.g.writeStartObject();
                if (i instanceof Integer) {
                    this.g.writeNumberField("index", ((Integer)i).intValue());
                } else if (i instanceof String) {
                    this.g.writeStringField("name", (String)i);
                }
                String data_type = this.types.get(i);
                if (!data_type.equals("DOUBLE") && !data_type.equals("BIGDECIMAL")) {
                    this.g.writeStringField("data_type", this.types.get(i));
                }
                switch (this.types.get(i)) {
                    case "BOOLEAN": {
                        this.g.writeBooleanField(value, ((Boolean)this.data.get(i)).booleanValue());
                        break;
                    }
                    case "byte": {
                        break;
                    }
                    case "SHORT": {
                        this.g.writeNumberField(value, (int)((Short)this.data.get(i)).shortValue());
                        break;
                    }
                    case "INTEGER": {
                        this.g.writeNumberField(value, ((Integer)this.data.get(i)).intValue());
                        break;
                    }
                    case "NUMBER": {
                        if (this.data.get(i) instanceof Integer) {
                            this.g.writeNumberField(value, ((Integer)this.data.get(i)).intValue());
                            break;
                        }
                        if (this.data.get(i) instanceof Short) {
                            this.g.writeNumberField(value, (int)((Short)this.data.get(i)).shortValue());
                            break;
                        }
                        this.g.writeNumberField(value, ((Long)this.data.get(i)).longValue());
                        break;
                    }
                    case "VARCHAR": {
                        this.g.writeStringField(value, (String)this.data.get(i));
                        break;
                    }
                    case "FLOAT": {
                        this.g.writeNumberField(value, ((Float)this.data.get(i)).floatValue());
                        break;
                    }
                    case "DOUBLE": {
                        this.g.writeStringField("data_type", "NUMBER");
                        this.g.writeNumberField(value, ((Double)this.data.get(i)).doubleValue());
                        break;
                    }
                    case "BIGDECIMAL": {
                        this.g.writeStringField("data_type", "NUMBER");
                        this.g.writeNumberField(value, (BigDecimal)this.data.get(i));
                        break;
                    }
                    case "String": {
                        this.g.writeStringField(value, (String)this.data.get(i));
                        break;
                    }
                    case "DATE": {
                        this.g.writeStringField(value, (String)this.data.get(i));
                        break;
                    }
                    case "TIMESTAMP": {
                        this.g.writeStringField(value, (String)this.data.get(i));
                    }
                }
                this.g.writeEndObject();
            }
        }
        catch (IOException e) {
            this.LOGGER.severe("Failure while generating POST\n" + e.getMessage());
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.LOGGER.finest("Setting Boolean");
        this.data.put(parameterIndex, x);
        this.types.put(parameterIndex, "BOOLEAN");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.LOGGER.finest("Setting byte");
        this.data.put(parameterIndex, x);
        this.types.put(parameterIndex, "NUMBER");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.LOGGER.finest("Setting Short");
        this.data.put(parameterIndex, x);
        this.types.put(parameterIndex, "SHORT");
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.LOGGER.finest("Setting Int");
        this.data.put(parameterIndex, x);
        this.types.put(parameterIndex, "INTEGER");
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.LOGGER.finest("Setting Long");
        this.data.put(parameterIndex, x);
        this.types.put(parameterIndex, "NUMBER");
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.LOGGER.finest("Setting Float");
        this.data.put(parameterIndex, Float.valueOf(x));
        this.types.put(parameterIndex, "FLOAT");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.LOGGER.finest("Setting Double");
        this.data.put(parameterIndex, x);
        this.types.put(parameterIndex, "DOUBLE");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.LOGGER.finest("Setting BigDecimal");
        this.data.put(parameterIndex, x);
        this.types.put(parameterIndex, "BIGDECIMAL");
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.LOGGER.finest("Setting String");
        this.data.put(parameterIndex, x);
        this.types.put(parameterIndex, "VARCHAR");
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.LOGGER.finest("Setting Date");
        this.data.put(parameterIndex, this.getFormattedData(x, this.conn, "DATE"));
        System.out.println(this.getFormattedData("1970-01-01T10:02:02Z", this.conn, "DATE"));
        this.types.put(parameterIndex, "DATE");
    }

    protected String getFormattedData(Object obj, java.sql.Connection conn, String dataTypeString) throws SQLException {
        DataType dt = this.getDateDataType(dataTypeString, conn);
        DataValue dv = dt.getDataValue(obj);
        StringValue formattedStringValue = dv.getStringValue(StringType.GENERIC);
        return formattedStringValue.toString();
    }

    protected DataType getDateDataType(String dataTypeString, java.sql.Connection conn) throws SQLException {
        HashMap<TypeMetadata.Attribute, String> attributes = new HashMap<TypeMetadata.Attribute, String>();
        attributes.put(TypeMetadata.Attribute.DATA_TYPE, dataTypeString);
        TypeMetadata typeMetadata = DataTypeFactory.getInstance().getTypeMetadata(attributes);
        DataTypeConnectionProviderImpl dtcp = new DataTypeConnectionProviderImpl(conn);
        DataType dataType = DataTypeFactory.getInstance().getDataType((DataTypeConnectionProvider)dtcp, typeMetadata);
        return dataType;
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.LOGGER.finest("Setting Time");
        this.data.put(parameterIndex, this.getFormattedData(x, this.conn, "DATE"));
        this.types.put(parameterIndex, "DATE");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.LOGGER.finest("Setting Timestamp");
        this.data.put(parameterIndex, this.getFormattedData(x, this.conn, "TIMESTAMP"));
        this.types.put(parameterIndex, "TIMESTAMP");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        }
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        int parameterCount = this.types.size();
        int[] parameterMode = new int[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            parameterMode[i] = 1;
        }
        return new ParameterMetaData(this.isNullable, this.isSigned, this.precision, this.scale, this.parameterType, this.parameterTypeName, this.parameterClassName, parameterMode, parameterCount);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }
}

