/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import java.net.URI;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import oracle.dbtools.http.Client;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionCreator;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.jdbc.CallableStatement;
import oracle.dbtools.jdbc.DatabaseMetaData;
import oracle.dbtools.jdbc.JDBCClient;
import oracle.dbtools.jdbc.JDBCSessionType;
import oracle.dbtools.jdbc.PreparedStatement;
import oracle.dbtools.jdbc.RestjdbcResources;
import oracle.dbtools.jdbc.Statement;

public class Connection
implements java.sql.Connection {
    private String db_url = null;
    private Properties info = null;
    private Session jdbcSession = null;
    private java.sql.DatabaseMetaData databaseMetaData = null;
    public boolean debug = true;
    private String token = null;

    public Connection(String url, Properties info) throws SQLException {
        this.info = info;
        try {
            String user = null;
            char[] pwd = new char[]{};
            if (!info.containsKey("user") || info.get("user") == null) {
                throw new SQLException(RestjdbcResources.getString("RESTJDBC_001"));
            }
            user = (String)info.get("user");
            if (!info.containsKey("password") || info.get("password") == null) {
                throw new SQLException(RestjdbcResources.getString("RESTJDBC_002"));
            }
            String password = (String)info.get("password");
            pwd = password.toCharArray();
            this.db_url = url;
            URI root = URI.create(this.db_url);
            JDBCSessionType jdbcSessionType = new JDBCSessionType();
            JDBCClient client = new JDBCClient(jdbcSessionType);
            String sessionInfo_name = "jdbc_session";
            SessionInfo jdbc_sessionInfo = new SessionInfo(sessionInfo_name, root, null, user, pwd);
            SessionCreator sessionCreator = SessionCreator.createSessionCreator((Client)client);
            this.jdbcSession = sessionCreator.createSession(jdbc_sessionInfo);
        }
        catch (SessionException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            if (!url.startsWith("jdbc:oraclerest")) {
                throw new SQLException(RestjdbcResources.get("RESTJDBC_008"), e);
            }
            throw new SQLException(RestjdbcResources.get("RESTJDBC_009"), e);
        }
    }

    @Override
    public java.sql.Statement createStatement() throws SQLException {
        return new Statement(this);
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return new PreparedStatement(this, sql);
    }

    public Session getConnection() {
        return this.jdbcSession;
    }

    public String getUri() {
        return this.db_url;
    }

    public String getOauth2Token() {
        return this.token;
    }

    @Override
    public void close() throws SQLException {
        this.jdbcSession.close();
        this.info = null;
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql) throws SQLException {
        return new CallableStatement(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new DatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

