/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.jdbc.Connection;
import oracle.dbtools.jdbc.ParameterMetaData;
import oracle.dbtools.jdbc.PreparedStatement;
import oracle.dbtools.jdbc.RestjdbcResources;
import oracle.dbtools.jdbc.ResultSet;
import oracle.dbtools.jdbc.SQLStateMapping;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.utils.oerr.Messages;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class CallableStatement
extends PreparedStatement
implements java.sql.CallableStatement {
    private static final String ADHOC_ENDPOINT = "_/sql/test";
    Logger LOGGER = Logger.getLogger(CallableStatement.class.getName());
    private Connection conn = null;
    private java.sql.ResultSet currentResultSet = null;
    private boolean closed = false;
    private boolean isCursor = false;
    private Map<Object, Integer> outTypes = new HashMap<Object, Integer>();
    private JsonNode node = null;
    ObjectNode outResp = JsonNodeFactory.instance.objectNode();
    private boolean outParams = false;
    private Map<Integer, Integer> isNullable = new HashMap<Integer, Integer>();
    private Map<Integer, Boolean> isSigned = new HashMap<Integer, Boolean>();
    private Map<Integer, Integer> precision = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> scale = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> parameterType = new HashMap<Integer, Integer>();
    private Map<Integer, String> parameterTypeName = new HashMap<Integer, String>();
    private Map<Integer, String> parameterClassName = new HashMap<Integer, String>();

    protected CallableStatement(Connection conn, String sql) {
        this.conn = conn;
        this.sql = this.sqlformatter(sql);
    }

    private String sqlformatter(String sql) {
        if (sql.charAt(0) == '{' && sql.charAt(sql.length() - 1) == '}') {
            sql = sql.substring(1, sql.length() - 1);
        }
        return sql;
    }

    private void syntaxValidator(String sql) throws SQLException {
        SyntaxError err = SyntaxError.checkSingleStatement((String)sql);
        if (err != null) {
            throw new SQLException(err.getDetailedMessage());
        }
        this.LOGGER.finest("Syntax is valid");
    }

    private void allBindsSet() throws SQLException {
        this.LOGGER.finest("Validating syntax of the statement");
        this.syntaxValidator(this.sql);
    }

    @Override
    protected void generatePost(String sql) throws SQLException {
        this.f = new JsonFactory();
        this.writer = new StringWriter();
        this.g = null;
        String stmtTxt = "statementText";
        String binds = "binds";
        try {
            long fetchSize = this.getFetchSize();
            this.g = this.f.createGenerator(this.writer);
            this.g.writeStartObject();
            this.g.writeStringField(stmtTxt, sql);
            this.g.writeNumberField("offset", 0);
            if (fetchSize > 0L) {
                this.g.writeNumberField("limit", fetchSize);
            } else {
                this.g.writeNumberField("limit", 25);
            }
            if (this.types.isEmpty() && this.outTypes.isEmpty()) {
                this.g.writeEndObject();
            } else {
                this.g.writeFieldName(binds);
                this.g.writeStartArray();
            }
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (IOException ioe) {
            this.LOGGER.log(Level.SEVERE, ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseableHttpResponse executeInternal(String sql) throws SQLException {
        CloseableHttpResponse response = null;
        Connection connection = this.conn;
        synchronized (connection) {
            Session session = this.conn.getConnection();
            StringBuilder uri = new StringBuilder();
            uri.append(this.conn.getUri());
            uri.append(ADHOC_ENDPOINT);
            URI root = URI.create(uri.toString());
            try {
                HttpPost post = session.createPost(root);
                post.addHeader("Content-Type", "application/json");
                if (this.types.isEmpty() && this.outTypes.isEmpty()) {
                    this.LOGGER.fine("No bind variables set");
                    this.generatePost(sql);
                    this.g.close();
                    StringEntity strEntity = new StringEntity(this.writer.toString());
                    post.setEntity((HttpEntity)strEntity);
                } else {
                    this.LOGGER.fine("Bind variables are set");
                    this.generatePost(sql);
                    if (!this.types.isEmpty()) {
                        this.processSets(sql);
                    }
                    if (!this.outTypes.isEmpty()) {
                        this.processOUTs();
                    }
                    this.g.close();
                    StringEntity strEntity = new StringEntity(this.writer.toString());
                    System.out.println(this.writer.toString());
                    post.setEntity((HttpEntity)strEntity);
                }
                response = session.executeRequest((HttpUriRequest)post);
            }
            catch (IOException | IllegalStateException | SessionException e) {
                this.LOGGER.log(Level.SEVERE, e.getMessage());
            }
        }
        return response;
    }

    private JsonNode extractResult(Object parameterIndex) throws SQLException {
        int i = 0;
        JsonNode result = null;
        while (true) {
            result = this.node.get("items").get(0).get("binds").get(i);
            System.out.println(result);
            if (result == null) {
                if (this.node.get("items").get(0).findValue("binds") == null) {
                    int errorCode = 17426;
                    throw new SQLException(RestjdbcResources.getString("ORA_17426"), SQLStateMapping.getSQLState(errorCode), errorCode);
                }
                if (this.outTypes.containsKey(parameterIndex)) {
                    int errorCode = 17046;
                    throw new SQLException(RestjdbcResources.getString("ORA_17046"), SQLStateMapping.getSQLState(errorCode), errorCode);
                }
                if (!this.outTypes.containsKey(parameterIndex)) {
                    int errorCode = 17041;
                    String errMsg = RestjdbcResources.getString("ORA_17041") + parameterIndex;
                    throw new SQLException(errMsg, SQLStateMapping.getSQLState(errorCode), errorCode);
                }
                int errorCode = 17001;
                throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            if (parameterIndex instanceof Integer && result.findValue("index") != null ? result.get("index").asInt() == ((Integer)parameterIndex).intValue() : parameterIndex instanceof String && result.findValue("name") != null && result.get("name").asText().equals((String)parameterIndex)) {
                return result;
            }
            ++i;
        }
    }

    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        CloseableHttpResponse response = this.executeInternal(this.sql);
        this.currentResultSet = new ResultSet((HttpResponse)response, this);
        return this.currentResultSet;
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        sql = this.sqlformatter(sql);
        CloseableHttpResponse response = this.executeInternal(sql);
        this.currentResultSet = new ResultSet((HttpResponse)response, this);
        return this.currentResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int result = 0;
        this.node = null;
        CloseableHttpResponse response = null;
        try {
            response = this.executeInternal(this.sql);
            this.node = this.createJsonNode(response);
            this.handleErrors(this.node);
            result = this.getResult(this.node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        boolean result = false;
        CloseableHttpResponse response = null;
        try {
            result = true;
            response = this.executeInternal(sql);
            this.node = this.createJsonNode(response);
            this.handleErrors(this.node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage(), e.getStackTrace());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean result = false;
        CloseableHttpResponse response = null;
        try {
            result = true;
            response = this.executeInternal(this.sql);
            this.node = this.createJsonNode(response);
            this.handleErrors(this.node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.LOGGER.finest("Setting Date");
        this.data.put(parameterIndex, this.getFormattedData(x, this.conn, "DATE"));
        this.types.put(parameterIndex, "DATE");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.LOGGER.finest("Setting Time");
        this.data.put(parameterIndex, this.getFormattedData(x, this.conn, "DATE"));
        this.types.put(parameterIndex, "DATE");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.LOGGER.finest("Setting Timestamp");
        this.data.put(parameterIndex, this.getFormattedData(x, this.conn, "TIMESTAMP"));
        this.types.put(parameterIndex, "TIMESTAMP");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
        this.types.clear();
        this.data.clear();
        this.outTypes.clear();
        this.outParams = false;
        this.node = null;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        int parameterCount = this.types.size() + this.outTypes.size();
        int[] parameterMode = new int[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            parameterMode[i] = 1;
        }
        return new ParameterMetaData(this.isNullable, this.isSigned, this.precision, this.scale, this.parameterType, this.parameterTypeName, this.parameterClassName, parameterMode, parameterCount);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    protected final void ensureOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(RestjdbcResources.getString("ORA_17009"));
        }
        if (this.conn == null) {
            throw new SQLException(RestjdbcResources.getString("ORA_17008"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            this.closed = true;
            if (this.currentResultSet != null) {
                this.currentResultSet = null;
            }
            this.outTypes = null;
            this.data = null;
            this.types = null;
            this.outParams = false;
            this.sql = null;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.LOGGER.finest("Setting Boolean with parameterName: " + parameterName);
        this.data.put(parameterName, x);
        this.types.put(parameterName, "BOOLEAN");
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.LOGGER.finest("Setting Int for parameterName: " + parameterName);
        this.data.put(parameterName, x);
        this.types.put(parameterName, "INTEGER");
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        if (this.closed) {
            int error_code = 17009;
            throw new SQLException(RestjdbcResources.getString("ORA_17009"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        this.LOGGER.finest("Setting Int for parameterName: " + parameterName);
        this.data.put(parameterName, x);
        this.types.put(parameterName, "NUMBER");
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        if (this.closed) {
            int error_code = 17009;
            throw new SQLException(RestjdbcResources.getString("ORA_17009"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        this.LOGGER.finest("Setting Long with parameterName: " + parameterName);
        this.data.put(parameterName, x);
        this.types.put(parameterName, "NUMBER");
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        if (this.closed) {
            int error_code = 17009;
            throw new SQLException(RestjdbcResources.getString("ORA_17009"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        this.LOGGER.finest("Setting Float with parameterName: " + parameterName);
        this.data.put(parameterName, Float.valueOf(x));
        this.types.put(parameterName, "FLOAT");
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        if (this.closed) {
            int error_code = 17009;
            throw new SQLException(RestjdbcResources.getString("ORA_17009"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        this.LOGGER.finest("Setting Douvle with parameterName: " + parameterName);
        this.data.put(parameterName, x);
        this.types.put(parameterName, "Double");
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        if (this.closed) {
            int error_code = 17009;
            throw new SQLException(RestjdbcResources.getString("ORA_17009"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        this.LOGGER.finest("Setting BigDecimal with parameterName: " + parameterName);
        this.data.put(parameterName, x);
        this.types.put(parameterName, "BIGDECIMAL");
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        if (this.closed) {
            int error_code = 17009;
            throw new SQLException(RestjdbcResources.getString("ORA_17009"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        this.LOGGER.finest("Setting Float with parameterName: " + parameterName);
        this.data.put(parameterName, x);
        this.types.put(parameterName, "STRING");
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        if (this.closed) {
            int error_code = 17009;
            throw new SQLException(RestjdbcResources.getString("ORA_17009"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        this.LOGGER.finest("Setting Date with parameterName: " + parameterName);
        this.data.put(parameterName, this.getFormattedData(x, this.conn, "DATE"));
        this.types.put(parameterName, "DATE");
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.LOGGER.finest("Setting Time with parameterName: " + parameterName);
        this.data.put(parameterName, this.getFormattedData(x, this.conn, "DATE"));
        this.types.put(parameterName, "DATE");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.LOGGER.finest("Setting Timestamp with parameterName: " + parameterName);
        this.data.put(parameterName, this.getFormattedData(x, this.conn, "TIMESTAMP"));
        this.types.put(parameterName, "TIMESTAMP");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        if (x instanceof Boolean) {
            this.setBoolean(parameterName, (boolean)((Boolean)x));
        } else if (x instanceof Integer) {
            this.setInt(parameterName, (int)((Integer)x));
        } else if (x instanceof Short) {
            this.setShort(parameterName, (short)((Short)x));
        } else if (x instanceof Long) {
            this.setLong(parameterName, (long)((Long)x));
        } else if (x instanceof Float) {
            this.setFloat(parameterName, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterName, (double)((Double)x));
        } else if (x instanceof String) {
            this.setString(parameterName, (String)x);
        } else if (x instanceof Date) {
            this.setDate(parameterName, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterName, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterName, (Timestamp)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterName, (BigDecimal)x);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private void processOUTs() {
        String value = "value";
        try {
            for (Object i : this.outTypes.keySet()) {
                this.g.writeStartObject();
                if (i instanceof Integer) {
                    this.g.writeNumberField("index", ((Integer)i).intValue());
                } else if (i instanceof String) {
                    this.g.writeStringField("name", (String)i);
                }
                switch (this.outTypes.get(i)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        this.g.writeStringField("data_type", "NUMBER");
                        break;
                    }
                    case 6: {
                        this.g.writeStringField("data_type", "FLOAT");
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.g.writeStringField("data_type", "VARCHAR");
                        break;
                    }
                    case 91: {
                        this.g.writeStringField("data_type", "DATE");
                        break;
                    }
                    case 92: {
                        this.g.writeStringField("data_type", "TIME");
                        break;
                    }
                    case 93: {
                        this.g.writeStringField("data_type", "TIMESTAMP");
                        break;
                    }
                    case 2004: {
                        this.g.writeStringField("data_type", "BLOB");
                        break;
                    }
                    case 2005: {
                        this.g.writeStringField("data_type", "CLOB");
                        break;
                    }
                    case 16: {
                        this.g.writeStringField("data_type", "BOOLEAN");
                    }
                }
                this.g.writeStringField("mode", "out");
                this.g.writeEndObject();
            }
        }
        catch (Exception e) {
            this.LOGGER.severe("Failure while generating POST\n" + e.getMessage());
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.ensureOpen();
        this.outTypes.put(parameterIndex, sqlType);
        this.outParams = true;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    private void getIndexValidator(Object parameterIndex) throws Exception {
        if (parameterIndex instanceof Integer || parameterIndex instanceof String) {
            if (!this.outTypes.containsKey(parameterIndex)) {
                if (parameterIndex instanceof Integer) {
                    int errorCode = 17310;
                    throw new SQLException(RestjdbcResources.getString("ORA_17310"), SQLStateMapping.getSQLState(errorCode), errorCode);
                }
                if (parameterIndex instanceof String) {
                    int errorCode = 17310;
                    throw new SQLException(RestjdbcResources.getString("RESTJDBC_015"), SQLStateMapping.getSQLState(errorCode), errorCode);
                }
                int errorCode = 17323;
                throw new SQLException(RestjdbcResources.getString("ORA_17323"), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
        } else {
            throw new Exception(Messages.getString((String)"ORA_17001"));
        }
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        String result = null;
        try {
            result = this.extractResult(parameterIndex).findValue("result").asText();
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            int errorCode = 17001;
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return result;
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return false;
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        try {
            this.getIndexValidator(parameterIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17009;
                throw new SQLException(RestjdbcResources.getString("ORA_17009"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            this.getIndexValidator(parameterIndex);
            return Short.parseShort(this.extractResult(parameterIndex).findValue("result").toString());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (Exception e) {
            int error_code = 17001;
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(error_code), error_code);
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            this.getIndexValidator(parameterIndex);
            return Integer.parseInt(this.extractResult(parameterIndex).findValue("result").toString());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (Exception e) {
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            this.getIndexValidator(parameterIndex);
            if (this.extractResult(parameterIndex).findValue("result").canConvertToLong()) {
                return this.extractResult(parameterIndex).findValue("result").longValue();
            }
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (Exception e) {
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            return Float.parseFloat(this.extractResult(parameterIndex).findValue("result").asText());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            return Double.parseDouble(this.extractResult(parameterIndex).findValue("result").asText());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        try {
            return new BigDecimal(this.extractResult(parameterIndex).findValue("result").asText());
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return null;
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            String date_str = this.extractResult(parameterIndex).findValue("result").toString();
            date_str = date_str.substring(1, date_str.length() - 1);
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            java.util.Date date = cal.getTime();
            return new Date(date.getTime());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (IllegalArgumentException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            String date_str = this.extractResult(parameterIndex).findValue("result").asText();
            date_str = date_str.substring(1, date_str.length() - 1);
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            Long timeMillis = cal.getTimeInMillis();
            return new Time(timeMillis);
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (IllegalArgumentException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            String date_str = this.extractResult(parameterIndex).findValue("result").asText();
            date_str = date_str.substring(1, date_str.length() - 1);
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            Long timeMillis = cal.getTimeInMillis();
            Timestamp timeStamp = new Timestamp(timeMillis);
            String nano = null;
            if (date_str.contains(".")) {
                if (date_str.contains("Z")) {
                    nano = date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(90));
                    return timeStamp;
                }
                nano = date_str.contains("+") ? date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(43)) : (date_str.lastIndexOf(45) > 10 ? date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(45)) : date_str.substring(date_str.indexOf(".") + 1));
                String padded_nano = String.format("%-9d", Integer.parseInt(nano)).replace(' ', '0');
                timeStamp.setNanos(Integer.parseInt(padded_nano));
                return timeStamp;
            }
            return timeStamp;
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (IllegalArgumentException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
    }

    private Object getObjectHelper(Object parameterIndex) throws SQLException {
        block24: {
            try {
                if (this.closed) {
                    int error_code = 17010;
                    throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
                }
                String type = this.extractResult(parameterIndex).findValue("data_type").asText();
                if (type.contains("NUMBER")) {
                    int number = this.extractResult(parameterIndex).findValue("result").asInt();
                    return number;
                }
                if (type.contains("BINARY_DOUBLE")) {
                    double binary_double = Double.parseDouble(this.extractResult(parameterIndex).findValue("result").asText());
                    return binary_double;
                }
                if (type.contains("BINARY_FLOAT")) {
                    float binary_float = Float.parseFloat(this.extractResult(parameterIndex).findValue("result").asText());
                    return Float.valueOf(binary_float);
                }
                if (type.contains("LONG")) {
                    long long_value = Long.parseLong(this.extractResult(parameterIndex).findValue("result").asText());
                    return long_value;
                }
                if (type.contains("CHAR")) {
                    String char_value = this.extractResult(parameterIndex).findValue("result").asText();
                    return char_value;
                }
                if (type.contains("VARCHAR")) {
                    String varchar_value = this.extractResult(parameterIndex).findValue("result").asText();
                    return varchar_value;
                }
                if (type.contains("VARCHAR2")) {
                    String varchar2_value = this.extractResult(parameterIndex).findValue("result").asText();
                    return varchar2_value;
                }
                if (type.contains("DATE")) {
                    if (parameterIndex instanceof Integer) {
                        Date date_value = this.getDate((Integer)parameterIndex);
                        return date_value;
                    }
                    if (parameterIndex instanceof String) {
                        Date date_value = this.getDate((String)parameterIndex);
                        return date_value;
                    }
                } else if (type.contains("TIMESTAMP")) {
                    if (parameterIndex instanceof Integer) {
                        Timestamp timestamp_value = this.getTimestamp((Integer)parameterIndex);
                        return timestamp_value;
                    }
                    if (parameterIndex instanceof String) {
                        Timestamp timestamp_value = this.getTimestamp((String)parameterIndex);
                        return timestamp_value;
                    }
                } else if (type.contains("TIME")) {
                    if (parameterIndex instanceof Integer) {
                        Time time_value = this.getTime((Integer)parameterIndex);
                        return time_value;
                    }
                    if (parameterIndex instanceof String) {
                        Time time_value = this.getTime((String)parameterIndex);
                        return time_value;
                    }
                }
            }
            catch (NullPointerException ne) {
                if (ne.getMessage() != null) {
                    this.LOGGER.log(Level.SEVERE, ne.getMessage());
                }
                int error_code = 17003;
                throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            catch (NumberFormatException e) {
                int error_code = 17004;
                throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            catch (SQLException e) {
                if (e.getMessage() == null) break block24;
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17005"), SQLStateMapping.getSQLState(17005), 17005);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        try {
            this.getIndexValidator(parameterIndex);
            Object obj = this.getObjectHelper(parameterIndex);
            return obj;
        }
        catch (Exception e) {
            throw new SQLException(RestjdbcResources.getString("ORA_17005"), SQLStateMapping.getSQLState(17005), 17005);
        }
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.ensureOpen();
        this.outTypes.put(parameterName, sqlType);
        this.outParams = true;
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        String result = null;
        try {
            result = this.extractResult(parameterName).findValue("result").asText();
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            int errorCode = 17001;
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return result;
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        try {
            this.getIndexValidator(parameterName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonNode value = this.outResp.get(parameterName).get("result");
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        throw new SQLException(Messages.getString((String)"RESTJDBC_012"));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return 0;
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            this.getIndexValidator(parameterName);
            return Short.parseShort(this.extractResult(parameterName).findValue("result").toString());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (Exception e) {
            int error_code = 17001;
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(error_code), error_code);
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            this.getIndexValidator(parameterName);
            return Integer.parseInt(this.extractResult(parameterName).findValue("result").toString());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (Exception e) {
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            this.getIndexValidator(parameterName);
            if (this.extractResult(parameterName).findValue("result").canConvertToLong()) {
                return this.extractResult(parameterName).findValue("result").longValue();
            }
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (Exception e) {
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            return Float.parseFloat(this.extractResult(parameterName).findValue("result").asText());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            return Double.parseDouble(this.extractResult(parameterName).findValue("result").asText());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (NumberFormatException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            String date_str = this.extractResult(parameterName).findValue("result").toString();
            date_str = date_str.substring(1, date_str.length() - 1);
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            java.util.Date date = cal.getTime();
            return new Date(date.getTime());
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (IllegalArgumentException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            String date_str = this.extractResult(parameterName).findValue("result").asText();
            date_str = date_str.substring(1, date_str.length() - 1);
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            Long timeMillis = cal.getTimeInMillis();
            return new Time(timeMillis);
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (IllegalArgumentException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        try {
            if (this.closed) {
                int error_code = 17010;
                throw new SQLException(RestjdbcResources.getString("ORA_17010"), SQLStateMapping.getSQLState(error_code), error_code);
            }
            String date_str = this.extractResult(parameterName).findValue("result").asText();
            date_str = date_str.substring(1, date_str.length() - 1);
            Calendar cal = DatatypeConverter.parseDateTime((String)date_str);
            Long timeMillis = cal.getTimeInMillis();
            Timestamp timeStamp = new Timestamp(timeMillis);
            String nano = null;
            if (date_str.contains(".")) {
                if (date_str.contains("Z")) {
                    nano = date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(90));
                    return timeStamp;
                }
                nano = date_str.contains("+") ? date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(43)) : (date_str.lastIndexOf(45) > 10 ? date_str.substring(date_str.indexOf(".") + 1, date_str.lastIndexOf(45)) : date_str.substring(date_str.indexOf(".") + 1));
                String padded_nano = String.format("%-9d", Integer.parseInt(nano)).replace(' ', '0');
                timeStamp.setNanos(Integer.parseInt(padded_nano));
                return timeStamp;
            }
            return timeStamp;
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int error_code = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        catch (SQLException e) {
            if (e.getMessage() != null) {
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        catch (IllegalArgumentException e) {
            int error_code = 17004;
            throw new SQLException(RestjdbcResources.getString("ORA_17004"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17001"), SQLStateMapping.getSQLState(17001), 17001);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        try {
            this.getIndexValidator(parameterName);
            Object obj = this.getObjectHelper(parameterName);
            return obj;
        }
        catch (Exception e) {
            throw new SQLException(RestjdbcResources.getString("ORA_17005"), SQLStateMapping.getSQLState(17005), 17005);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        try {
            this.getIndexValidator(parameterName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonNode value = this.outResp.get(parameterName).get("result");
        if (value.isNumber()) {
            return value.decimalValue();
        }
        throw new SQLException(Messages.getString((String)"RESTJDBC_012"));
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return null;
    }
}

