/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import oracle.bali.xml.dom.DomModel;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.util.SwingClosure;
import oracle.jdeveloper.xml.DomIO;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class TextBufferDomIO
extends DomIO {
    private final TextBuffer _buffer;
    private final URL _bufferURL;

    public TextBufferDomIO(TextBuffer buffer, URL bufferURL) {
        this._buffer = buffer;
        this._bufferURL = bufferURL;
    }

    @Override
    public Document load() throws IOException {
        Reader reader = TextBufferFactory.createReader((ReadTextBuffer)this._buffer);
        return TextBufferDomIO.loadImpl(null, reader, this._bufferURL);
    }

    @Override
    public void save(final Document doc) throws IOException {
        TextBufferDomIO.runSwingClosure(new SwingClosure(false){

            protected void runImpl() throws Exception {
                if (!TextBufferDomIO.this.tryDumpBufferDomModel(doc, TextBufferDomIO.this._buffer)) {
                    TextBufferDomIO.this.dumpToTextBuffer(doc, TextBufferDomIO.this._buffer);
                }
            }
        });
    }

    private boolean tryDumpBufferDomModel(Document doc, TextBuffer targetBuffer) throws IOException {
        if (doc instanceof XMLDocument) {
            XMLDocument xmlDoc = (XMLDocument)doc;
            Object textBufferCopyObj = xmlDoc.getUserData("text-buffer-copy");
            Object domModelCopyObj = xmlDoc.getUserData("dom-model-copy");
            if (textBufferCopyObj != null && domModelCopyObj != null) {
                TextBuffer textBufferCopy = (TextBuffer)textBufferCopyObj;
                DomModel domModelCopy = (DomModel)domModelCopyObj;
                domModelCopy.commitTransaction();
                domModelCopy.startTransaction("internal");
                TextBufferDomIO.dumpToTextBuffer(textBufferCopy, targetBuffer);
                return true;
            }
        }
        return false;
    }

    private void dumpToTextBuffer(Document doc, TextBuffer buffer) throws IOException {
        CharArrayWriter writer = this.getCharArrayWriter(doc);
        TextBufferDomIO.dumpToTextBuffer(writer.toCharArray(), this._buffer);
    }

    private static void dumpToTextBuffer(TextBuffer srcBuffer, TextBuffer dstBuffer) {
        TextBufferDomIO.dumpToTextBuffer(srcBuffer.getChars(0, srcBuffer.getLength()), dstBuffer);
    }

    private static void dumpToTextBuffer(char[] chars, TextBuffer buffer) {
        try {
            buffer.beginEdit();
            buffer.removeToEnd(0);
            buffer.insert(0, chars);
        }
        finally {
            buffer.endEdit();
        }
    }
}

