/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.io.IOException;
import java.io.Writer;
import oracle.xml.differ.DiffGenerator;
import oracle.xml.differ.DiffTreeNode;
import oracle.xml.differ.ModifiedDiffTreeNode;
import oracle.xml.differ.MoveBlankDiffTreeNode;
import oracle.xml.differ.XSLDiffGenerator;
import oracle.xml.parser.v2.XMLDocument;

class DiffGeneratorManager
implements DiffGenerator {
    DiffGenerator[] m_genlist = new DiffGenerator[1];
    int m_lastset = 0;
    static final int MAXGENERATORS = 1;
    protected static final short XSLGEN = 1;
    protected static final short FILEOUT = 1;
    private int m_xslgenset = -1;

    protected DiffGeneratorManager() {
    }

    protected void setGenerator(short s, Writer writer) throws IOException {
        switch (s) {
            case 1: {
                this.m_genlist[this.m_lastset] = new XSLDiffGenerator(writer);
                this.m_xslgenset = this.m_lastset;
                break;
            }
            default: {
                this.m_genlist[this.m_lastset] = new XSLDiffGenerator(writer);
            }
        }
        ++this.m_lastset;
    }

    @Override
    public void setIndentIncr(int n) {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].setIndentIncr(n);
        }
    }

    @Override
    public void setNewNodeIndentIncr(int n) {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].setNewNodeIndentIncr(n);
        }
    }

    @Override
    public void setDelWSBeforeDeletes(boolean bl) {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].setDelWSBeforeDeletes(bl);
        }
    }

    protected void generateDiffs(DiffTreeNode diffTreeNode) throws IOException {
        if (this.m_xslgenset >= 0) {
            XMLDocument xMLDocument = (XMLDocument)diffTreeNode.getNodeObject();
            ((XSLDiffGenerator)this.m_genlist[this.m_xslgenset]).setDocument(xMLDocument);
        }
        this.startDiffGeneration();
        this.generateOperation((DiffTreeNode)diffTreeNode.getFirstChild());
        this.endDiffGeneration();
    }

    protected void generateOperation(DiffTreeNode diffTreeNode) throws IOException {
        block7: while (diffTreeNode != null && !diffTreeNode.isRoot()) {
            DiffTreeNode diffTreeNode2;
            switch (diffTreeNode.getDiffType()) {
                case 0: {
                    this.batchInsert(diffTreeNode);
                    diffTreeNode = (DiffTreeNode)diffTreeNode.getNextNode();
                    continue block7;
                }
                case 1: {
                    this.deleteNode(diffTreeNode);
                    break;
                }
                case 2: {
                    this.insertNode(diffTreeNode);
                    break;
                }
                case 3: {
                    diffTreeNode2 = ((MoveBlankDiffTreeNode)diffTreeNode).getMovedNode();
                    this.moveNode(diffTreeNode2, diffTreeNode);
                    break;
                }
                case 4: {
                    ModifiedDiffTreeNode modifiedDiffTreeNode = ((ModifiedDiffTreeNode)diffTreeNode).getModifiedNode();
                    this.modifyNode(diffTreeNode, modifiedDiffTreeNode);
                }
            }
            if (diffTreeNode.getNodeObject().getNodeType() == 1) {
                while ((diffTreeNode2 = (DiffTreeNode)diffTreeNode.getNextSibling()) == null && !diffTreeNode.isRoot()) {
                    diffTreeNode = (DiffTreeNode)diffTreeNode.getParent();
                }
                if (diffTreeNode2 != null) {
                    diffTreeNode = diffTreeNode2;
                }
                if (!diffTreeNode.isRoot()) continue;
                break;
            }
            diffTreeNode = (DiffTreeNode)diffTreeNode.getNextNode();
        }
        this.batchInsert(diffTreeNode);
    }

    @Override
    public void startDiffGeneration() throws IOException {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].startDiffGeneration();
        }
    }

    @Override
    public void endDiffGeneration() throws IOException {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].endDiffGeneration();
        }
    }

    @Override
    public void insertNode(DiffTreeNode diffTreeNode) throws IOException {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].insertNode(diffTreeNode);
        }
    }

    @Override
    public void deleteNode(DiffTreeNode diffTreeNode) throws IOException {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].deleteNode(diffTreeNode);
        }
    }

    @Override
    public void moveNode(DiffTreeNode diffTreeNode, DiffTreeNode diffTreeNode2) throws IOException {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].moveNode(diffTreeNode, diffTreeNode2);
        }
    }

    @Override
    public void modifyNode(DiffTreeNode diffTreeNode, DiffTreeNode diffTreeNode2) throws IOException {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].modifyNode(diffTreeNode, diffTreeNode2);
        }
    }

    @Override
    public void batchInsert(DiffTreeNode diffTreeNode) throws IOException {
        for (int i = 0; i < this.m_lastset; ++i) {
            this.m_genlist[i].batchInsert(diffTreeNode);
        }
    }
}

