/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.WeakHashMap;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.SQLUtil;
import sqlj.runtime.ResultSetIterator;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.ref.OraRTResultSet;
import sqlj.runtime.ref.ResultSetIterImpl;

class T2SConversions {
    static final OracleDriver driver = new OracleDriver();
    private static boolean DEBUG = false;
    private static final WeakHashMap knownResultSets = new WeakHashMap(10);

    T2SConversions() {
    }

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public static boolean setDEBUG(boolean newValue) {
        boolean ret = DEBUG;
        DEBUG = newValue;
        return ret;
    }

    private static String dumpbytearray(byte[] a) {
        String ret;
        if (a == null) {
            ret = "null byte[]";
        } else {
            ret = a + " length: " + a.length + " contents: [" + a[0];
            for (int i = 1; i < a.length; ++i) {
                ret = ret + ", " + a[i];
            }
            ret = ret + "]";
        }
        return ret;
    }

    public static Object[] makeOne(byte[] sqlData, int sqlType, String sqlTypeName, Class targetClazz) {
        if (DEBUG) {
            System.out.println("makeOne: " + T2SConversions.dumpbytearray(sqlData) + " " + sqlType + " " + sqlTypeName + " " + targetClazz);
        }
        boolean methodNotFound = true;
        try {
            if (sqlData == null) {
                return T2SConversions.wrapObject(null);
            }
            OracleConnection connection = (OracleConnection)driver.defaultConnection();
            if (T2SConversions.implementsInterface(targetClazz, ORAData.class)) {
                ORADataFactory f;
                Method method;
                try {
                    method = targetClazz.getMethod("getORADataFactory", new Class[0]);
                    methodNotFound = false;
                    f = (ORADataFactory)method.invoke(null, new Object[0]);
                    if (f != null) {
                        return T2SConversions.wrapObject(SQLUtil.SQLToJava((OracleConnection)connection, (byte[])sqlData, (int)sqlType, (String)sqlTypeName, (ORADataFactory)f));
                    }
                }
                catch (Exception e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    methodNotFound = true;
                }
                if (methodNotFound) {
                    try {
                        method = targetClazz.getMethod("getFactory", new Class[0]);
                        methodNotFound = false;
                        f = (ORADataFactory)method.invoke(null, new Object[0]);
                        if (f != null) {
                            return T2SConversions.wrapObject(SQLUtil.SQLToJava((OracleConnection)connection, (byte[])sqlData, (int)sqlType, (String)sqlTypeName, (ORADataFactory)f));
                        }
                    }
                    catch (Exception e) {
                        if (DEBUG) {
                            e.printStackTrace();
                        }
                        methodNotFound = true;
                    }
                }
                return null;
            }
            if (T2SConversions.implementsInterface(targetClazz, CustomDatum.class)) {
                CustomDatumFactory f;
                Method method;
                try {
                    method = targetClazz.getMethod("getFactory", new Class[0]);
                    methodNotFound = false;
                    f = (CustomDatumFactory)method.invoke(null, new Object[0]);
                    if (f != null) {
                        return T2SConversions.wrapObject(SQLUtil.SQLToJava((OracleConnection)connection, (byte[])sqlData, (int)sqlType, (String)sqlTypeName, (CustomDatumFactory)f));
                    }
                }
                catch (Exception e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    methodNotFound = true;
                }
                if (methodNotFound) {
                    try {
                        method = targetClazz.getMethod("getCustomDatumFactory", new Class[0]);
                        methodNotFound = false;
                        f = (CustomDatumFactory)method.invoke(null, new Object[0]);
                        if (f != null) {
                            return T2SConversions.wrapObject(SQLUtil.SQLToJava((OracleConnection)connection, (byte[])sqlData, (int)sqlType, (String)sqlTypeName, (CustomDatumFactory)f));
                        }
                    }
                    catch (Exception e) {
                        if (DEBUG) {
                            e.printStackTrace();
                        }
                        methodNotFound = true;
                    }
                }
                return null;
            }
            return T2SConversions.wrapObject(SQLUtil.SQLToJava((OracleConnection)connection, (byte[])sqlData, (int)sqlType, (String)sqlTypeName, (Class)targetClazz, null));
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Object[] wrapObject(Object object) {
        if (DEBUG) {
            System.out.println("wrapObject makeOne returns: " + (object == null ? "<null>" : object.getClass().toString()));
        }
        Object[] result = new Object[]{object};
        return result;
    }

    public static byte[][] getOne(Object object, int sqlType, String sqlTypeName) {
        if (DEBUG) {
            System.out.println("getOne: " + (object == null ? object : object.getClass()) + " " + sqlType + " " + sqlTypeName);
        }
        try {
            if (object == null) {
                return T2SConversions.wrapBytes(null);
            }
            return T2SConversions.wrapBytes(SQLUtil.JavaToSQL((OracleConnection)((OracleConnection)driver.defaultConnection()), object, (int)sqlType, (String)sqlTypeName));
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static byte[][] wrapBytes(byte[] bytes) {
        if (DEBUG) {
            System.out.println("getOne returns: " + T2SConversions.dumpbytearray(bytes));
        }
        byte[][] result = new byte[][]{bytes};
        return result;
    }

    public static boolean implementsInterface(Class clazz, Class interfaze) {
        if (clazz == null) {
            return false;
        }
        if (clazz == interfaze) {
            return true;
        }
        Class<?>[] interfazes = clazz.getInterfaces();
        for (int i = 0; i < interfazes.length; ++i) {
            if (!T2SConversions.implementsInterface(interfazes[i], interfaze)) continue;
            return true;
        }
        return T2SConversions.implementsInterface(clazz.getSuperclass(), interfaze);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int returnCursor(ResultSet rs) {
        int curNum = -1;
        if (rs == null) {
            curNum = 0;
        } else {
            WeakHashMap weakHashMap = knownResultSets;
            synchronized (weakHashMap) {
                Integer curHolder = (Integer)knownResultSets.get(rs);
                if (curHolder == null) {
                    try {
                        OracleStatement stmt = ((OracleResultSet)rs).getOracleStatement();
                        if (stmt != null && stmt.getserverCursor()) {
                            curNum = stmt.getResultSet() == rs ? stmt.cursorIfRefCursor() : -2;
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    knownResultSets.put(rs, new Integer(curNum));
                } else {
                    curNum = curHolder;
                }
            }
        }
        return curNum;
    }

    public static ResultSet createResultSet(int curNum) {
        ResultSet rset = null;
        if (curNum > 0) {
            try {
                rset = ((OracleConnection)driver.defaultConnection()).refCursorCursorToStatement(curNum).getResultSet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rset;
    }

    public static ResultSetIterator createResultSetIter(int curNum) {
        ResultSetIterImpl riter = null;
        if (curNum > 0) {
            ResultSet rset = T2SConversions.createResultSet(curNum);
            try {
                riter = new ResultSetIterImpl((RTResultSet)new OraRTResultSet(rset));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return riter;
    }

    public static int returnCursor(Object obj) {
        int curNum = -1;
        if (obj != null) {
            try {
                if (obj instanceof ResultSet) {
                    curNum = T2SConversions.returnCursor((ResultSet)obj);
                } else if (obj instanceof ResultSetIterator) {
                    curNum = T2SConversions.returnCursor((ResultSetIterator)obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return curNum;
    }

    public static int returnCursor(ResultSetIterator obj) {
        int curNum = -1;
        if (obj != null) {
            try {
                if (obj.getClass().getField("returnability").getBoolean(null)) {
                    curNum = T2SConversions.returnCursor(obj.getResultSet());
                }
            }
            catch (NoSuchFieldException nsfe) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (NullPointerException npe) {
            }
            catch (ClassCastException cce) {
            }
            catch (SecurityException se) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return curNum;
    }
}

