/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.vm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.net.URL;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import java.util.Locale;
import oracle.aurora.vm.CachedLocales;
import oracle.aurora.vm.IUClassLoader;
import oracle.aurora.vm.IUHandle;
import sun.misc.Resource;
import sun.security.provider.PolicyFile;

public abstract class EnvironmentSpecific {
    protected static EnvironmentSpecific impl;
    private static boolean donebootstrapping;
    public static Object dontCopyConstructor;
    public static String environmentName;
    private static final Object theUninitializedSecurityManager;
    private static Object theSecurityManager;
    private static String[] thebootstrapResourceClassPath;
    public static final int LoginSchema = -3;
    public static final int CurrentSchema = -2;
    public static final int PublicSchema = 1;

    private static EnvironmentSpecific impl() {
        if (impl == null) {
            environmentName = System.getProperty("oracle.aurora.vm.environment.name", "oracle.aurora.vm.environment.name_PROPERTY_NOT_SET");
            if (impl == null) {
                impl = (EnvironmentSpecific)EnvironmentSpecific.safeNewInstance("EnvironmentSpecificImpl");
            }
        }
        return impl;
    }

    private static Class safeForName(String name) {
        try {
            return Class.forName("oracle.aurora." + environmentName + "." + name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Object safeNewInstance(String name) {
        Class c = EnvironmentSpecific.safeForName(name);
        if (c != null) {
            try {
                return c.newInstance();
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected String normalizeFileEncodingImpl(String unnormalized) {
        return unnormalized;
    }

    public static String normalizeFileEncoding(String unnormalized) {
        String result = unnormalized;
        if (EnvironmentSpecific.impl() != null) {
            result = impl.normalizeFileEncodingImpl(unnormalized);
        }
        return result;
    }

    protected abstract IUHandle lookupIUHandleImpl(String var1, int var2, Class var3, Object var4);

    public static IUHandle lookupIUHandle(String name, int type, Class forClass, Object extraInfo) {
        return EnvironmentSpecific.impl() == null ? null : impl.lookupIUHandleImpl(name, type, forClass, extraInfo);
    }

    public static IUHandle lookupIUHandle(String name, int type, Class forClass) {
        return EnvironmentSpecific.impl() == null ? null : impl.lookupIUHandleImpl(name, type, forClass, null);
    }

    protected abstract int lookupIUHandleForCompilerImpl(String var1, boolean var2, boolean var3, IUHandle var4, IUHandle[] var5);

    public static int lookupIUHandleForCompiler(String fullName, boolean derivedp, boolean sourcep, IUHandle refFromHandle, IUHandle[] foundHandle) {
        return EnvironmentSpecific.impl() == null ? -1 : impl.lookupIUHandleForCompilerImpl(fullName, derivedp, sourcep, refFromHandle, foundHandle);
    }

    protected abstract SecurityManager securityManagerImpl();

    public static SecurityManager securityManager() {
        if (theSecurityManager == theUninitializedSecurityManager) {
            theSecurityManager = EnvironmentSpecific.impl() == null ? null : impl.securityManagerImpl();
        }
        return (SecurityManager)theSecurityManager;
    }

    protected Policy getPolicyTableImpl(Policy p) {
        return p;
    }

    public static Policy getPolicyTable(Policy p) {
        return EnvironmentSpecific.impl() == null ? p : impl.getPolicyTableImpl(p);
    }

    protected void setStaticPermissionFlagImpl(Policy p) {
        ProtectionDomain.setStaticPermissionsFlag((p != null && p instanceof PolicyFile && ((PolicyFile)p).isBoot() ? 1 : 0) != 0);
    }

    public static void setStaticPermissionFlag(Policy p) {
        if (EnvironmentSpecific.impl() != null) {
            impl.setStaticPermissionFlagImpl(p);
        }
    }

    protected void checkCanDebugImpl() {
    }

    public static void checkCanDebug() {
        if (EnvironmentSpecific.impl() != null) {
            impl.checkCanDebugImpl();
        }
    }

    protected InputStream sourceInputStreamImpl(Class cl) throws IOException {
        throw new IOException("sourceInputStream not implemented");
    }

    public static InputStream sourceInputStream(Class cl) throws IOException {
        return EnvironmentSpecific.impl() == null ? null : impl.sourceInputStreamImpl(cl);
    }

    protected Locale getDefaultLocaleImpl() {
        return null;
    }

    public static Locale getDefaultLocale() {
        return EnvironmentSpecific.impl() == null ? null : impl.getDefaultLocaleImpl();
    }

    protected void setDefaultLocaleImpl(Locale locale) {
    }

    public static void setDefaultLocale(Locale locale) {
        if (EnvironmentSpecific.impl() != null) {
            impl.setDefaultLocaleImpl(locale);
        }
    }

    protected abstract String[] bootstrapResourceClassPathImpl();

    public static String[] bootstrapResourceClassPath() {
        if (thebootstrapResourceClassPath == null) {
            thebootstrapResourceClassPath = EnvironmentSpecific.impl() == null ? null : impl.bootstrapResourceClassPathImpl();
        }
        return thebootstrapResourceClassPath;
    }

    protected Class classFromURLResourceImpl(Resource res) throws ClassNotFoundException {
        return null;
    }

    public static Class classFromURLResource(Resource res) throws ClassNotFoundException {
        return EnvironmentSpecific.impl() == null ? null : impl.classFromURLResourceImpl(res);
    }

    protected ClassLoader assignClassLoaderImpl(Class c) {
        return null;
    }

    private static ClassLoader assignClassLoader(Class c) {
        return EnvironmentSpecific.impl() == null ? null : impl.assignClassLoaderImpl(c);
    }

    protected ClassLoader getSystemClassLoaderImpl(ClassLoader scl, ClassLoader pscl) {
        return null;
    }

    public static ClassLoader getSystemClassLoader(ClassLoader scl, ClassLoader pscl) {
        return EnvironmentSpecific.impl() == null ? null : impl.getSystemClassLoaderImpl(scl, pscl);
    }

    public static IUHandle findClassHandle(String name, IUClassLoader loader) {
        return loader.findClassHandle(name);
    }

    protected Class ownerProtectionDomainImpl() {
        return null;
    }

    public static Class ownerProtectionDomain() {
        return EnvironmentSpecific.impl() == null ? null : impl.ownerProtectionDomainImpl();
    }

    protected Class fabricateProtectionDomainImpl() {
        return null;
    }

    public static Class fabricateProtectionDomain() {
        return EnvironmentSpecific.impl() == null ? null : impl.fabricateProtectionDomainImpl();
    }

    protected String instructionsForImpl(ProtectionDomain d, Permission p) {
        return null;
    }

    public static String instructionsFor(ProtectionDomain d, Permission p) {
        return EnvironmentSpecific.impl() == null ? null : impl.instructionsForImpl(d, p);
    }

    protected Class classForNameAndSchemaImpl(String className, String schemaName) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static Class classForNameAndSchema(String className, String schemaName) throws ClassNotFoundException {
        return EnvironmentSpecific.impl() == null ? null : impl.classForNameAndSchemaImpl(className, schemaName);
    }

    protected Class classForNameAndSchemaImpl(String className, int schemaIndicator) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static Class classForNameAndSchema(String className, int schemaIndicator) throws ClassNotFoundException {
        return EnvironmentSpecific.impl() == null ? null : impl.classForNameAndSchemaImpl(className, schemaIndicator);
    }

    protected Class classForNameAndSchemaImpl(String className, int schemaIndicator, int alternateSchemaIndicator) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static Class classForNameAndSchema(String className, int schemaIndicator, int alternateSchemaIndicator) throws ClassNotFoundException {
        return EnvironmentSpecific.impl() == null ? null : impl.classForNameAndSchemaImpl(className, schemaIndicator, alternateSchemaIndicator);
    }

    protected int ownerIDImpl(Class cl) {
        return -1;
    }

    public static int ownerID(Class cl) {
        return EnvironmentSpecific.impl() == null ? -1 : impl.ownerIDImpl(cl);
    }

    protected Hashtable CLDKeyGetRootImpl(String name, int ownerID) {
        return null;
    }

    public static Hashtable CLDKeyGetRoot(String name, int ownerID) {
        return EnvironmentSpecific.impl() == null ? null : impl.CLDKeyGetRootImpl(name, ownerID);
    }

    protected boolean CLDKeySaveImpl(String name, int ownerID, Hashtable hash) {
        return true;
    }

    public static boolean CLDKeySave(String name, int ownerID, Hashtable hash) {
        return EnvironmentSpecific.impl() == null ? true : impl.CLDKeySaveImpl(name, ownerID, hash);
    }

    protected boolean CLDKeyRemoveImpl(String name, int ownerID) {
        return true;
    }

    public static boolean CLDKeyRemove(String name, int ownerID) {
        return EnvironmentSpecific.impl() == null ? true : impl.CLDKeyRemoveImpl(name, ownerID);
    }

    protected IUHandle getMethodToJitImpl(int methodNumber, int[] methodIndices, Member[] methodObjects) {
        return null;
    }

    public static IUHandle getMethodToJit(int methodNumber, int[] methodIndices, Member[] methodObjects) {
        return EnvironmentSpecific.impl() == null ? null : impl.getMethodToJitImpl(methodNumber, methodIndices, methodObjects);
    }

    protected void populateURLHandlersImpl(Hashtable handlers) {
    }

    public static void populateURLHandlers(Hashtable handlers) {
        if (EnvironmentSpecific.impl() != null) {
            impl.populateURLHandlersImpl(handlers);
        }
    }

    protected void initForHotLoadingImpl() {
    }

    public static void initForHotLoading() {
        if (EnvironmentSpecific.impl() != null) {
            impl.initForHotLoadingImpl();
        }
    }

    protected void initializeOracleDriverImpl() {
    }

    public static void initializeOracleDriver() {
        if (EnvironmentSpecific.impl() != null) {
            impl.initializeOracleDriverImpl();
        }
    }

    protected String rjbcNormalizeImpl(String p) {
        return p;
    }

    public static String rjbcNormalize(String p) {
        return EnvironmentSpecific.impl() != null ? impl.rjbcNormalizeImpl(p) : p;
    }

    protected boolean initSecurityFromResourceImpl() {
        return false;
    }

    public static boolean initSecurityFromResource() {
        return EnvironmentSpecific.impl() != null ? impl.initSecurityFromResourceImpl() : false;
    }

    public static CachedLocales getCachedLocales() {
        return impl.cachedLocalesData();
    }

    public static CachedLocales getCachedLocales(String name) {
        return impl.cachedLocalesData(name);
    }

    public static CachedLocales getCachedLocales(String prefix, String name) {
        return impl.cachedLocalesData(prefix, name);
    }

    public abstract CachedLocales cachedLocalesData();

    public abstract CachedLocales cachedLocalesData(String var1);

    public abstract CachedLocales cachedLocalesData(String var1, String var2);

    public static boolean getInBootStrap() {
        return !donebootstrapping;
    }

    public static void setDoneBootStrap() {
        donebootstrapping = true;
    }

    protected abstract URL getPerhapsTransformedURLImpl(Resource var1, boolean var2);

    public static URL getPerhapsTransformedURL(Resource res, boolean mustBeBootstrap) {
        return EnvironmentSpecific.impl() == null ? res.getURL() : impl.getPerhapsTransformedURLImpl(res, mustBeBootstrap);
    }

    static {
        donebootstrapping = false;
        dontCopyConstructor = null;
        theSecurityManager = theUninitializedSecurityManager = "notyet";
    }
}

