/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import oracle.aurora.util.classfile.ClassFile;
import oracle.aurora.util.classfile.ClassPathEntry;

public class ClassPath {
    static final char dirSeparator = File.pathSeparatorChar;
    String pathstr;
    private ClassPathEntry[] path;
    private final String fileSeparatorChar = "" + File.separatorChar;

    public ClassPath(String pathstr) {
        this.init(pathstr);
    }

    public ClassPath() {
        String syscp = System.getProperty("sun.boot.class.path");
        String cp = null;
        if (syscp == null) {
            cp = System.getProperty("java.class.path");
            if (cp == null) {
                cp = ".";
            }
        } else {
            String envcp = System.getProperty("env.class.path");
            if (envcp == null) {
                envcp = ".";
            }
            cp = syscp + File.pathSeparator + envcp;
        }
        this.init(cp);
    }

    private void init(String pathstr) {
        this.pathstr = pathstr;
        if (pathstr.length() == 0) {
            this.path = new ClassPathEntry[0];
        }
        int n = 0;
        int i = 0;
        while ((i = pathstr.indexOf(dirSeparator, i)) != -1) {
            ++n;
            ++i;
        }
        ClassPathEntry[] path = new ClassPathEntry[n + 1];
        int len = pathstr.length();
        n = 0;
        i = 0;
        while (i < len) {
            int j = pathstr.indexOf(dirSeparator, i);
            if (j == -1) {
                j = len;
            }
            if (i == j) {
                path[n] = new ClassPathEntry();
                path[n++].dir = new File(".");
            } else {
                File file = new File(pathstr.substring(i, j));
                if (file.isFile()) {
                    try {
                        ZipFile zip = new ZipFile(file);
                        path[n] = new ClassPathEntry();
                        path[n++].zip = zip;
                    }
                    catch (ZipException e) {
                    }
                    catch (IOException e) {}
                } else {
                    path[n] = new ClassPathEntry();
                    path[n++].dir = file;
                }
            }
            i = j + 1;
        }
        this.path = new ClassPathEntry[n];
        System.arraycopy(path, 0, this.path, 0, n);
    }

    public ClassFile getDirectory(String name) {
        return this.getFile(name, true);
    }

    public ClassFile getFile(String name) {
        return this.getFile(name, false);
    }

    private ClassFile getFile(String name, boolean isDirectory) {
        int i;
        String subdir = name;
        String basename = "";
        if (!isDirectory) {
            i = name.lastIndexOf(File.separatorChar);
            subdir = name.substring(0, i + 1);
            basename = name.substring(i + 1);
        } else if (!subdir.equals("") && !subdir.endsWith(this.fileSeparatorChar)) {
            name = subdir = subdir + File.separatorChar;
        }
        for (i = 0; i < this.path.length; ++i) {
            if (this.path[i].zip != null) {
                String newname = name.replace(File.separatorChar, '/');
                ZipEntry entry = this.path[i].zip.getEntry(newname);
                if (entry == null) continue;
                return new ClassFile(this.path[i].zip, entry);
            }
            File file = new File(this.path[i].dir.getPath(), name);
            String[] list = this.path[i].getFiles(subdir);
            if (isDirectory) {
                if (list.length <= 0) continue;
                return new ClassFile(file);
            }
            for (int j = 0; j < list.length; ++j) {
                if (!basename.equals(list[j])) continue;
                return new ClassFile(file);
            }
        }
        return null;
    }

    public Enumeration getFiles(String pkg, String ext) {
        Hashtable<String, ClassFile> files = new Hashtable<String, ClassFile>();
        int i = this.path.length;
        while (--i >= 0) {
            String name;
            if (this.path[i].zip != null) {
                Enumeration<? extends ZipEntry> e = this.path[i].zip.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    name = entry.getName();
                    if (!(name = name.replace('/', File.separatorChar)).startsWith(pkg) || !name.endsWith(ext)) continue;
                    files.put(name, new ClassFile(this.path[i].zip, entry));
                }
                continue;
            }
            String[] list = this.path[i].getFiles(pkg);
            for (int j = 0; j < list.length; ++j) {
                name = list[j];
                if (!name.endsWith(ext)) continue;
                name = pkg + File.separatorChar + name;
                File file = new File(this.path[i].dir.getPath(), name);
                files.put(name, new ClassFile(file));
            }
        }
        return files.elements();
    }

    public void close() throws IOException {
        int i = this.path.length;
        while (--i >= 0) {
            if (this.path[i].zip == null) continue;
            this.path[i].zip.close();
        }
    }

    public String toString() {
        return this.pathstr;
    }
}

