/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.aurora.util.QExternalizable;

public class QObjectOutputStream
extends DataOutputStream {
    protected ByteArrayOutputStream baos;
    protected DataOutputStream dOut;
    protected byte[] sizeBytes;
    public static final int DEF_INIT_BUF_SIZE = 1024;

    public QObjectOutputStream(OutputStream out) {
        this(out, 1024);
    }

    public QObjectOutputStream(OutputStream out, int initialBufSize) {
        super(out);
        this.baos = new ByteArrayOutputStream(initialBufSize);
        this.dOut = new DataOutputStream(this.baos);
        this.sizeBytes = new byte[4];
    }

    public void writeObject(QExternalizable obj) throws IOException {
        this.baos.reset();
        obj.qWrite(this.dOut);
        this.qWriteInt(this.baos.size());
        this.baos.writeTo(this.out);
    }

    public static final void encodeInt(int val, byte[] bytes, int idx) {
        bytes[idx++] = (byte)(val >>> 24 & 0xFF);
        bytes[idx++] = (byte)(val >>> 16 & 0xFF);
        bytes[idx++] = (byte)(val >>> 8 & 0xFF);
        bytes[idx] = (byte)(val >>> 0 & 0xFF);
    }

    public final void qWriteInt(int val) throws IOException {
        QObjectOutputStream.encodeInt(val, this.sizeBytes, 0);
        this.out.write(this.sizeBytes);
    }
}

