/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import oracle.aurora.util.AlarmHandler;

public class Alarm {
    protected long time;
    protected AlarmHandler handler;
    Object callback;
    Alarm next;

    public Alarm(long time, AlarmHandler handler) {
        this(time, handler, null);
    }

    public Alarm(long time, AlarmHandler handler, Object callback) {
        this.time = time;
        this.handler = handler;
        this.callback = callback;
    }

    public Alarm(AlarmHandler handler) {
        this.handler = handler;
    }

    public void fire() {
        this.handler.handleAlarm(this);
    }

    public Object getCallback() {
        return this.callback;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setTimeFromNow(long time) {
        this.time = System.currentTimeMillis() + time;
    }
}

