/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.aurora.server.tools.loadjava.LoadJavaLog;
import oracle.aurora.server.tools.loadjava.LoadJavaOptions;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.SchemaObject;
import oracle.aurora.util.msg.Msg;
import oracle.jdbc.driver.OracleLog;

class JdbcOperations {
    private Msg mkMsg = MkMsg.mkMsg;
    private PreparedStatement stmtSysObj = null;
    private int ebcdicShortening = 0;
    private LoadJavaState state = null;
    static final String lobTableName = "CREATE$JAVA$LOB$TABLE";
    static final String md5TableName = "JAVA$CLASS$MD5$TABLE";
    private boolean replaceAllowedInCreatePublicSynonymIniitialized = false;
    private boolean replaceAllowedInCreatePublicSynonym;

    JdbcOperations(LoadJavaState state) {
        this.state = state;
    }

    static String lobTable(String schema) {
        return JdbcOperations.schemaAsPrefix(schema) + lobTableName;
    }

    static String md5Table(String schema) {
        return JdbcOperations.schemaAsPrefix(schema) + md5TableName;
    }

    static String doubleQuote(String w) {
        return "\"" + w + "\"";
    }

    static String singleQuote(String w) {
        return "'" + w + "'";
    }

    static String schemaAsPrefix(String sName) {
        String prefix = "";
        if (sName != null && sName.length() > 0) {
            prefix = JdbcOperations.doubleQuote(sName) + ".";
        }
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteMD5(SchemaObject schemaObject) {
        this.getState().createMD5Table(schemaObject.getSchema());
        Connection conn = this.getState().getConnection();
        String classname = schemaObject.getNameForMD5Table();
        int type = schemaObject.getType();
        Statement stmt = null;
        boolean ok = true;
        schemaObject.getJdbc();
        String tableName = JdbcOperations.md5Table(schemaObject.getSchema());
        try {
            try {
                stmt = conn.createStatement();
                stmt.executeUpdate("DELETE FROM " + tableName + " WHERE NAME = '" + classname + "'");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.getState().err(e, this.mkMsg.m("deleting MD5 of {0}", classname));
            ok = false;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateMD5(SchemaObject schemaObject, byte[] newMD5) {
        this.getState().createMD5Table(schemaObject.getSchema());
        String when = this.mkMsg.m("updating MD5 of {0}", schemaObject.toString());
        schemaObject.getJdbc();
        String tableName = JdbcOperations.md5Table(schemaObject.getSchema());
        Connection conn = this.getState().getConnection();
        String classname = schemaObject.getNameForMD5Table();
        int type = schemaObject.getType();
        PreparedStatement pstmt = null;
        boolean done = false;
        try {
            try {
                if (newMD5 != null) {
                    pstmt = conn.prepareStatement("INSERT INTO " + tableName + " (NAME, MD5) VALUES(?, ?)");
                    pstmt.setString(1, classname);
                    pstmt.setBytes(2, newMD5);
                    pstmt.executeUpdate();
                    done = true;
                }
            }
            finally {
                schemaObject.closeStatement(pstmt, when);
            }
        }
        catch (SQLException e) {
            this.getState().err(e, when);
        }
        return done;
    }

    public boolean clearAllGrants(SchemaObject sObj) {
        Enumeration g = this.allGrantees(sObj);
        boolean ok = true;
        while (g.hasMoreElements()) {
            String grantee = (String)g.nextElement();
            ok = ok && this.revoke(sObj, grantee);
        }
        return ok;
    }

    public boolean revoke(SchemaObject schemaObject, String grantee) {
        this.msg(this.mkMsg.m("revoking : execute on {0} from {1}", schemaObject.toString(), grantee));
        String schema = schemaObject.getSchema();
        String sql = "REVOKE EXECUTE ON " + this.DDLName(schemaObject) + " FROM " + grantee;
        return this.executeDDL(sql, "revoking execute from " + grantee);
    }

    public Enumeration allGrantees(SchemaObject schemaObject) {
        String schema = schemaObject.getSchema();
        String table = schema == null ? "USER_TAB_PRIVS" : "ALL_TAB_PRIVS";
        String condition = "PRIVILEGE = 'EXECUTE' AND TABLE_NAME = " + JdbcOperations.singleQuote(schemaObject.getShortname());
        if (schema != null) {
            condition = condition + " AND TABLE_NAME = " + JdbcOperations.singleQuote(schema);
        }
        String what = "looking for users with execute on " + schemaObject;
        return this.executeSelect("DISTINCT GRANTEE", table, condition, what);
    }

    public boolean dropSynonym(SchemaObject schemaObject) {
        boolean ok;
        block2: {
            String classname = schemaObject.getName();
            ok = true;
            try {
                this.executeDDL("drop public synonym \"" + classname + "\"");
            }
            catch (SQLException e) {
                if (1432 == e.getErrorCode()) break block2;
                this.getState().err(e, this.mkMsg.m("dropping synonym {0}", classname));
                ok = false;
            }
        }
        return ok;
    }

    public boolean synonym(SchemaObject schemaObject) {
        boolean ok;
        String classname;
        String shortEnoughName = classname = schemaObject.getName();
        if (this.ebcdicShortening != 2) {
            if (this.ebcdicShortening == 0) {
                int n = this.ebcdicShortening = schemaObject.useEbcdicShortening() ? 1 : 2;
            }
            if (this.ebcdicShortening == 1) {
                shortEnoughName = schemaObject.getShortname();
            }
        }
        String shortEnoughNameForTarget = schemaObject.getPerhapsJarQualifiedName();
        if (this.ebcdicShortening == 1) {
            shortEnoughNameForTarget = shortEnoughName;
        }
        LoadJavaOptions opts = (LoadJavaOptions)this.getState().getOpts();
        String loadSchema = opts.getLoadSchema();
        String targetName = JdbcOperations.schemaAsPrefix(loadSchema) + JdbcOperations.doubleQuote(shortEnoughNameForTarget);
        String targetNameForMsg = loadSchema == null ? classname : loadSchema + "." + classname;
        this.msg(this.mkMsg.m("synonym  : {0}", targetNameForMsg));
        if (!this.replaceAllowedInCreatePublicSynonymIniitialized) {
            block9: {
                this.replaceAllowedInCreatePublicSynonym = true;
                try {
                    this.executeDDL("create or replace public synonym");
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 922) break block9;
                    this.replaceAllowedInCreatePublicSynonym = false;
                }
            }
            this.replaceAllowedInCreatePublicSynonymIniitialized = true;
        }
        if (!this.replaceAllowedInCreatePublicSynonym) {
            this.dropSynonym(schemaObject);
        }
        if (ok = this.executeDDL("create " + (this.replaceAllowedInCreatePublicSynonym ? "or replace " : "") + "public synonym \"" + shortEnoughName + "\" for " + targetName, this.mkMsg.m("creating public synonym for {0}", targetNameForMsg))) {
            ++this.getState().cr_syn;
        }
        return ok;
    }

    boolean alterDefiner(SchemaObject sObj, boolean flag) {
        String authid = flag ? " DEFINER " : " CURRENT_USER ";
        this.msg(this.mkMsg.m("alter   : setting rights of {0} to {1}", sObj.toString(), authid));
        String name = this.DDLName(sObj);
        return this.executeDDL("ALTER JAVA CLASS " + name + " AUTHID " + authid, "setting definer vs. invoker of " + sObj);
    }

    boolean alterResolver(SchemaObject sObj, String resolverSpec) {
        String what = this.mkMsg.m("setting resolver of {0} to {1}", sObj.toString(), resolverSpec);
        this.msg(this.mkMsg.m("alter   : {0}", what));
        return this.executeDDL("ALTER JAVA CLASS " + this.DDLName(sObj) + " RESOLVER " + resolverSpec + " CHECK ", what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invokeClass(SchemaObject schemaObject) {
        String schema = schemaObject.getSchema();
        String classname = schemaObject.getName();
        boolean done = false;
        Connection conn = this.getState().getConnection();
        this.msg(this.mkMsg.m("invoking  : {0}", classname));
        try {
            CallableStatement invokeStmt = null;
            try {
                invokeStmt = conn.prepareCall("{? = call dbms_java.deploy_invoke(?,?) }");
                invokeStmt.registerOutParameter(1, 12);
                invokeStmt.setString(2, schema);
                invokeStmt.setString(3, classname.replace('/', '.'));
                invokeStmt.execute();
                String result = invokeStmt.getString(1);
                if (result != null) {
                    this.err(this.mkMsg.m("result of invoking class {0}: {1}", classname, result));
                } else {
                    done = true;
                }
            }
            finally {
                this.closeStatement(invokeStmt, this.mkMsg.m("invoking class {0}", classname));
            }
        }
        catch (SQLException e) {
            this.getState().err(e, this.mkMsg.m("invoking class {0}", classname));
        }
        return done;
    }

    boolean userExists(String user) {
        Connection conn = this.getState().getConnection();
        boolean exists = false;
        Statement stmt = null;
        String when = this.mkMsg.m("checking for existence of user {0}", user);
        try {
            stmt = conn.createStatement();
            ResultSet rset = stmt.executeQuery("select count(*) from all_users where username = '" + user + "'");
            rset.next();
            exists = rset.getInt(1) > 0;
            this.closeStatement(stmt, when);
        }
        catch (SQLException sqlex) {
            this.err(sqlex, when);
            this.closeStatement(stmt, when);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tableExists(String table) {
        boolean exists;
        block6: {
            exists = false;
            Connection conn = this.getState().getConnection();
            Statement stmt = null;
            String when = this.mkMsg.m("testing for existence of {0}", table);
            try {
                try {
                    stmt = conn.createStatement();
                    stmt.execute("select * from " + table);
                    exists = true;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLException sqlex) {
                if (this.getLog().checkCode(sqlex, 942)) break block6;
                this.getLog().err(sqlex, when);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void turnVerifier(boolean on) {
        int flag = on ? 1 : 0;
        Connection conn = this.getState().getConnection();
        Statement stmt = null;
        try {
            try {
                stmt = conn.createStatement();
                stmt.execute("call dbms_java.set_verifier(" + flag + ")");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, this.mkMsg.m("turning off verifier"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBTL(String prefix) {
        Connection conn = this.getState().getConnection();
        CallableStatement call = null;
        try {
            try {
                call = conn.prepareCall("begin :1 := dbms_java.init_btl(:2, :3, :4, :5); end;");
                call.registerOutParameter(1, 2);
                call.setString(2, prefix);
                call.setInt(3, 0);
                call.setInt(4, 0);
                call.setInt(5, 0);
                call.execute();
                if (!call.getBoolean(1)) {
                    this.err("Initializing BTL " + prefix);
                }
                call.close();
                call = conn.prepareCall("begin dbms_java.start_btl(); end;");
                call.execute();
            }
            finally {
                if (call != null) {
                    call.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, "initializing and starting btl " + prefix);
        }
    }

    void startJDBCLogging() {
        OracleLog.setTrace((boolean)true);
        Logger.getLogger("global").setLevel(Level.FINEST);
        Logger.getLogger("oracle.jdbc").setLevel(Level.FINEST);
        Logger.getLogger("oracle.jdbc.driver").setLevel(Level.FINEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateBTL(String prefix) {
        Connection conn = this.getState().getConnection();
        CallableStatement call = null;
        try {
            try {
                call = conn.prepareCall("begin dbms_java.terminate_btl(); end;");
                call.execute();
            }
            finally {
                if (call != null) {
                    call.close();
                }
            }
        }
        catch (SQLException e) {
            this.err(e, "terminating btl " + prefix);
        }
    }

    String DDLName(SchemaObject schemaObject) {
        String name = JdbcOperations.schemaAsPrefix(schemaObject.getSchema()) + JdbcOperations.doubleQuote(schemaObject.getName());
        return name;
    }

    boolean executeDDL(String ddl, String what) {
        boolean ok;
        try {
            this.executeDDL(ddl);
            ok = true;
        }
        catch (SQLException sqlex) {
            ok = false;
            this.err(sqlex, what);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeDDL(String ddl) throws SQLException {
        Connection conn = this.getState().getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(ddl);
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    Enumeration executeSelect(String columns, String table, String condition, String what) {
        try {
            return this.executeSelect(columns, table, condition);
        }
        catch (SQLException sqlex) {
            this.err(sqlex, what);
            return new Vector().elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration executeSelect(String columns, String table, String condition) throws SQLException {
        Vector<Object> results = new Vector<Object>();
        if (columns == null) {
            columns = "*";
        }
        if (condition == null) {
            condition = "TRUE";
        }
        Connection conn = this.getState().getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT " + columns + " FROM " + table + " WHERE " + condition);
            while (rs.next()) {
                results.addElement(rs.getObject(1));
            }
            stmt.close();
        }
        finally {
            this.closeStatement(stmt);
        }
        return results.elements();
    }

    void closeStatement(Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
    }

    void closeStatement(Statement stmt, String what) {
        try {
            this.closeStatement(stmt);
        }
        catch (SQLException sqlex) {
            this.err(sqlex, what);
        }
    }

    boolean isSysObj(String objname, int type) {
        ResultSet rset = null;
        try {
            if (this.stmtSysObj == null) {
                this.stmtSysObj = this.getState().getConnection().prepareStatement("select /*+ USE_NL(o,t) */ t.joxftflags from obj$ o, x$joxft t where o.name=? and type#=? and o.obj# = t.joxftobn");
            }
            this.stmtSysObj.setString(1, objname);
            this.stmtSysObj.setInt(2, type);
            rset = this.stmtSysObj.executeQuery();
            if (!rset.next()) {
                return false;
            }
            int flags = rset.getInt(1);
            return (flags & 0x60) != 0;
        }
        catch (SQLException sqlex) {
            if (sqlex.getErrorCode() != 17024 && sqlex.getErrorCode() != 1403) {
                this.err(sqlex, "could not read obj$");
            }
            return false;
        }
    }

    void closeSysObjStmt() {
        if (this.stmtSysObj != null) {
            try {
                this.stmtSysObj.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    LoadJavaState getState() {
        if (this.state == null) {
            this.state = new LoadJavaState();
        }
        return this.state;
    }

    void err(String msg) {
        this.getState().err(msg);
    }

    void err(Exception ex, String when) {
        this.getState().err(ex, when);
    }

    void msg(String msg) {
        this.getState().msg(msg);
    }

    LoadJavaLog getLog() {
        return this.getState().getLog();
    }

    boolean getVerbose() {
        return this.getLog().getOpts().getVerbose();
    }
}

